/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.whatareyouvotingfor.entities;

import com.alexander.whatareyouvotingfor.init.SoundEventInit;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class GlareEntity
extends TameableEntity
implements IAnimatable {
    public static final DataParameter<Integer> GRUMPY_TICKS = EntityDataManager.func_187226_a(GlareEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(GlareEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public GlareEntity(EntityType<? extends GlareEntity> p_i50215_1_, World p_i50215_2_) {
        super(p_i50215_1_, p_i50215_2_);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.func_70903_f(false);
    }

    public static boolean checkMossySpawnRules(EntityType<GlareEntity> p_223318_0_, IWorld p_223318_1_, SpawnReason p_223318_2_, BlockPos p_223318_3_, Random p_223318_4_) {
        return ModList.get().isLoaded("cavesandcliffs") && p_223318_1_.func_180495_p(p_223318_3_.func_177977_b()).func_203425_a((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("cavesandcliffs", "moss_block"))) && p_223318_1_.func_226659_b_(p_223318_3_, 0) > 8;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new DoNothingGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new FlyToDarknessGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 7.5f, 3.0f, false));
        this.field_70714_bg.func_75776_a(8, (Goal)new WanderGoal());
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.func_70902_q() != null && this.canMonsterSpawn(this.func_233580_cy_())) {
            this.setGrumpyTicks(20);
        }
        Vector3d velocity = this.func_213322_ci();
        float groundSpeed = MathHelper.func_76133_a((double)(velocity.field_72450_a * velocity.field_72450_a + velocity.field_72449_c * velocity.field_72449_c));
        if ((double)groundSpeed > 0.1 && this.field_70173_aa % 20 == 0) {
            this.func_184185_a((SoundEvent)SoundEventInit.GLARE_FLY.get(), 0.5f, this.func_70647_i());
        }
        if (this.func_213322_ci().field_72448_b > 0.0 && groundSpeed == 0.0f) {
            this.func_213293_j(0.0, -0.025, 0.0);
        }
        if (this.getGrumpyTicks() > 0) {
            this.setGrumpyTicks(this.getGrumpyTicks() - 1);
        }
    }

    public boolean canMonsterSpawn(BlockPos posAt) {
        return !this.field_70170_p.field_72995_K && MonsterEntity.func_223323_a((IServerWorld)((ServerWorld)this.field_70170_p), (BlockPos)posAt, (Random)this.field_70146_Z);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getGrumpyTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("glare_grumpy", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("glare_fly", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("glare_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        Item item = itemstack.func_77973_b();
        if (!this.func_70909_n() && item == Items.field_222112_pR) {
            if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)p_230254_1_)) {
                this.func_193101_c(p_230254_1_);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.func_70909_n() && this.func_152114_e((LivingEntity)p_230254_1_)) {
            if (item == Items.field_221634_ae && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(1.0f);
                itemstack.func_190918_g(1);
                this.func_184185_a(SoundEvents.field_232699_cR_, 1.0f, 1.5f);
                for (int i = 0; i < 2; ++i) {
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
                }
                return ActionResultType.SUCCESS;
            }
            this.func_233687_w_(!this.func_233685_eM_());
            this.setSitting(!this.isSitting());
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    public boolean func_70877_b(ItemStack p_70877_1_) {
        return false;
    }

    public boolean func_70878_b(AnimalEntity p_70878_1_) {
        return false;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected PathNavigator func_175447_b(World p_175447_1_) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, p_175447_1_){

            public boolean func_188555_b(BlockPos p_188555_1_) {
                return !this.field_75513_b.func_180495_p(p_188555_1_.func_177977_b()).func_196958_f();
            }
        };
        flyingpathnavigator.func_75489_a(10.0);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233822_e_, 3.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f).func_233815_a_(Attributes.field_233818_a_, 15.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233819_b_, 30.0);
    }

    public int func_70627_aG() {
        return 60;
    }

    protected SoundEvent func_184639_G() {
        return this.getGrumpyTicks() > 0 ? (SoundEvent)SoundEventInit.GLARE_GRUMPY.get() : null;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187577_bU;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187571_bR;
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GRUMPY_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74757_a("Sitting", this.isSitting());
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.setSitting(p_70037_1_.func_74767_n("Sitting"));
    }

    public int getGrumpyTicks() {
        return (Integer)this.field_70180_af.func_187225_a(GRUMPY_TICKS);
    }

    public void setGrumpyTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(GRUMPY_TICKS, (Object)p_189794_1_);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean p_189794_1_) {
        this.field_70180_af.func_187227_b(SITTING, (Object)p_189794_1_);
    }

    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public boolean func_70631_g_() {
        return false;
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return GlareEntity.this.getGrumpyTicks() > 0 || GlareEntity.this.func_233685_eM_();
        }
    }

    class FlyToDarknessGoal
    extends Goal {
        public int activeTicks = 0;

        FlyToDarknessGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return GlareEntity.this.func_70902_q() != null && GlareEntity.this.field_70699_by.func_75500_f();
        }

        public boolean func_75253_b() {
            return GlareEntity.this.field_70699_by.func_226337_n_();
        }

        public void func_75249_e() {
            Vector3d vector3d = this.findPos();
            if (vector3d != null) {
                GlareEntity.this.field_70699_by.func_75484_a(GlareEntity.this.field_70699_by.func_179680_a(new BlockPos(vector3d), 1), 1.0);
            } else {
                this.func_75251_c();
            }
        }

        public void func_75246_d() {
            ++this.activeTicks;
            if (this.activeTicks == 600) {
                this.func_75251_c();
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.activeTicks = 0;
        }

        @Nullable
        private Vector3d findPos() {
            Vector3d vector3d = GlareEntity.this.func_70676_i(0.0f);
            int i = 8;
            Object vector3d2 = RandomPositionGenerator.func_191377_b((CreatureEntity)GlareEntity.this, (int)5, (int)2);
            vector3d2 = vector3d2 != null && GlareEntity.this.canMonsterSpawn(new BlockPos(vector3d2.field_72450_a, vector3d2.field_72448_b, vector3d2.field_72449_c)) ? null : RandomPositionGenerator.func_191377_b((CreatureEntity)GlareEntity.this, (int)5, (int)2);
            return vector3d2 != null ? vector3d2 : null;
        }
    }

    class WanderGoal
    extends Goal {
        WanderGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return GlareEntity.this.field_70699_by.func_75500_f() && GlareEntity.this.field_70146_Z.nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return GlareEntity.this.field_70699_by.func_226337_n_();
        }

        public void func_75249_e() {
            Vector3d vector3d = this.findPos();
            if (vector3d != null) {
                GlareEntity.this.field_70699_by.func_75484_a(GlareEntity.this.field_70699_by.func_179680_a(new BlockPos(vector3d), 1), 1.0);
            }
        }

        @Nullable
        private Vector3d findPos() {
            Vector3d vector3d = GlareEntity.this.func_70676_i(0.0f);
            int i = 8;
            Vector3d vector3d2 = RandomPositionGenerator.func_226340_a_((CreatureEntity)GlareEntity.this, (int)8, (int)7, (Vector3d)vector3d, (float)1.5707964f, (int)2, (int)1);
            return vector3d2 != null ? vector3d2 : RandomPositionGenerator.func_226338_a_((CreatureEntity)GlareEntity.this, (int)8, (int)4, (int)-2, (Vector3d)vector3d, (double)1.5707963705062866);
        }
    }
}

