/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.whatareyouvotingfor.entities;

import com.alexander.whatareyouvotingfor.init.SoundEventInit;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class AllayEntity
extends TameableEntity
implements IAnimatable {
    public static final DataParameter<Integer> DROP_TICKS = EntityDataManager.func_187226_a(AllayEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(AllayEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Predicate<ItemEntity> ALLOWED_ITEMS = p_213489_0_ -> !p_213489_0_.func_174874_s() && p_213489_0_.func_70089_S();
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public AllayEntity(EntityType<? extends AllayEntity> p_i50215_1_, World p_i50215_2_) {
        super(p_i50215_1_, p_i50215_2_);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.func_70903_f(false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new DoNothingGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new FindItemsGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new DepositItemsGoal(1.5, 20, 10));
        this.field_70714_bg.func_75776_a(3, (Goal)new ReturnWithItemsGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal(this, 1.0, 7.5f, 3.0f, false){

            public boolean func_75250_a() {
                return super.func_75250_a() && !AllayEntity.this.isCarrying();
            }
        });
        this.field_70714_bg.func_75776_a(8, (Goal)new WanderGoal());
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public boolean wantsToPickUp(ItemEntity p_230293_1_) {
        return p_230293_1_.field_70170_p.func_180495_p(p_230293_1_.func_233580_cy_().func_177977_b()).func_177230_c() != Blocks.field_196586_al && this.func_184586_b(Hand.MAIN_HAND).func_190916_E() < this.func_184586_b(Hand.MAIN_HAND).func_77973_b().func_77639_j() && p_230293_1_.func_92059_d().func_77973_b() == this.func_184586_b(Hand.MAIN_HAND).func_77973_b();
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70170_p.func_217381_Z().func_76320_a("looting");
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.field_70729_aU && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            for (ItemEntity itementity : this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(1.0, 0.5, 1.0))) {
                if (itementity.field_70128_L || itementity.func_92059_d().func_190926_b() || itementity.func_174874_s() || !this.wantsToPickUp(itementity)) continue;
                for (int i = 0; i < itementity.func_92059_d().func_190916_E(); ++i) {
                    if (!this.func_230293_i_(itementity.func_92059_d())) continue;
                    this.func_184586_b(Hand.MAIN_HAND).func_190917_f(1);
                    itementity.func_92059_d().func_190918_g(1);
                    if (itementity.func_92059_d().func_190916_E() != 0) continue;
                    this.func_233630_a_(itementity);
                    this.func_71001_a((Entity)itementity, itementity.func_92059_d().func_190916_E());
                    itementity.func_70106_y();
                }
            }
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
    }

    public void func_70030_z() {
        super.func_70030_z();
        Vector3d velocity = this.func_213322_ci();
        float groundSpeed = MathHelper.func_76133_a((double)(velocity.field_72450_a * velocity.field_72450_a + velocity.field_72449_c * velocity.field_72449_c));
        if (this.getDropTicks() > 0) {
            if (this.getDropTicks() == 20) {
                this.func_184185_a((SoundEvent)SoundEventInit.ALLAY_HAPPY.get(), 1.0f, 1.0f);
            }
            this.setDropTicks(this.getDropTicks() - 1);
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.isSitting()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("allay_sit", Boolean.valueOf(true)));
        } else if (this.getDropTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("allay_drop", Boolean.valueOf(true)));
        } else if (this.isCarrying() && this.getDropTicks() == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("allay_carrying", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("allay_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public boolean isCarrying() {
        return !this.func_184586_b(Hand.MAIN_HAND).func_190926_b();
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        Item item = itemstack.func_77973_b();
        if (!this.func_70909_n() && item == Items.field_151106_aX) {
            if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)p_230254_1_)) {
                this.func_193101_c(p_230254_1_);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.func_70909_n() && this.func_152114_e((LivingEntity)p_230254_1_)) {
            if (item == Items.field_151106_aX && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(1.0f);
                itemstack.func_190918_g(1);
                for (int i = 0; i < 2; ++i) {
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
                }
                return ActionResultType.SUCCESS;
            }
            if (itemstack.func_190926_b() && !this.isCarrying()) {
                this.func_233687_w_(!this.func_233685_eM_());
                this.setSitting(!this.isSitting());
            } else if (!this.field_70170_p.field_72995_K && !itemstack.func_190926_b()) {
                this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)itemstack.func_77973_b()));
                itemstack.func_190918_g(1);
            } else if (!this.field_70170_p.field_72995_K && itemstack.func_190926_b()) {
                this.throwItemsTowardMob(this, (LivingEntity)p_230254_1_, this.func_184586_b(Hand.MAIN_HAND));
                this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_190931_a));
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    private void throwItemsTowardMob(AllayEntity p_234472_0_, LivingEntity p_234472_1_, ItemStack p_234472_2_) {
        this.throwItemsTowardPos(p_234472_0_, p_234472_2_, p_234472_1_.func_213303_ch());
    }

    private void throwItemsTowardPos(AllayEntity p_234476_0_, ItemStack p_234476_1_, Vector3d p_234476_2_) {
        if (!p_234476_1_.func_190926_b()) {
            p_234476_0_.func_184609_a(Hand.OFF_HAND);
            p_234476_0_.setDropTicks(40);
            BrainUtil.func_233865_a_((LivingEntity)p_234476_0_, (ItemStack)p_234476_1_, (Vector3d)p_234476_2_.func_72441_c(0.0, 1.0, 0.0));
        }
    }

    public boolean func_70877_b(ItemStack p_70877_1_) {
        return false;
    }

    public boolean func_70878_b(AnimalEntity p_70878_1_) {
        return false;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected PathNavigator func_175447_b(World p_175447_1_) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, p_175447_1_){

            public boolean func_188555_b(BlockPos p_188555_1_) {
                return !this.field_75513_b.func_180495_p(p_188555_1_.func_177977_b()).func_196958_f();
            }
        };
        flyingpathnavigator.func_75489_a(10.0);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233822_e_, 3.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f).func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233819_b_, 30.0);
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 1.5f;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_191267_hf;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191266_he;
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DROP_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74757_a("Sitting", this.isSitting());
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.setSitting(p_70037_1_.func_74767_n("Sitting"));
    }

    public int getDropTicks() {
        return (Integer)this.field_70180_af.func_187225_a(DROP_TICKS);
    }

    public void setDropTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(DROP_TICKS, (Object)p_189794_1_);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean p_189794_1_) {
        this.field_70180_af.func_187227_b(SITTING, (Object)p_189794_1_);
    }

    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public boolean func_70631_g_() {
        return false;
    }

    @Nullable
    public ItemEntity dropItem(IItemProvider p_199703_1_) {
        return this.dropItem(p_199703_1_, 0);
    }

    @Nullable
    public ItemEntity dropItem(IItemProvider p_199702_1_, int p_199702_2_) {
        return this.dropItem(new ItemStack(p_199702_1_), (float)p_199702_2_);
    }

    @Nullable
    public ItemEntity dropItem(ItemStack p_199701_1_) {
        return this.dropItem(p_199701_1_, 0.0f);
    }

    @Nullable
    public ItemEntity dropItem(ItemStack p_70099_1_, float p_70099_2_) {
        if (p_70099_1_.func_190926_b()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + (double)p_70099_2_, this.func_226281_cx_(), p_70099_1_);
        itementity.func_174869_p();
        if (this.captureDrops() != null) {
            this.captureDrops().add(itementity);
        } else {
            this.field_70170_p.func_217376_c((Entity)itementity);
        }
        itementity.func_213293_j(0.0, 0.0, 0.0);
        return itementity;
    }

    class FindItemsGoal
    extends Goal {
        public FindItemsGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (AllayEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
                return false;
            }
            if (AllayEntity.this.func_70638_az() == null) {
                if (AllayEntity.this.func_70681_au().nextInt(5) != 0) {
                    return false;
                }
                List list = AllayEntity.this.field_70170_p.func_175647_a(ItemEntity.class, AllayEntity.this.func_174813_aQ().func_72314_b(12.5, 8.0, 12.5), ALLOWED_ITEMS);
                boolean flag = false;
                for (int i = 0; i < list.size(); ++i) {
                    if (!AllayEntity.this.wantsToPickUp((ItemEntity)list.get(i))) continue;
                    flag = true;
                }
                return flag && !list.isEmpty();
            }
            return false;
        }

        public void func_75246_d() {
            List list = AllayEntity.this.field_70170_p.func_175647_a(ItemEntity.class, AllayEntity.this.func_174813_aQ().func_72314_b(12.5, 8.0, 12.5), ALLOWED_ITEMS);
            boolean flag = false;
            for (int i = 0; i < list.size(); ++i) {
                if (!AllayEntity.this.wantsToPickUp((ItemEntity)list.get(i))) continue;
                flag = true;
            }
            if (flag && !list.isEmpty()) {
                AllayEntity.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }

        public void func_75249_e() {
            List list = AllayEntity.this.field_70170_p.func_175647_a(ItemEntity.class, AllayEntity.this.func_174813_aQ().func_72314_b(12.5, 8.0, 12.5), ALLOWED_ITEMS);
            boolean flag = false;
            for (int i = 0; i < list.size(); ++i) {
                if (!AllayEntity.this.wantsToPickUp((ItemEntity)list.get(i))) continue;
                flag = true;
            }
            if (flag && !list.isEmpty()) {
                AllayEntity.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    public class DepositItemsGoal
    extends MoveToBlockGoal {
        public DepositItemsGoal(double p_i50737_2_, int p_i50737_4_, int p_i50737_5_) {
            super((CreatureEntity)AllayEntity.this, p_i50737_2_, p_i50737_4_, p_i50737_5_);
        }

        public double func_203110_f() {
            return 0.75;
        }

        protected BlockPos func_241846_j() {
            return new BlockPos((double)this.field_179494_b.func_177958_n(), (double)this.field_179494_b.func_177956_o() + 2.0, (double)this.field_179494_b.func_177952_p());
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 50 == 0;
        }

        protected boolean func_179488_a(IWorldReader p_179488_1_, BlockPos p_179488_2_) {
            BlockState blockstate = p_179488_1_.func_180495_p(p_179488_2_);
            return blockstate.func_203425_a(Blocks.field_196586_al);
        }

        protected int func_203109_a(CreatureEntity p_203109_1_) {
            return 10 + p_203109_1_.func_70681_au().nextInt(30);
        }

        public void func_75246_d() {
            if (this.func_179487_f()) {
                this.onReachedTarget();
            }
            super.func_75246_d();
        }

        protected void onReachedTarget() {
            BlockState blockstate;
            if (ForgeEventFactory.getMobGriefingEvent((World)AllayEntity.this.field_70170_p, (Entity)AllayEntity.this) && (blockstate = AllayEntity.this.field_70170_p.func_180495_p(this.field_179494_b)).func_203425_a(Blocks.field_196586_al)) {
                AllayEntity.this.dropItem(new ItemStack((IItemProvider)AllayEntity.this.func_184586_b(Hand.MAIN_HAND).func_77973_b(), AllayEntity.this.func_184586_b(Hand.MAIN_HAND).func_190916_E() - 1));
                AllayEntity.this.setDropTicks(40);
                AllayEntity.this.func_184614_ca().func_190920_e(1);
                AllayEntity.this.field_70170_p.func_175641_c(this.field_179494_b, blockstate.func_177230_c(), 0, 0);
            }
        }

        public boolean func_75250_a() {
            return !AllayEntity.this.func_70608_bn() && super.func_75250_a() && AllayEntity.this.isCarrying() && AllayEntity.this.func_184614_ca().func_190916_E() > 1;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && AllayEntity.this.isCarrying() && AllayEntity.this.func_184614_ca().func_190916_E() > 1;
        }

        public void func_75249_e() {
            AllayEntity.this.setSitting(false);
            super.func_75249_e();
        }
    }

    class ReturnWithItemsGoal
    extends Goal {
        public ReturnWithItemsGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public void func_75246_d() {
            super.func_75246_d();
            AllayEntity mob = AllayEntity.this;
            LivingEntity owner = AllayEntity.this.func_70902_q();
            if ((double)mob.func_70032_d((Entity)owner) > 2.5) {
                mob.func_70661_as().func_75497_a((Entity)owner, 1.5);
            } else {
                mob.throwItemsTowardMob(mob, owner, new ItemStack((IItemProvider)mob.func_184586_b(Hand.MAIN_HAND).func_77973_b(), mob.func_184586_b(Hand.MAIN_HAND).func_190916_E() - 1));
                mob.func_184614_ca().func_190920_e(1);
            }
        }

        public boolean func_75250_a() {
            return AllayEntity.this.field_70146_Z.nextInt(50) == 0 && AllayEntity.this.func_70902_q() != null && AllayEntity.this.func_70902_q().func_70089_S() && AllayEntity.this.func_70032_d((Entity)AllayEntity.this.func_70902_q()) < 30.0f && AllayEntity.this.isCarrying() && AllayEntity.this.func_184614_ca().func_190916_E() > 1;
        }

        public boolean func_75253_b() {
            return AllayEntity.this.func_70902_q() != null && AllayEntity.this.func_70902_q().func_70089_S() && AllayEntity.this.isCarrying() && AllayEntity.this.func_184614_ca().func_190916_E() > 1;
        }
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return AllayEntity.this.func_233685_eM_() || AllayEntity.this.getDropTicks() > 0;
        }
    }

    class WanderGoal
    extends Goal {
        WanderGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return AllayEntity.this.field_70699_by.func_75500_f() && AllayEntity.this.field_70146_Z.nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return AllayEntity.this.field_70699_by.func_226337_n_();
        }

        public void func_75249_e() {
            Vector3d vector3d = this.findPos();
            if (vector3d != null) {
                AllayEntity.this.field_70699_by.func_75484_a(AllayEntity.this.field_70699_by.func_179680_a(new BlockPos(vector3d), 1), 1.0);
            }
        }

        @Nullable
        private Vector3d findPos() {
            Vector3d vector3d = AllayEntity.this.func_70676_i(0.0f);
            int i = 8;
            Vector3d vector3d2 = RandomPositionGenerator.func_226340_a_((CreatureEntity)AllayEntity.this, (int)8, (int)7, (Vector3d)vector3d, (float)1.5707964f, (int)2, (int)1);
            return vector3d2 != null ? vector3d2 : RandomPositionGenerator.func_226338_a_((CreatureEntity)AllayEntity.this, (int)8, (int)4, (int)-2, (Vector3d)vector3d, (double)1.5707963705062866);
        }
    }
}

