/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.veinmining.veinmining;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import top.theillusivec4.veinmining.config.VeinMiningConfig;

public class VeinMiningEnchantment
extends Enchantment {
    public static final String ID = "veinmining:vein_mining";
    public static final Map<String, Predicate<ItemStack>> PREDICATE_MAP;
    public static final EnchantmentType CATEGORY;

    public VeinMiningEnchantment() {
        super(Enchantment.Rarity.RARE, CATEGORY, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    private static boolean isToolType(ToolType type, ItemStack stack) {
        return stack.getToolTypes().contains(type);
    }

    private static boolean canEnchantItem(Item item) {
        for (String entry : VeinMiningConfig.Enchantment.items) {
            if (item.getRegistryName() == null || !item.getRegistryName().toString().equals(entry)) continue;
            return true;
        }
        return item instanceof ToolItem;
    }

    private static boolean canEnchantItem(ItemStack stack) {
        for (String entry : VeinMiningConfig.Enchantment.items) {
            if (PREDICATE_MAP.getOrDefault(entry, k -> false).test(stack)) {
                return true;
            }
            if (stack.func_77973_b().getRegistryName() == null || !stack.func_77973_b().getRegistryName().toString().equals(entry)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public Enchantment.Rarity func_77324_c() {
        return VeinMiningConfig.Enchantment.rarity;
    }

    public int func_77325_b() {
        return VeinMiningConfig.Enchantment.levels;
    }

    public int func_77321_a(int enchantmentLevel) {
        return VeinMiningConfig.Enchantment.minEnchantabilityBase + VeinMiningConfig.Enchantment.minEnchantabilityPerLevel * (enchantmentLevel - 1);
    }

    public int func_223551_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + 50;
    }

    public boolean func_185261_e() {
        return VeinMiningConfig.Enchantment.isTreasure;
    }

    public boolean func_230309_h_() {
        return VeinMiningConfig.Enchantment.isVillagerTrade;
    }

    public boolean func_230310_i_() {
        return VeinMiningConfig.Enchantment.isLootable;
    }

    protected boolean func_77326_a(Enchantment ench) {
        ResourceLocation rl = ench.getRegistryName();
        if (rl != null && VeinMiningConfig.Enchantment.incompatibleEnchantments.contains(rl.toString())) {
            return false;
        }
        return super.func_77326_a(ench);
    }

    public boolean func_92089_a(@Nonnull ItemStack stack) {
        return VeinMiningEnchantment.canEnchantItem(stack);
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack) {
        return this.func_92089_a(stack) && VeinMiningConfig.Enchantment.canApplyAtEnchantingTable;
    }

    public boolean isAllowedOnBooks() {
        return VeinMiningConfig.Enchantment.canApplyOnBooks;
    }

    static {
        CATEGORY = EnchantmentType.create((String)ID, VeinMiningEnchantment::canEnchantItem);
        HashMap<String, Predicate<ItemStack>> temp = new HashMap<String, Predicate<ItemStack>>();
        temp.put("is:tool", stack -> !stack.getToolTypes().isEmpty());
        temp.put("is:pickaxe", stack -> VeinMiningEnchantment.isToolType(ToolType.PICKAXE, stack));
        temp.put("is:axe", stack -> VeinMiningEnchantment.isToolType(ToolType.AXE, stack));
        temp.put("is:hoe", stack -> VeinMiningEnchantment.isToolType(ToolType.HOE, stack));
        temp.put("is:shovel", stack -> VeinMiningEnchantment.isToolType(ToolType.SHOVEL, stack));
        PREDICATE_MAP = ImmutableMap.copyOf(temp);
    }
}

