/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite.content;

import com.rolfmao.upgradedcore.helpers.TooltipHelper;
import com.rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import com.rolfmao.upgradednetherite.utils.tool.CorruptUtil;
import com.rolfmao.upgradednetherite.utils.tool.EnderUtil;
import com.rolfmao.upgradednetherite.utils.tool.FeatherUtil;
import com.rolfmao.upgradednetherite.utils.tool.FireUtil;
import com.rolfmao.upgradednetherite.utils.tool.GoldUtil;
import com.rolfmao.upgradednetherite.utils.tool.PhantomUtil;
import com.rolfmao.upgradednetherite.utils.tool.PoisonUtil;
import com.rolfmao.upgradednetherite.utils.tool.WaterUtil;
import com.rolfmao.upgradednetherite.utils.tool.WitherUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UpgradedNetheriteArmor
extends ArmorItem {
    public UpgradedNetheriteArmor(IArmorMaterial materialIn, EquipmentSlotType slot, Item.Properties builderIn) {
        super(materialIn, slot, builderIn);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (CorruptUtil.isCorruptArmor(stack) && enchantment == Enchantments.field_185296_A) {
            return false;
        }
        return enchantment.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean p_77663_5_) {
        Map enchantments;
        if (CorruptUtil.isCorruptArmor(stack) && stack.func_77948_v() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)stack) > 0 && (enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack)).containsKey(Enchantments.field_185296_A)) {
            enchantments.remove(Enchantments.field_185296_A);
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
        }
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return GoldUtil.isWearingGoldArmor((PlayerEntity)wearer) && UpgradedNetheriteConfig.EnablePiglinNeutral;
    }

    public boolean isEnderMask(ItemStack stack, PlayerEntity player, EndermanEntity endermanEntity) {
        return EnderUtil.isWearingEnderArmor(player) && UpgradedNetheriteConfig.EnablePreventAnger;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            if (GoldUtil.isGoldArmor(stack)) {
                list.add((Object)stack);
            } else if (FireUtil.isFireArmor(stack)) {
                list.add((Object)stack);
            } else if (EnderUtil.isEnderArmor(stack)) {
                list.add((Object)stack);
            } else if (WaterUtil.isWaterArmor(stack)) {
                list.add((Object)stack);
            } else if (WitherUtil.isWitherArmor(stack)) {
                list.add((Object)stack);
            } else if (PoisonUtil.isPoisonArmor(stack)) {
                list.add((Object)stack);
            } else if (PhantomUtil.isPhantomArmor(stack)) {
                list.add((Object)stack);
            } else if (FeatherUtil.isFeatherArmor(stack)) {
                list.add((Object)stack);
            } else if (CorruptUtil.isCorruptArmor(stack)) {
                list.add((Object)stack);
            } else if (tab == ItemGroup.field_78027_g) {
                list.add((Object)stack);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!UpgradedNetheriteConfig.DisableTooltips) {
            if (Screen.func_231173_s_()) {
                if (GoldUtil.isGoldArmor(stack) && (UpgradedNetheriteConfig.EnablePiglinNeutral || UpgradedNetheriteConfig.EnableLuckBonus)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.SetBonus.TT", (Object[])new Object[]{"\u00a7a\u00a7l" + UpgradedNetheriteConfig.UpgradedPlayerGoldArmorRequireSet});
                    if (UpgradedNetheriteConfig.EnablePiglinNeutral) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Gold_Bonus.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnableLuckBonus) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Gold_Bonus2.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.LuckBonus});
                    }
                } else if (FireUtil.isFireArmor(stack) && (UpgradedNetheriteConfig.EnableFireImmune || UpgradedNetheriteConfig.EnableLavaSpeed)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.SetBonus.TT", (Object[])new Object[]{"\u00a7a\u00a7l" + UpgradedNetheriteConfig.UpgradedPlayerFireArmorRequireSet});
                    if (UpgradedNetheriteConfig.EnableFireImmune) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Fire_Bonus.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnableLavaSpeed) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Fire_Bonus2.TT"));
                    }
                } else if (EnderUtil.isEnderArmor(stack) && (UpgradedNetheriteConfig.EnableVoidSave || UpgradedNetheriteConfig.EnablePreventAnger)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.SetBonus.TT", (Object[])new Object[]{"\u00a7a\u00a7l" + UpgradedNetheriteConfig.UpgradedPlayerEnderArmorRequireSet});
                    if (UpgradedNetheriteConfig.EnableVoidSave) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_Bonus.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnablePreventAnger) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_Bonus2.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnableBreakEnderArmor && UpgradedNetheriteConfig.EnableVoidSave) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_Bonus3.TT"));
                    }
                } else if (WaterUtil.isWaterArmor(stack) && (UpgradedNetheriteConfig.EnableWaterBreath || UpgradedNetheriteConfig.EnableWaterSpeed || UpgradedNetheriteConfig.EnableElderGuardianDebuffImmune)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.SetBonus.TT", (Object[])new Object[]{"\u00a7a\u00a7l" + UpgradedNetheriteConfig.UpgradedPlayerWaterArmorRequireSet});
                    if (UpgradedNetheriteConfig.EnableWaterBreath) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Water_Bonus.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnableWaterSpeed) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Water_Bonus2.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnableElderGuardianDebuffImmune) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Water_Bonus3.TT"));
                    }
                } else if (WitherUtil.isWitherArmor(stack) && UpgradedNetheriteConfig.EnableWitherImmune) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.SetBonus.TT", (Object[])new Object[]{"\u00a7a\u00a7l" + UpgradedNetheriteConfig.UpgradedPlayerWitherArmorRequireSet});
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Wither_Bonus.TT"));
                } else if (PoisonUtil.isPoisonArmor(stack) && (UpgradedNetheriteConfig.EnablePoisonImmune || UpgradedNetheriteConfig.EnableClimbWall)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.SetBonus.TT", (Object[])new Object[]{"\u00a7a\u00a7l" + UpgradedNetheriteConfig.UpgradedPlayerPoisonArmorRequireSet});
                    if (UpgradedNetheriteConfig.EnablePoisonImmune) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Poison_Bonus.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnableClimbWall) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Poison_Bonus2.TT"));
                    }
                } else if (PhantomUtil.isPhantomArmor(stack) && (UpgradedNetheriteConfig.EnableFallImmune || UpgradedNetheriteConfig.EnableStepHeight)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.SetBonus.TT", (Object[])new Object[]{"\u00a7a\u00a7l" + UpgradedNetheriteConfig.UpgradedPlayerPhantomArmorRequireSet});
                    if (UpgradedNetheriteConfig.EnableFallImmune) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Phantom_Bonus.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnableStepHeight) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Phantom_Bonus2.TT"));
                    }
                } else if (FeatherUtil.isFeatherArmor(stack) && (UpgradedNetheriteConfig.EnableWaterLavaWalking || UpgradedNetheriteConfig.EnableMultiJump || UpgradedNetheriteConfig.EnableReduceFallDamage || UpgradedNetheriteConfig.EnableLevitationImmune)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.SetBonus.TT", (Object[])new Object[]{"\u00a7a\u00a7l" + UpgradedNetheriteConfig.UpgradedPlayerFeatherArmorRequireSet});
                    if (UpgradedNetheriteConfig.EnableWaterLavaWalking) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Feather_Bonus.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnableMultiJump) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Feather_Bonus2.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnableReduceFallDamage) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Feather_Bonus3.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnableLevitationImmune) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Feather_Bonus4.TT"));
                    }
                } else if (CorruptUtil.isCorruptArmor(stack)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Malus.TT"));
                    if (UpgradedNetheriteConfig.EnableHealthMalus) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Corrupt_Bonus.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.HealthMalus + "%"});
                    }
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Corrupt_Bonus2.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Corrupt_Enchant.TT"));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Disabled.TT"));
                }
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.HoldShift.TT"));
            }
        }
    }
}

