/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.lichtower;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.structures.lichtower.LichTowerPieces;
import twilightforest.structures.lichtower.TowerRoofComponent;
import twilightforest.structures.lichtower.TowerWingComponent;

public class TowerRoofSlabComponent
extends TowerRoofComponent {
    public TowerRoofSlabComponent(TemplateManager manager, CompoundNBT nbt) {
        super(LichTowerPieces.TFLTRS, nbt);
    }

    public TowerRoofSlabComponent(IStructurePieceType piece, CompoundNBT nbt) {
        super(piece, nbt);
    }

    public TowerRoofSlabComponent(IStructurePieceType piece, TFFeature feature, int i, TowerWingComponent wing) {
        super(piece, feature, i);
        this.func_186164_a(wing.func_186165_e());
        this.size = wing.size;
        this.height = this.size / 2;
        this.makeCapBB(wing);
    }

    @Override
    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        return this.makePyramidCap(world, Blocks.field_196627_bs.func_176223_P(), Blocks.field_196666_p.func_176223_P(), sbb);
    }

    protected boolean makePyramidCap(ISeedReader world, BlockState slabType, BlockState woodType, MutableBoundingBox sbb) {
        for (int y = 0; y <= this.height; ++y) {
            int min = 2 * y;
            int max = this.size - 2 * y - 1;
            for (int x = min; x <= max; ++x) {
                for (int z = min; z <= max; ++z) {
                    if (x == min || x == max || z == min || z == max) {
                        this.func_175811_a(world, slabType, x, y, z, sbb);
                        continue;
                    }
                    this.func_175811_a(world, woodType, x, y, z, sbb);
                }
            }
        }
        return true;
    }

    protected boolean makeConnectedCap(ISeedReader world, BlockState slabType, BlockState woodType, MutableBoundingBox sbb) {
        for (int y = 0; y < this.height; ++y) {
            int min = 2 * y;
            int max = this.size - 2 * y - 1;
            for (int x = 0; x <= max; ++x) {
                for (int z = min; z <= max; ++z) {
                    if (x == max || z == min || z == max) {
                        this.func_175811_a(world, slabType, x, y, z, sbb);
                        continue;
                    }
                    this.func_175811_a(world, woodType, x, y, z, sbb);
                }
            }
        }
        return true;
    }
}

