/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.fml.network.PacketDistributor;
import twilightforest.block.TFBlocks;
import twilightforest.client.particle.data.LeafParticleData;
import twilightforest.enums.PlantVariant;
import twilightforest.network.SpawnFallenLeafFromPacket;
import twilightforest.network.TFPacketHandler;

public class TFPlantBlock
extends BushBlock {
    private static final VoxelShape MAYAPPLE_SHAPE = TFPlantBlock.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)13.0, (double)6.0, (double)13.0);
    private static final VoxelShape FALLEN_LEAVES_SHAPE = TFPlantBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public final PlantVariant plantVariant;

    protected TFPlantBlock(PlantVariant plant, AbstractBlock.Properties props) {
        super(props);
        this.plantVariant = plant;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState soil = world.func_180495_p(pos.func_177977_b());
        switch (this.plantVariant) {
            case TORCHBERRY: 
            case ROOT_STRAND: {
                return TFPlantBlock.canPlaceRootAt(world, pos);
            }
            case FALLEN_LEAVES: 
            case MUSHGLOOM: 
            case MOSSPATCH: {
                return soil.func_224755_d((IBlockReader)world, pos, Direction.UP);
            }
        }
        return (world.func_201696_r(pos) >= 3 || world.func_175710_j(pos)) && soil.canSustainPlant((IBlockReader)world, pos.func_177977_b(), Direction.UP, (IPlantable)this);
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader access, BlockPos pos, ISelectionContext context) {
        long seed = (long)(pos.func_177958_n() * 3129871) ^ (long)pos.func_177956_o() * 116129781L ^ (long)pos.func_177952_p();
        seed = seed * seed * 42317861L + seed * 11L;
        if (this.plantVariant == PlantVariant.MOSSPATCH) {
            int xOff0 = (int)(seed >> 12 & 3L);
            int xOff1 = (int)(seed >> 15 & 3L);
            int zOff0 = (int)(seed >> 18 & 3L);
            int zOff1 = (int)(seed >> 21 & 3L);
            boolean xConnect0 = access.func_180495_p(pos.func_177974_f()).func_177230_c() == this && access.func_180495_p(pos.func_177974_f()).func_177230_c() == TFBlocks.moss_patch.get();
            boolean xConnect1 = access.func_180495_p(pos.func_177976_e()).func_177230_c() == this && access.func_180495_p(pos.func_177976_e()).func_177230_c() == TFBlocks.moss_patch.get();
            boolean zConnect0 = access.func_180495_p(pos.func_177968_d()).func_177230_c() == this && access.func_180495_p(pos.func_177978_c()).func_177230_c() == TFBlocks.moss_patch.get();
            boolean zConnect1 = access.func_180495_p(pos.func_177978_c()).func_177230_c() == this && access.func_180495_p(pos.func_177968_d()).func_177230_c() == TFBlocks.moss_patch.get();
            return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(xConnect1 ? 0.0 : (double)((1.0f + (float)xOff1) / 16.0f), 0.0, zConnect1 ? 0.0 : (double)((1.0f + (float)zOff1) / 16.0f), xConnect0 ? 1.0 : (double)((15.0f - (float)xOff0) / 16.0f), 0.0625, zConnect0 ? 1.0 : (double)((15.0f - (float)zOff0) / 16.0f)));
        }
        if (this.plantVariant == PlantVariant.CLOVERPATCH) {
            int xOff0 = (int)(seed >> 12 & 3L);
            int xOff1 = (int)(seed >> 15 & 3L);
            int zOff0 = (int)(seed >> 18 & 3L);
            int zOff1 = (int)(seed >> 21 & 3L);
            int yOff0 = (int)(seed >> 24 & 1L);
            int yOff1 = (int)(seed >> 27 & 1L);
            boolean xConnect0 = access.func_180495_p(pos.func_177974_f()).func_177230_c() == this && access.func_180495_p(pos.func_177974_f()).func_177230_c() == TFBlocks.clover_patch.get();
            boolean xConnect1 = access.func_180495_p(pos.func_177976_e()).func_177230_c() == this && access.func_180495_p(pos.func_177976_e()).func_177230_c() == TFBlocks.clover_patch.get();
            boolean zConnect0 = access.func_180495_p(pos.func_177968_d()).func_177230_c() == this && access.func_180495_p(pos.func_177978_c()).func_177230_c() == TFBlocks.clover_patch.get();
            boolean zConnect1 = access.func_180495_p(pos.func_177978_c()).func_177230_c() == this && access.func_180495_p(pos.func_177968_d()).func_177230_c() == TFBlocks.clover_patch.get();
            return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(xConnect1 ? 0.0 : (double)((1.0f + (float)xOff1) / 16.0f), 0.0, zConnect1 ? 0.0 : (double)((1.0f + (float)zOff1) / 16.0f), xConnect0 ? 1.0 : (double)((15.0f - (float)xOff0) / 16.0f), (double)((1.0f + (float)yOff0 + (float)yOff1) / 16.0f), zConnect0 ? 1.0 : (double)((15.0f - (float)zOff0) / 16.0f)));
        }
        if (this.plantVariant == PlantVariant.MAYAPPLE) {
            return MAYAPPLE_SHAPE;
        }
        if (this.plantVariant == PlantVariant.FALLEN_LEAVES) {
            return FALLEN_LEAVES_SHAPE;
        }
        return VoxelShapes.func_197868_b();
    }

    public static boolean canPlaceRootAt(IWorldReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos.func_177984_a());
        if (state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151577_b) {
            return true;
        }
        return state.func_177230_c() == TFBlocks.root_strand.get() || state == ((Block)TFBlocks.root.get()).func_176223_P();
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c() == this) {
            switch (this.plantVariant) {
                case MUSHGLOOM: 
                case MOSSPATCH: {
                    return PlantType.CAVE;
                }
            }
            return PlantType.PLAINS;
        }
        return PlantType.PLAINS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        super.func_180655_c(state, world, pos, random);
        if (state.func_177230_c() == TFBlocks.moss_patch.get() && random.nextInt(10) == 0) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197596_G, (double)((float)pos.func_177958_n() + random.nextFloat()), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + random.nextFloat()), 0.0, 0.0, 0.0);
        } else if (state.func_177230_c() == TFBlocks.fallen_leaves.get() && random.nextInt(50) == 0) {
            float dist = 10.0f;
            if (!world.func_175710_j(pos)) {
                int y = 0;
                while ((float)y <= dist) {
                    if (world.func_180495_p(pos.func_177981_b(y)).func_185904_a() == Material.field_151584_j) {
                        dist = y;
                        break;
                    }
                    ++y;
                }
                if (dist > 10.0f) {
                    return;
                }
            }
            int color = Minecraft.func_71410_x().func_184125_al().func_228054_a_(Blocks.field_196642_W.func_176223_P(), (IBlockDisplayReader)world, pos, 0);
            int r = MathHelper.func_76125_a((int)((color >> 16 & 0xFF) + this.RANDOM.nextInt(34) - 17), (int)0, (int)255);
            int g = MathHelper.func_76125_a((int)((color >> 8 & 0xFF) + this.RANDOM.nextInt(34) - 17), (int)0, (int)255);
            int b = MathHelper.func_76125_a((int)((color & 0xFF) + this.RANDOM.nextInt(34) - 17), (int)0, (int)255);
            world.func_195594_a((IParticleData)new LeafParticleData(r, g, b), (double)((float)pos.func_177958_n() + random.nextFloat()), (double)((float)pos.func_177956_o() + dist - 0.25f), (double)((float)pos.func_177952_p() + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    @Deprecated
    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, world, pos, entityIn);
        if (state.func_177230_c() == TFBlocks.fallen_leaves.get() && entityIn instanceof LivingEntity && (entityIn.func_213322_ci().func_82615_a() != 0.0 || entityIn.func_213322_ci().func_82616_c() != 0.0) && this.RANDOM.nextBoolean()) {
            if (world.field_72995_K) {
                int color = Minecraft.func_71410_x().func_184125_al().func_228054_a_(Blocks.field_196642_W.func_176223_P(), (IBlockDisplayReader)world, pos, 0);
                int r = MathHelper.func_76125_a((int)((color >> 16 & 0xFF) + this.RANDOM.nextInt(34) - 17), (int)0, (int)255);
                int g = MathHelper.func_76125_a((int)((color >> 8 & 0xFF) + this.RANDOM.nextInt(34) - 17), (int)0, (int)255);
                int b = MathHelper.func_76125_a((int)((color & 0xFF) + this.RANDOM.nextInt(34) - 17), (int)0, (int)255);
                world.func_195594_a((IParticleData)new LeafParticleData(r, g, b), (double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat()), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat()), (double)(world.field_73012_v.nextFloat() * -0.5f) * entityIn.func_213322_ci().func_82615_a(), (double)(world.field_73012_v.nextFloat() * 0.5f + 0.25f), (double)(world.field_73012_v.nextFloat() * -0.5f) * entityIn.func_213322_ci().func_82616_c());
            } else if (world instanceof ServerWorld) {
                TFPacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entityIn), (Object)new SpawnFallenLeafFromPacket(pos, entityIn.func_213322_ci()));
            }
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77973_b() == ((Block)TFBlocks.clover_patch.get()).func_199767_j()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("twilightforest.misc.nyi"));
        } else if (stack.func_77973_b() == ((Block)TFBlocks.moss_patch.get()).func_199767_j()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("twilightforest.misc.wip0"));
            tooltip.add((ITextComponent)new TranslationTextComponent("twilightforest.misc.wip1"));
        }
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }
}

