/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GiantBlock
extends Block {
    private boolean isSelfDestructing;

    public GiantBlock(AbstractBlock.Properties props) {
        super(props);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        for (BlockPos dPos : GiantBlock.getVolume(ctx.func_195995_a())) {
            if (ctx.func_195991_k().func_180495_p(dPos).func_196953_a(ctx)) continue;
            return null;
        }
        return this.func_176223_P();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!world.field_72995_K) {
            for (BlockPos dPos : GiantBlock.getVolume(pos)) {
                world.func_175656_a(dPos, this.func_176223_P());
            }
        }
    }

    @Deprecated
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        if (!this.isSelfDestructing && !this.isVolumeFilled(world, pos)) {
            this.setGiantBlockToAir(world, pos);
        }
    }

    private void setGiantBlockToAir(World world, BlockPos pos) {
        this.isSelfDestructing = true;
        for (BlockPos iterPos : GiantBlock.getVolume(pos)) {
            if (pos.equals((Object)iterPos) || world.func_180495_p(iterPos).func_177230_c() != this) continue;
            world.func_175655_b(iterPos, false);
        }
        this.isSelfDestructing = false;
    }

    private boolean isVolumeFilled(World world, BlockPos pos) {
        for (BlockPos dPos : GiantBlock.getVolume(pos)) {
            if (world.func_180495_p(dPos).func_177230_c() == this) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public static Iterable<BlockPos> getVolume(BlockPos pos) {
        return BlockPos.func_191531_b((int)(pos.func_177958_n() & 0xFFFFFFFC), (int)(pos.func_177956_o() & 0xFFFFFFFC), (int)(pos.func_177952_p() & 0xFFFFFFFC), (int)(pos.func_177958_n() | 3), (int)(pos.func_177956_o() | 3), (int)(pos.func_177952_p() | 3));
    }
}

