/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster;

import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.command.CommandSource;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.xalcon.torchmaster.TorchmasterConfig;
import net.xalcon.torchmaster.common.EntityFilterRegistry;
import net.xalcon.torchmaster.common.ModBlocks;
import net.xalcon.torchmaster.common.ModCaps;
import net.xalcon.torchmaster.common.commands.CommandTorchmaster;
import net.xalcon.torchmaster.compat.VanillaCompat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="torchmaster")
public class Torchmaster {
    public static final String MODID = "torchmaster";
    public static final Logger Log = LogManager.getLogger();
    public static MinecraftServer server;
    public static final EntityFilterRegistry MegaTorchFilterRegistry;
    public static final EntityFilterRegistry DreadLampFilterRegistry;

    public Torchmaster() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.LOWEST, this::postInit);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, TorchmasterConfig.spec, "torchmaster.toml");
    }

    private void setup(FMLCommonSetupEvent event) {
        ModCaps.registerModCaps();
    }

    private void postInit(FMLLoadCompleteEvent event) {
        VanillaCompat.registerTorchEntities(MegaTorchFilterRegistry);
        VanillaCompat.registerDreadLampEntities(DreadLampFilterRegistry);
        Log.info("Applying mega torch entity block list overrides...");
        MegaTorchFilterRegistry.applyListOverrides(((List)TorchmasterConfig.GENERAL.megaTorchEntityBlockListOverrides.get()).toArray(new String[0]));
        Log.info("Applying dread lamp entity block list overrides...");
        DreadLampFilterRegistry.applyListOverrides(((List)TorchmasterConfig.GENERAL.dreadLampEntityBlockListOverrides.get()).toArray(new String[0]));
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        Log.info("Got game settings {}", (Object)((Minecraft)event.getMinecraftSupplier().get()).field_71474_y);
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.blockDreadLamp, (RenderType)RenderType.func_228643_e_());
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        server = event.getServer();
        CommandTorchmaster.register((CommandDispatcher<CommandSource>)server.func_195571_aL().func_197054_a());
    }

    @SubscribeEvent
    public void onServerStopping(FMLServerStoppingEvent event) {
        server = null;
    }

    static {
        MegaTorchFilterRegistry = new EntityFilterRegistry();
        DreadLampFilterRegistry = new EntityFilterRegistry();
    }
}

