/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.util.capability;

import com.legacy.structure_gel.util.capability.GelCapability;
import com.legacy.structure_gel.util.capability.GelEntity;
import com.legacy.structure_gel.util.capability.IGelEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class GelEntityProvider
implements ICapabilitySerializable<CompoundNBT> {
    private final GelEntity entity = new GelEntity();
    private final LazyOptional<IGelEntity> playerOptional = LazyOptional.of(() -> this.entity);

    public void invalidate() {
        this.playerOptional.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == GelCapability.INSTANCE ? this.playerOptional.cast() : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        if (GelCapability.INSTANCE == null) {
            return new CompoundNBT();
        }
        return (CompoundNBT)GelCapability.INSTANCE.writeNBT((Object)this.entity, null);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (GelCapability.INSTANCE != null) {
            GelCapability.INSTANCE.readNBT((Object)this.entity, null, (INBT)nbt);
        }
    }
}

