/*
 * Decompiled with CFR 0.152.
 */
package wolforce.simpleshops;

import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import wolforce.simpleshops.SimpleShopTileEntity;

public class SimpleShopBlock
extends Block {
    private static final float F = 0.0625f;
    private static final VoxelShape shape = VoxelShapes.func_197873_a((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.6875, (double)0.9375);
    private boolean isCreative;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.field_208157_J;

    public SimpleShopBlock(AbstractBlock.Properties props, boolean isCreative) {
        super(props);
        this.isCreative = isCreative;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(FACING, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    protected void fillStateContainer(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)context.func_195992_f());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)SimpleShopTileEntity.TYPE.get()).func_200968_a();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity _te = world.func_175625_s(pos);
        if (!(_te instanceof SimpleShopTileEntity)) {
            return;
        }
        SimpleShopTileEntity te = (SimpleShopTileEntity)_te;
        te.setOwner(entity);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity _te = world.func_175625_s(pos);
        if (!(_te instanceof SimpleShopTileEntity)) {
            return ActionResultType.PASS;
        }
        SimpleShopTileEntity te = (SimpleShopTileEntity)_te;
        if (te.isOwner(this, (LivingEntity)player)) {
            ItemStack handStack = player.func_184586_b(hand);
            if (!handStack.func_190926_b()) {
                ItemStack cost = te.getCost();
                if (cost.func_190926_b()) {
                    te.setCost(handStack);
                } else {
                    ItemStack out = te.getOutputStack();
                    if (this.isCreative) {
                        te.setOutputStack(handStack);
                    } else if (out.func_190926_b()) {
                        player.func_184611_a(hand, te.insertInv(player, handStack));
                    } else if (out.func_77969_a(handStack) && handStack.func_190916_E() >= out.func_190916_E()) {
                        player.func_184611_a(hand, te.insertInv(player, handStack));
                    }
                }
            }
        } else {
            te.tryBuy(player, player.func_184586_b(hand), this.isCreative);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity _te = world.func_175625_s(pos);
        if (!(_te instanceof SimpleShopTileEntity)) {
            return;
        }
        SimpleShopTileEntity te = (SimpleShopTileEntity)_te;
        if (te.isOwner(this, (LivingEntity)player)) {
            if (player.func_225608_bj_()) {
                te.dropShop(player, pos);
            } else {
                te.popGains(player);
            }
        }
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return shape;
    }

    public void func_190948_a(ItemStack stack, IBlockReader world, List<ITextComponent> lines, ITooltipFlag f) {
        super.func_190948_a(stack, world, lines, f);
        lines.add((ITextComponent)new StringTextComponent("Set the cost with Right Click"));
        lines.add((ITextComponent)new StringTextComponent("Insert stacks to sell with Right Click"));
        lines.add((ITextComponent)new StringTextComponent("Withdraw profits with Left Click"));
        lines.add((ITextComponent)new StringTextComponent("Clear/Drop shop with Shift Left Click"));
        if (this.isCreative) {
            lines.add((ITextComponent)new StringTextComponent("Creative Simple Shops can only be set/changed in Creative Mode."));
        }
    }
}

