/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.whatareyouvotingfor.models;

import com.alexander.whatareyouvotingfor.entities.CopperGolemEntity;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class CopperGolemModel
extends AnimatedGeoModel {
    public static final ResourceLocation[] COPPER_GOLEM_LOCATIONS = new ResourceLocation[]{new ResourceLocation("whatareyouvotingfor", "textures/entities/copper_golem.png"), new ResourceLocation("whatareyouvotingfor", "textures/entities/exposed_copper_golem.png"), new ResourceLocation("whatareyouvotingfor", "textures/entities/weathered_copper_golem.png"), new ResourceLocation("whatareyouvotingfor", "textures/entities/oxidized_copper_golem.png")};

    public ResourceLocation getAnimationFileLocation(Object entity) {
        return new ResourceLocation("whatareyouvotingfor", "animations/copper_golem.animation.json");
    }

    public ResourceLocation getModelLocation(Object entity) {
        return new ResourceLocation("whatareyouvotingfor", "geo/copper_golem.geo.json");
    }

    public ResourceLocation getTextureLocation(Object entity) {
        return COPPER_GOLEM_LOCATIONS[((CopperGolemEntity)((Object)entity)).getOxidization()];
    }

    public void setLivingAnimations(IAnimatable entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations(entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("head");
        IBone lightning = this.getAnimationProcessor().getBone("lightning");
        CopperGolemEntity entityIn = (CopperGolemEntity)entity;
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        float pulse = 0.0f;
        lightning.setScaleX(pulse += (float)(Math.cos((double)entityIn.field_70173_aa * 3.25) * Math.PI * (double)0.4f));
        lightning.setScaleY(pulse);
        lightning.setScaleZ(pulse);
        if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }
}

