/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.whatareyouvotingfor.entities;

import com.alexander.whatareyouvotingfor.init.BlockInit;
import com.alexander.whatareyouvotingfor.init.SoundEventInit;
import java.util.EnumSet;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class CopperGolemEntity
extends GolemEntity
implements IAnimatable {
    private final EntityPredicate zappedMobsTargeting = new EntityPredicate().func_221013_a(10.0).func_221010_e().func_221011_b();
    public int timeUntilNextCharge = 0;
    public static final DataParameter<Integer> PRESS_BUTTON_TICKS = EntityDataManager.func_187226_a(CopperGolemEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> HEAD_SPIN_TICKS = EntityDataManager.func_187226_a(CopperGolemEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> OXIDIZATION = EntityDataManager.func_187226_a(CopperGolemEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> WAXED = EntityDataManager.func_187226_a(CopperGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> CHARGED = EntityDataManager.func_187226_a(CopperGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public CopperGolemEntity(EntityType<? extends CopperGolemEntity> p_i50215_1_, World p_i50215_2_) {
        super(p_i50215_1_, p_i50215_2_);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(0, (Goal)new DoNothingGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new PressButtonGoal(1.0, 15, 5));
        this.field_70714_bg.func_75776_a(5, (Goal)new SpinHeadGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.isWaxed() && this.field_70146_Z.nextInt(50) == 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_229428_ah_, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
        }
        if (this.isCharged()) {
            for (LivingEntity entity : this.field_70170_p.func_217374_a(LivingEntity.class, this.zappedMobsTargeting, (LivingEntity)this, this.func_174813_aQ().func_186662_g(10.0))) {
                if (!this.func_70685_l((Entity)entity) || entity == this || this.field_70146_Z.nextInt(50) != 0) continue;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, entity.func_226282_d_(0.5), entity.func_226279_cv_(), entity.func_226287_g_(0.5), 0.0, 0.0, 0.0);
                if (this.field_70170_p.field_72995_K) continue;
                entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 1));
                entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 6.0f);
                entity.func_184185_a(SoundEvents.field_187754_de, 0.5f, 2.0f);
            }
        }
        if (this.timeUntilNextCharge > 0) {
            --this.timeUntilNextCharge;
        }
        if (!this.isWaxed() && !this.field_70170_p.field_72995_K && this.getOxidization() < 3 && this.field_70146_Z.nextInt(288000) == 0) {
            this.setOxidization(this.getOxidization() + 1);
        }
        if (this.getPressButtonTicks() > 0) {
            this.setPressButtonTicks(this.getPressButtonTicks() - 1);
        }
        if (this.getHeadSpinTicks() > 0) {
            this.setHeadSpinTicks(this.getHeadSpinTicks() - 1);
        }
        if (this.getOxidization() == 1) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.2f);
        } else if (this.getOxidization() == 2) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.15f);
        } else if (this.getOxidization() == 3) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        } else {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.25);
        }
    }

    public ITextComponent func_200200_C_() {
        ITextComponent itextcomponent = this.func_200201_e();
        return itextcomponent != null ? CopperGolemEntity.removeAction(itextcomponent) : (this.getOxidization() > 0 || this.isWaxed() ? this.getBonusName() : this.func_225513_by_());
    }

    public String getBonusNameId() {
        if (this.isWaxed()) {
            if (this.getOxidization() == 1) {
                return Util.func_200697_a((String)"entity", (ResourceLocation)new ResourceLocation("waxed_exposed_copper_golem"));
            }
            if (this.getOxidization() == 2) {
                return Util.func_200697_a((String)"entity", (ResourceLocation)new ResourceLocation("waxed_weathered_copper_golem"));
            }
            if (this.getOxidization() == 3) {
                return Util.func_200697_a((String)"entity", (ResourceLocation)new ResourceLocation("waxed_oxidized_copper_golem"));
            }
            return Util.func_200697_a((String)"entity", (ResourceLocation)new ResourceLocation("waxed_copper_golem"));
        }
        if (this.getOxidization() == 1) {
            return Util.func_200697_a((String)"entity", (ResourceLocation)new ResourceLocation("exposed_copper_golem"));
        }
        if (this.getOxidization() == 2) {
            return Util.func_200697_a((String)"entity", (ResourceLocation)new ResourceLocation("weathered_copper_golem"));
        }
        return Util.func_200697_a((String)"entity", (ResourceLocation)new ResourceLocation("oxidized_copper_golem"));
    }

    public ITextComponent getBonusName() {
        return new TranslationTextComponent(this.getBonusNameId());
    }

    public String oxidizationExtra() {
        if (this.getOxidization() == 1) {
            return "exposed_";
        }
        if (this.getOxidization() == 2) {
            return "weathered_";
        }
        return "";
    }

    protected ITextComponent func_225513_by_() {
        return this.func_200600_R().func_212546_e();
    }

    private static ITextComponent removeAction(ITextComponent p_233573_0_) {
        IFormattableTextComponent iformattabletextcomponent = p_233573_0_.func_230531_f_().func_230530_a_(p_233573_0_.func_150256_b().func_240715_a_((ClickEvent)null));
        for (ITextComponent itextcomponent : p_233573_0_.func_150253_a()) {
            iformattabletextcomponent.func_230529_a_(CopperGolemEntity.removeAction(itextcomponent));
        }
        return iformattabletextcomponent;
    }

    protected ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        if (ModList.get().isLoaded("cavesandcliffs") && this.func_110143_aJ() < this.func_110138_aP() && p_230254_1_.func_184586_b(p_230254_2_).func_77973_b() == ForgeRegistries.ITEMS.getValue(new ResourceLocation("cavesandcliffs", "copper_ingot"))) {
            p_230254_1_.func_184586_b(p_230254_2_).func_190918_g(1);
            this.func_184185_a(SoundEvents.field_226143_fP_, 1.0f, 1.5f);
            this.func_70691_i(10.0f);
            return ActionResultType.SUCCESS;
        }
        if (!this.isWaxed() && p_230254_1_.func_184586_b(p_230254_2_).func_77973_b() == Items.field_226635_pU_) {
            this.setWaxed(true);
            this.func_184185_a(SoundEvents.field_226140_eU_, 1.0f, 1.0f);
            p_230254_1_.func_184586_b(p_230254_2_).func_190918_g(1);
            for (int i = 0; i < 10; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_229428_ah_, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.isWaxed() && p_230254_1_.func_184586_b(p_230254_2_).func_77973_b() instanceof AxeItem) {
            this.setWaxed(false);
            this.func_184185_a(SoundEvents.field_203255_y, 1.0f, 1.0f);
            p_230254_1_.func_184586_b(p_230254_2_).func_190918_g(1);
            for (int i = 0; i < 30; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_229428_ah_, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.getOxidization() > 0 && p_230254_1_.func_184586_b(p_230254_2_).func_77973_b() instanceof AxeItem) {
            this.setOxidization(this.getOxidization() - 1);
            this.func_184185_a(SoundEvents.field_203255_y, 1.0f, 1.0f);
            p_230254_1_.func_184586_b(p_230254_2_).func_222118_a(1, (LivingEntity)p_230254_1_, p_220040_1_ -> p_220040_1_.func_213334_d(p_230254_2_));
            for (int i = 0; i < 10; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    public void func_241841_a(ServerWorld p_241841_1_, LightningBoltEntity p_241841_2_) {
        if (this.timeUntilNextCharge <= 0) {
            this.setCharged(true);
            this.timeUntilNextCharge = 100;
        }
        this.setOxidization(0);
        for (int i = 0; i < 20; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
        }
    }

    protected int func_70682_h(int p_70682_1_) {
        return p_70682_1_;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getOxidization() == 3) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("copper_golem_oxidized", Boolean.valueOf(true)));
        } else if (this.getPressButtonTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.oxidizationExtra() + "copper_golem_press_button", Boolean.valueOf(true)));
        } else if (this.getHeadSpinTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.oxidizationExtra() + "copper_golem_head_spin", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.oxidizationExtra() + "copper_golem_walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.oxidizationExtra() + "copper_golem_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233820_c_, 0.5).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233819_b_, 30.0);
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 1.5f;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a((SoundEvent)SoundEventInit.COPPER_GOLEM_STEP.get(), 0.5f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PRESS_BUTTON_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(HEAD_SPIN_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(OXIDIZATION, (Object)0);
        this.field_70180_af.func_187214_a(WAXED, (Object)false);
        this.field_70180_af.func_187214_a(CHARGED, (Object)false);
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("Oxidization", this.getOxidization());
        p_213281_1_.func_74757_a("Waxed", this.isWaxed());
        p_213281_1_.func_74757_a("Charged", this.isCharged());
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.setOxidization(p_70037_1_.func_74762_e("Oxidization"));
        this.setWaxed(p_70037_1_.func_74767_n("Waxed"));
        this.setCharged(p_70037_1_.func_74767_n("Charged"));
    }

    public int getOxidization() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(OXIDIZATION)), (int)0, (int)3);
    }

    public void setOxidization(int p_189794_1_) {
        this.field_70180_af.func_187227_b(OXIDIZATION, (Object)p_189794_1_);
    }

    public int getPressButtonTicks() {
        return (Integer)this.field_70180_af.func_187225_a(PRESS_BUTTON_TICKS);
    }

    public void setPressButtonTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(PRESS_BUTTON_TICKS, (Object)p_189794_1_);
    }

    public int getHeadSpinTicks() {
        return (Integer)this.field_70180_af.func_187225_a(HEAD_SPIN_TICKS);
    }

    public void setHeadSpinTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(HEAD_SPIN_TICKS, (Object)p_189794_1_);
    }

    public boolean isWaxed() {
        return (Boolean)this.field_70180_af.func_187225_a(WAXED);
    }

    public void setWaxed(boolean p_189794_1_) {
        this.field_70180_af.func_187227_b(WAXED, (Object)p_189794_1_);
    }

    public boolean isCharged() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARGED);
    }

    public void setCharged(boolean p_189794_1_) {
        this.field_70180_af.func_187227_b(CHARGED, (Object)p_189794_1_);
    }

    public boolean func_70631_g_() {
        return false;
    }

    class SpinHeadGoal
    extends Goal {
        public SpinHeadGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public void func_75246_d() {
            super.func_75246_d();
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (CopperGolemEntity.this.getOxidization() == 1) {
                CopperGolemEntity.this.setHeadSpinTicks(40);
            } else if (CopperGolemEntity.this.getOxidization() == 2) {
                CopperGolemEntity.this.setHeadSpinTicks(50);
            } else {
                CopperGolemEntity.this.setHeadSpinTicks(30);
            }
        }

        public boolean func_75250_a() {
            return CopperGolemEntity.this.getHeadSpinTicks() <= 0 && CopperGolemEntity.this.field_70146_Z.nextInt(300) == 0;
        }

        public boolean func_75253_b() {
            return CopperGolemEntity.this.getHeadSpinTicks() > 0;
        }
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public void func_75246_d() {
            super.func_75246_d();
        }

        public boolean func_75250_a() {
            return CopperGolemEntity.this.getOxidization() == 3;
        }
    }

    public class PressButtonGoal
    extends MoveToBlockGoal {
        public boolean buttonMarked;
        protected int ticksWaited;

        public PressButtonGoal(double p_i50737_2_, int p_i50737_4_, int p_i50737_5_) {
            super((CreatureEntity)CopperGolemEntity.this, p_i50737_2_, p_i50737_4_, p_i50737_5_);
            this.buttonMarked = false;
        }

        public double func_203110_f() {
            return 2.5;
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 100 == 0;
        }

        protected int func_203109_a(CreatureEntity p_203109_1_) {
            return 10 + p_203109_1_.func_70681_au().nextInt(10);
        }

        protected boolean func_179488_a(IWorldReader p_179488_1_, BlockPos p_179488_2_) {
            BlockState blockstate = p_179488_1_.func_180495_p(p_179488_2_);
            if (CopperGolemEntity.this.field_70146_Z.nextInt(75) == 0) {
                this.buttonMarked = true;
            }
            return this.buttonMarked && blockstate.func_203425_a((Block)BlockInit.COPPER_BUTTON.get()) && (Boolean)blockstate.func_177229_b((Property)AbstractButtonBlock.field_176584_b) == false;
        }

        public void func_75246_d() {
            if (CopperGolemEntity.this.getOxidization() == 1) {
                if (this.func_179487_f()) {
                    if (this.ticksWaited >= 25) {
                        if (this.ticksWaited == 25) {
                            CopperGolemEntity.this.func_184185_a(SoundEvents.field_187839_fV, 1.0f, 1.0f);
                        }
                        this.onReachedTarget();
                    } else {
                        if (CopperGolemEntity.this.getPressButtonTicks() <= 0) {
                            CopperGolemEntity.this.setPressButtonTicks(30);
                        }
                        ++this.ticksWaited;
                    }
                }
            } else if (CopperGolemEntity.this.getOxidization() == 2) {
                if (this.func_179487_f()) {
                    if (this.ticksWaited >= 30) {
                        if (this.ticksWaited == 30) {
                            CopperGolemEntity.this.func_184185_a(SoundEvents.field_187839_fV, 1.0f, 1.0f);
                        }
                        this.onReachedTarget();
                    } else {
                        if (CopperGolemEntity.this.getPressButtonTicks() <= 0) {
                            CopperGolemEntity.this.setPressButtonTicks(40);
                        }
                        ++this.ticksWaited;
                    }
                }
            } else if (this.func_179487_f()) {
                if (this.ticksWaited >= 20) {
                    if (this.ticksWaited == 20) {
                        CopperGolemEntity.this.func_184185_a(SoundEvents.field_187839_fV, 1.0f, 1.0f);
                    }
                    this.onReachedTarget();
                } else {
                    if (CopperGolemEntity.this.getPressButtonTicks() <= 0) {
                        CopperGolemEntity.this.setPressButtonTicks(25);
                    }
                    ++this.ticksWaited;
                }
            }
            super.func_75246_d();
        }

        protected void onReachedTarget() {
            BlockState blockstate;
            if (ForgeEventFactory.getMobGriefingEvent((World)CopperGolemEntity.this.field_70170_p, (Entity)CopperGolemEntity.this) && (blockstate = CopperGolemEntity.this.field_70170_p.func_180495_p(this.field_179494_b)).func_203425_a((Block)BlockInit.COPPER_BUTTON.get())) {
                this.buttonMarked = false;
                ((AbstractButtonBlock)blockstate.func_177230_c()).func_226910_d_(blockstate, CopperGolemEntity.this.field_70170_p, this.field_179494_b);
                if (CopperGolemEntity.this.isCharged()) {
                    LightningBoltEntity vexentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(CopperGolemEntity.this.field_70170_p);
                    vexentity.func_174828_a(this.field_179494_b, 0.0f, 0.0f);
                    CopperGolemEntity.this.timeUntilNextCharge = 100;
                    ((ServerWorld)CopperGolemEntity.this.field_70170_p).func_242417_l((Entity)vexentity);
                    CopperGolemEntity.this.setCharged(false);
                }
            }
        }

        public boolean func_75250_a() {
            return !CopperGolemEntity.this.func_70608_bn() && super.func_75250_a();
        }

        public void func_75249_e() {
            this.ticksWaited = 0;
            super.func_75249_e();
        }
    }
}

