/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.villagertools;

import com.lothrazar.villagertools.AngerUtils;
import com.lothrazar.villagertools.ModRegistry;
import com.lothrazar.villagertools.entities.FriendGolem;
import com.lothrazar.villagertools.entities.GuardVindicator;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.passive.horse.TraderLlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemEvents {
    @SubscribeEvent
    public void onLivingSetAttackTargetEvent(LivingSetAttackTargetEvent event) {
    }

    @SubscribeEvent
    public void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof GuardVindicator && event.getSource() != null && event.getSource().func_76346_g() instanceof IronGolemEntity) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        IronGolemEntity golem;
        if (event.getEntityLiving() instanceof IronGolemEntity && (golem = (IronGolemEntity)event.getEntityLiving()).func_70638_az() instanceof GuardVindicator) {
            AngerUtils.makeCalmGolem(golem);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getPos() == null || event.getFace() == null) {
            return;
        }
        BlockPos pos = event.getPos().func_177972_a(event.getFace());
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        if (player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return;
        }
        World world = player.field_70170_p;
        if (stack.func_77973_b() == ModRegistry.BADGE.get()) {
            PillagerEntity child = (PillagerEntity)EntityType.field_220350_aJ.func_200721_a(world);
            child.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            child.func_213390_a(pos, world.field_73012_v.nextInt(20) + 10);
            world.func_217376_c((Entity)child);
            child = (PillagerEntity)EntityType.field_220350_aJ.func_200721_a(world);
            child.func_70107_b((double)(pos.func_177958_n() + world.field_73012_v.nextInt(5)), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + world.field_73012_v.nextInt(5)));
            child.func_213390_a(pos, world.field_73012_v.nextInt(20) + 10);
            world.func_217376_c((Entity)child);
            child = (PillagerEntity)EntityType.field_220350_aJ.func_200721_a(world);
            child.func_70107_b((double)(pos.func_177958_n() + world.field_73012_v.nextInt(5)), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + world.field_73012_v.nextInt(5)));
            child.func_213390_a(pos, world.field_73012_v.nextInt(20) + 10);
            world.func_217376_c((Entity)child);
            this.onComplete(player, event.getHand(), stack);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        VillagerEntity vil;
        ItemStack stack = event.getItemStack();
        PlayerEntity player = event.getPlayer();
        if (player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return;
        }
        World world = player.field_70170_p;
        Entity targetEnt = event.getTarget();
        EntityType targetType = targetEnt.func_200600_R();
        BlockPos pos = targetEnt.func_233580_cy_();
        if (stack.func_77973_b() == ModRegistry.CURE.get() && targetType == EntityType.field_200727_aF) {
            ZombieVillagerEntity trader = (ZombieVillagerEntity)targetEnt;
            trader.func_191991_a(player.func_110124_au(), world.field_73012_v.nextInt(2401) + 3600);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.func_77973_b() == ModRegistry.CONTRACT.get() && targetEnt instanceof WanderingTraderEntity) {
            WanderingTraderEntity trader = (WanderingTraderEntity)targetEnt;
            VillagerEntity villagerChild = (VillagerEntity)trader.func_233656_b_(EntityType.field_200756_av, false);
            world.func_217376_c((Entity)villagerChild);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.func_77973_b() == ModRegistry.GEARS.get() && targetType == EntityType.field_200757_aw) {
            IronGolemEntity trader = (IronGolemEntity)targetEnt;
            FriendGolem villagerChild = (FriendGolem)((EntityType)ModRegistry.GOLEM.get()).func_200721_a(world);
            villagerChild.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            world.func_217376_c((Entity)villagerChild);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.func_77973_b() == ModRegistry.DARKNESS.get() && targetEnt instanceof WanderingTraderEntity) {
            WanderingTraderEntity trader = (WanderingTraderEntity)targetEnt;
            EvokerEntity villagerChild = (EvokerEntity)trader.func_233656_b_(EntityType.field_200806_t, false);
            world.func_217376_c((Entity)villagerChild);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.func_77973_b() == ModRegistry.DARKNESS.get() && targetEnt instanceof WanderingTraderEntity) {
            WanderingTraderEntity trader = (WanderingTraderEntity)targetEnt;
            EvokerEntity villagerChild = (EvokerEntity)trader.func_233656_b_(EntityType.field_200806_t, false);
            world.func_217376_c((Entity)villagerChild);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.func_77973_b() == ModRegistry.DARKNESS.get() && targetType == EntityType.field_220351_aK && targetEnt instanceof WanderingTraderEntity) {
            WanderingTraderEntity trader = (WanderingTraderEntity)targetEnt;
            IllusionerEntity villagerChild = (IllusionerEntity)trader.func_233656_b_(EntityType.field_200764_D, false);
            world.func_217376_c((Entity)villagerChild);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.func_77973_b() == ModRegistry.DARKNESS.get() && targetEnt instanceof CowEntity) {
            CowEntity trader = (CowEntity)targetEnt;
            RavagerEntity villagerChild = (RavagerEntity)trader.func_233656_b_(EntityType.field_220352_aU, false);
            world.func_217376_c((Entity)villagerChild);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.func_77973_b() == ModRegistry.DARKNESS.get() && targetType == EntityType.field_200756_av) {
            VillagerEntity vil2 = (VillagerEntity)targetEnt;
            WitchEntity villagerChild = (WitchEntity)vil2.func_233656_b_(EntityType.field_200759_ay, false);
            world.func_217376_c((Entity)villagerChild);
            this.removeEntity(world, (Entity)vil2);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.func_77973_b() == ModRegistry.DARKNESS.get() && targetType == EntityType.field_220350_aJ) {
            PillagerEntity vil3 = (PillagerEntity)targetEnt;
            EvokerEntity villagerChild = (EvokerEntity)vil3.func_233656_b_(EntityType.field_200806_t, false);
            world.func_217376_c((Entity)villagerChild);
            this.removeEntity(world, (Entity)vil3);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.func_77973_b() == ModRegistry.DARKNESS.get() && targetType == ModRegistry.GUARDENTITY.get()) {
            GuardVindicator trader = (GuardVindicator)targetEnt;
            PillagerEntity child = (PillagerEntity)EntityType.field_220350_aJ.func_200721_a(world);
            child.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            child.func_213390_a(pos, world.field_73012_v.nextInt(20) + 10);
            world.func_217376_c((Entity)child);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.func_77973_b() == ModRegistry.GUARD_ITEM.get() && targetEnt instanceof AbstractRaiderEntity) {
            AbstractRaiderEntity trader = (AbstractRaiderEntity)targetEnt;
            GuardVindicator villagerChild = (GuardVindicator)((EntityType)ModRegistry.GUARDENTITY.get()).func_200721_a(world);
            villagerChild.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            villagerChild.func_213390_a(pos, 30);
            world.func_217376_c((Entity)villagerChild);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.func_77973_b() == ModRegistry.GUARD_ITEM.get() && targetType == EntityType.field_200759_ay) {
            WitchEntity trader = (WitchEntity)targetEnt;
            GuardVindicator villagerChild = (GuardVindicator)((EntityType)ModRegistry.GUARDENTITY.get()).func_200721_a(world);
            villagerChild.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            villagerChild.func_213390_a(pos, 30);
            world.func_217376_c((Entity)villagerChild);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.func_77973_b() == ModRegistry.KEY.get() && targetType == EntityType.field_220354_ax) {
            TraderLlamaEntity tradeLlama = (TraderLlamaEntity)targetEnt;
            LlamaEntity llamaChild = (LlamaEntity)tradeLlama.func_233656_b_(EntityType.field_200769_I, false);
            world.func_217376_c((Entity)llamaChild);
            this.removeEntity(world, (Entity)tradeLlama);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.func_77973_b() == ModRegistry.RESTOCK.get() && targetType == EntityType.field_200756_av) {
            VillagerEntity vil4 = (VillagerEntity)targetEnt;
            this.restock(vil4);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.func_77973_b() == ModRegistry.FORGET.get() && targetType == EntityType.field_200756_av) {
            VillagerEntity vil5 = (VillagerEntity)targetEnt;
            vil5.func_213753_a(vil5.func_213700_eh().func_221126_a(VillagerProfession.field_221151_a).func_221135_a(0));
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.func_77973_b() == ModRegistry.KNOWLEDGE.get() && targetType == EntityType.field_200756_av) {
            VillagerEntity vil6 = (VillagerEntity)targetEnt;
            int level = vil6.func_213700_eh().func_221132_c();
            if (level < 5) {
                vil6.func_175554_cu();
                this.onComplete(player, event.getHand(), stack);
            }
        } else if (stack.func_77973_b() == ModRegistry.BRIBE.get() && targetType == EntityType.field_200756_av && (vil = (VillagerEntity)targetEnt).func_223107_f(player) < 100) {
            if (!world.field_72995_K) {
                int before = vil.func_223107_f(player);
                vil.func_213739_a(IReputationType.field_221033_e, (Entity)player);
                vil.func_213739_a(IReputationType.field_221033_e, (Entity)player);
                vil.func_213739_a(IReputationType.field_221033_e, (Entity)player);
                int diff = vil.func_223107_f(player) - before;
                TranslationTextComponent t = new TranslationTextComponent(stack.func_77977_a() + ".rep");
                t.func_240702_b_(diff + "");
                player.func_146105_b((ITextComponent)t, false);
            }
            this.onComplete(player, event.getHand(), stack);
        }
    }

    private void removeEntity(World world, Entity trader) {
        if (world instanceof ServerWorld) {
            ((ServerWorld)world).func_217467_h(trader);
        }
    }

    private void onComplete(PlayerEntity player, Hand hand, ItemStack stack) {
        player.func_184609_a(hand);
        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 30);
        if (player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent(stack.func_77977_a() + ".used"), false);
        }
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
    }

    private void restock(VillagerEntity vil) {
        vil.func_213766_ei();
        CompoundNBT compound = new CompoundNBT();
        compound.func_74772_a("LastRestock", 0L);
        vil.func_70037_a(compound);
    }

    @SubscribeEvent
    public void onVillagerStart(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof VillagerEntity) {
            this.tryAddAi((VillagerEntity)event.getEntity());
        }
    }

    private void tryAddAi(VillagerEntity vil) {
        if (vil.field_70714_bg.field_220892_d.stream().anyMatch(g -> g.func_220772_j() instanceof TemptGoal)) {
            return;
        }
        try {
            vil.field_70714_bg.func_75776_a(2, (Goal)new TemptGoal((CreatureEntity)vil, 0.666, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModRegistry.LURE.get()}), false));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

