/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite_ultimate.content;

import com.google.common.collect.Lists;
import com.rolfmao.upgradedcore.compat.ExternalMods;
import com.rolfmao.upgradedcore.init.ModRarity;
import com.rolfmao.upgradednetherite.UpgradedNetheriteMod;
import com.rolfmao.upgradednetherite.utils.tool.EnderUtil;
import com.rolfmao.upgradednetherite_ultimate.config.UpgradedNetheriteUltimateConfig;
import com.rolfmao.upgradednetherite_ultimate.init.ModItems;
import com.rolfmao.upgradednetherite_ultimate.utils.UltimateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shadows.apotheosis.ench.asm.EnchHooks;

public class UpgradedNetheriteCrossbow
extends CrossbowItem {
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;

    public UpgradedNetheriteCrossbow() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(UpgradedNetheriteMod.TAB).func_208103_a(ModRarity.UPGRADED_ULTIMATE).func_200918_c(652).func_234689_a_());
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return Items.field_234759_km_.equals(repair.func_77973_b());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (stack.func_77973_b() == ModItems.ULTIMATE_UPGRADED_NETHERITE_CROSSBOW.get() && UpgradedNetheriteUltimateConfig.EnableUltimateGoldToolEffect && enchantment == Enchantments.field_185304_p) {
            return true;
        }
        if (stack.func_77973_b() == ModItems.ULTIMATE_UPGRADED_NETHERITE_CROSSBOW.get() && UpgradedNetheriteUltimateConfig.EnableUltimateFireToolEffect && enchantment == Enchantments.field_185311_w) {
            return true;
        }
        return enchantment.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResultType iResult = ActionResultType.PASS;
        if (context.func_195999_j() != null && context.func_195999_j().func_213453_ef() && EnderUtil.isEnderRangedWeapon((ItemStack)context.func_195996_i()) && !context.func_195999_j().func_184811_cZ().func_185141_a(context.func_195996_i().func_77973_b())) {
            iResult = EnderUtil.EnderSetTag((ItemUseContext)context);
        }
        if (iResult == ActionResultType.PASS) {
            return super.func_195939_a(context);
        }
        return iResult;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> list) {
        ItemStack stack;
        if (this.func_194125_a(tab) && UltimateUtil.isUltimateRangedWeapon(stack = new ItemStack((IItemProvider)this))) {
            list.add((Object)stack);
        }
    }

    public Predicate<ItemStack> func_220006_d() {
        return field_220008_b;
    }

    public Predicate<ItemStack> func_220004_b() {
        return field_220007_a;
    }

    public ActionResult<ItemStack> func_77659_a(World p_77659_1_, PlayerEntity p_77659_2_, Hand p_77659_3_) {
        ItemStack itemstack = p_77659_2_.func_184586_b(p_77659_3_);
        if (UpgradedNetheriteCrossbow.isCharged(itemstack)) {
            if (ExternalMods.APOTHEOSIS.isLoaded()) {
                EnchHooks.preArrowFired((ItemStack)itemstack);
            }
            UpgradedNetheriteCrossbow.performShooting(p_77659_1_, (LivingEntity)p_77659_2_, p_77659_3_, itemstack, UpgradedNetheriteCrossbow.getShootingPower(itemstack), 1.0f);
            UpgradedNetheriteCrossbow.setCharged(itemstack, false);
            if (ExternalMods.APOTHEOSIS.isLoaded()) {
                EnchHooks.onArrowFired((ItemStack)itemstack);
            }
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        if (!p_77659_2_.func_213356_f(itemstack).func_190926_b()) {
            if (!UpgradedNetheriteCrossbow.isCharged(itemstack)) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
                p_77659_2_.func_184598_c(p_77659_3_);
            }
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public void func_77615_a(ItemStack p_77615_1_, World p_77615_2_, LivingEntity p_77615_3_, int p_77615_4_) {
        int i = this.func_77626_a(p_77615_1_) - p_77615_4_;
        float f = UpgradedNetheriteCrossbow.getPowerForTime(i, p_77615_1_);
        if (f >= 1.0f && !UpgradedNetheriteCrossbow.isCharged(p_77615_1_) && UpgradedNetheriteCrossbow.tryLoadProjectiles(p_77615_3_, p_77615_1_)) {
            UpgradedNetheriteCrossbow.setCharged(p_77615_1_, true);
            SoundCategory soundcategory = p_77615_3_ instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.HOSTILE;
            p_77615_2_.func_184148_a((PlayerEntity)null, p_77615_3_.func_226277_ct_(), p_77615_3_.func_226278_cu_(), p_77615_3_.func_226281_cx_(), SoundEvents.field_219610_bB, soundcategory, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean tryLoadProjectiles(LivingEntity p_220021_0_, ItemStack p_220021_1_) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222192_G, (ItemStack)p_220021_1_);
        int j = i == 0 ? 1 : 3;
        boolean flag = p_220021_0_ instanceof PlayerEntity && ((PlayerEntity)p_220021_0_).field_71075_bZ.field_75098_d;
        ItemStack itemstack = p_220021_0_.func_213356_f(p_220021_1_);
        ItemStack itemstack1 = itemstack.func_77946_l();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemstack = itemstack1.func_77946_l();
            }
            if (itemstack.func_190926_b() && flag) {
                itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                itemstack1 = itemstack.func_77946_l();
            }
            if (UpgradedNetheriteCrossbow.loadProjectile(p_220021_0_, p_220021_1_, itemstack, k > 0, flag)) continue;
            return false;
        }
        return true;
    }

    private static boolean loadProjectile(LivingEntity p_220023_0_, ItemStack p_220023_1_, ItemStack p_220023_2_, boolean p_220023_3_, boolean p_220023_4_) {
        ItemStack itemstack;
        boolean flag;
        if (p_220023_2_.func_190926_b()) {
            return false;
        }
        boolean bl = flag = p_220023_4_ && p_220023_2_.func_77973_b() instanceof ArrowItem;
        if (!(flag || p_220023_4_ || p_220023_3_)) {
            itemstack = p_220023_2_.func_77979_a(1);
            if (p_220023_2_.func_190926_b() && p_220023_0_ instanceof PlayerEntity) {
                ((PlayerEntity)p_220023_0_).field_71071_by.func_184437_d(p_220023_2_);
            }
        } else {
            itemstack = p_220023_2_.func_77946_l();
        }
        UpgradedNetheriteCrossbow.addChargedProjectile(p_220023_1_, itemstack);
        return true;
    }

    public static boolean isCharged(ItemStack p_220012_0_) {
        CompoundNBT compoundnbt = p_220012_0_.func_77978_p();
        return compoundnbt != null && compoundnbt.func_74767_n("Charged");
    }

    public static void setCharged(ItemStack p_220011_0_, boolean p_220011_1_) {
        CompoundNBT compoundnbt = p_220011_0_.func_196082_o();
        compoundnbt.func_74757_a("Charged", p_220011_1_);
    }

    private static void addChargedProjectile(ItemStack p_220029_0_, ItemStack p_220029_1_) {
        CompoundNBT compoundnbt = p_220029_0_.func_196082_o();
        ListNBT listnbt = compoundnbt.func_150297_b("ChargedProjectiles", 9) ? compoundnbt.func_150295_c("ChargedProjectiles", 10) : new ListNBT();
        CompoundNBT compoundnbt1 = new CompoundNBT();
        p_220029_1_.func_77955_b(compoundnbt1);
        listnbt.add((Object)compoundnbt1);
        compoundnbt.func_218657_a("ChargedProjectiles", (INBT)listnbt);
    }

    private static List<ItemStack> getChargedProjectiles(ItemStack p_220018_0_) {
        ListNBT listnbt;
        ArrayList list = Lists.newArrayList();
        CompoundNBT compoundnbt = p_220018_0_.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("ChargedProjectiles", 9) && (listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt1 = listnbt.func_150305_b(i);
                list.add(ItemStack.func_199557_a((CompoundNBT)compoundnbt1));
            }
        }
        return list;
    }

    private static void clearChargedProjectiles(ItemStack p_220027_0_) {
        CompoundNBT compoundnbt = p_220027_0_.func_77978_p();
        if (compoundnbt != null) {
            ListNBT listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 9);
            listnbt.clear();
            compoundnbt.func_218657_a("ChargedProjectiles", (INBT)listnbt);
        }
    }

    private static void shootProjectile(World world, LivingEntity livingEntity, Hand hand, ItemStack itemStack, ItemStack ammo, float p_220016_5_, boolean p_220016_6_, float p_220016_7_, float p_220016_8_, float p_220016_9_) {
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)livingEntity;
            if (!world.field_72995_K) {
                AbstractArrowEntity projectileentity;
                boolean flag;
                boolean bl = flag = ammo.func_77973_b() == Items.field_196152_dE;
                if (flag) {
                    projectileentity = new FireworkRocketEntity(world, ammo, (Entity)livingEntity, livingEntity.func_226277_ct_(), livingEntity.func_226280_cw_() - (double)0.15f, livingEntity.func_226281_cx_(), true);
                } else {
                    projectileentity = UpgradedNetheriteCrossbow.getArrow(world, livingEntity, itemStack, ammo);
                    if (p_220016_6_ || p_220016_9_ != 0.0f) {
                        projectileentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                    }
                }
                if (livingEntity instanceof ICrossbowUser) {
                    ICrossbowUser icrossbowuser = (ICrossbowUser)livingEntity;
                    icrossbowuser.func_230284_a_(icrossbowuser.func_70638_az(), itemStack, (ProjectileEntity)projectileentity, p_220016_9_);
                } else {
                    Vector3d vector3d1 = livingEntity.func_213286_i(1.0f);
                    Quaternion quaternion = new Quaternion(new Vector3f(vector3d1), p_220016_9_, true);
                    Vector3d vector3d = livingEntity.func_70676_i(1.0f);
                    Vector3f vector3f = new Vector3f(vector3d);
                    vector3f.func_214905_a(quaternion);
                    projectileentity.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), p_220016_7_, p_220016_8_);
                }
                itemStack.func_222118_a(flag ? 3 : 1, livingEntity, p_220017_1_ -> p_220017_1_.func_213334_d(hand));
                if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateGoldToolEffect || itemStack.func_77973_b() != ModItems.ULTIMATE_UPGRADED_NETHERITE_CROSSBOW.get() || itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("UpgradedNetherite_DisableGold"))) {
                    projectileentity.func_184211_a("GoldUpgradedNetheriteBow");
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)itemStack) > 0) {
                        projectileentity.getPersistentData().func_74768_a("LootingGoldUpgradedNetheriteBow", EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)itemStack));
                    }
                }
                if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateFireToolEffect || itemStack.func_77973_b() != ModItems.ULTIMATE_UPGRADED_NETHERITE_CROSSBOW.get() || itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("UpgradedNetherite_DisableFire"))) {
                    projectileentity.func_184211_a("FireUpgradedNetheriteBow");
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)itemStack) > 0) {
                        projectileentity.func_184211_a("FlameFireUpgradedNetheriteBow");
                        projectileentity.func_70015_d(100);
                    }
                }
                if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateEnderToolEffect || itemStack.func_77973_b() != ModItems.ULTIMATE_UPGRADED_NETHERITE_CROSSBOW.get() || itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("UpgradedNetherite_DisableEnder"))) {
                    projectileentity.func_184211_a("EnderUpgradedNetheriteBow");
                    if (itemStack.func_196082_o().func_74767_n("UpgradedNetherite_Tagged")) {
                        projectileentity.getPersistentData().func_74783_a("UpgradedNetherite_Position", itemStack.func_196082_o().func_74759_k("UpgradedNetherite_Position"));
                        projectileentity.getPersistentData().func_74778_a("UpgradedNetherite_Dimension", itemStack.func_196082_o().func_74779_i("UpgradedNetherite_Dimension"));
                        projectileentity.getPersistentData().func_74757_a("UpgradedNetherite_Tagged", itemStack.func_196082_o().func_74767_n("UpgradedNetherite_Tagged"));
                    }
                }
                if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateWaterToolEffect || itemStack.func_77973_b() != ModItems.ULTIMATE_UPGRADED_NETHERITE_CROSSBOW.get() || itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("UpgradedNetherite_DisableWater"))) {
                    projectileentity.func_184211_a("WaterUpgradedNetheriteBow");
                }
                if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateWitherToolEffect || itemStack.func_77973_b() != ModItems.ULTIMATE_UPGRADED_NETHERITE_CROSSBOW.get() || itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("UpgradedNetherite_DisableWither"))) {
                    projectileentity.func_184211_a("WitherUpgradedNetheriteBow");
                }
                if (!(!UpgradedNetheriteUltimateConfig.EnableUltimatePoisonToolEffect || itemStack.func_77973_b() != ModItems.ULTIMATE_UPGRADED_NETHERITE_CROSSBOW.get() || itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("UpgradedNetherite_DisablePoison"))) {
                    projectileentity.func_184211_a("PoisonUpgradedNetheriteBow");
                }
                if (!(!UpgradedNetheriteUltimateConfig.EnableUltimatePhantomToolEffect || itemStack.func_77973_b() != ModItems.ULTIMATE_UPGRADED_NETHERITE_CROSSBOW.get() || itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("UpgradedNetherite_DisablePhantom"))) {
                    projectileentity.func_184211_a("PhantomUpgradedNetheriteBow");
                }
                if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateFeatherToolEffect || itemStack.func_77973_b() != ModItems.ULTIMATE_UPGRADED_NETHERITE_CROSSBOW.get() || itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("UpgradedNetherite_DisableFeather"))) {
                    projectileentity.func_184211_a("FeatherUpgradedNetheriteBow");
                }
                if (itemStack.func_77973_b() == ModItems.ULTIMATE_UPGRADED_NETHERITE_CROSSBOW.get()) {
                    projectileentity.func_184211_a("UltimateUpgradedNetheriteBow");
                }
                if (ExternalMods.APOTHEOSIS.isLoaded()) {
                    EnchHooks.markGeneratedArrows((ProjectileEntity)projectileentity, (ItemStack)itemStack);
                }
                world.func_217376_c((Entity)projectileentity);
                world.func_184148_a((PlayerEntity)null, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, p_220016_5_);
            }
        }
    }

    private static AbstractArrowEntity getArrow(World p_220024_0_, LivingEntity p_220024_1_, ItemStack p_220024_2_, ItemStack p_220024_3_) {
        ArrowItem arrowitem = (ArrowItem)(p_220024_3_.func_77973_b() instanceof ArrowItem ? p_220024_3_.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractarrowentity = arrowitem.func_200887_a(p_220024_0_, p_220024_3_, p_220024_1_);
        if (p_220024_1_ instanceof PlayerEntity) {
            abstractarrowentity.func_70243_d(true);
        }
        abstractarrowentity.func_213869_a(SoundEvents.field_219609_bA);
        abstractarrowentity.func_213865_o(true);
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222194_I, (ItemStack)p_220024_2_);
        if (i > 0) {
            abstractarrowentity.func_213872_b((byte)i);
        }
        return abstractarrowentity;
    }

    public static void performShooting(World p_220014_0_, LivingEntity p_220014_1_, Hand p_220014_2_, ItemStack p_220014_3_, float p_220014_4_, float p_220014_5_) {
        List<ItemStack> list = UpgradedNetheriteCrossbow.getChargedProjectiles(p_220014_3_);
        float[] afloat = UpgradedNetheriteCrossbow.getShotPitches(p_220014_1_.func_70681_au());
        for (int i = 0; i < list.size(); ++i) {
            boolean flag;
            ItemStack itemstack = list.get(i);
            boolean bl = flag = p_220014_1_ instanceof PlayerEntity && ((PlayerEntity)p_220014_1_).field_71075_bZ.field_75098_d;
            if (itemstack.func_190926_b()) continue;
            if (i == 0) {
                UpgradedNetheriteCrossbow.shootProjectile(p_220014_0_, p_220014_1_, p_220014_2_, p_220014_3_, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, 0.0f);
                continue;
            }
            if (i == 1) {
                UpgradedNetheriteCrossbow.shootProjectile(p_220014_0_, p_220014_1_, p_220014_2_, p_220014_3_, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, -10.0f);
                continue;
            }
            if (i != 2) continue;
            UpgradedNetheriteCrossbow.shootProjectile(p_220014_0_, p_220014_1_, p_220014_2_, p_220014_3_, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, 10.0f);
        }
        UpgradedNetheriteCrossbow.onCrossbowShot(p_220014_0_, p_220014_1_, p_220014_3_);
    }

    private static float[] getShotPitches(Random p_220028_0_) {
        boolean flag = p_220028_0_.nextBoolean();
        return new float[]{1.0f, UpgradedNetheriteCrossbow.getRandomShotPitch(flag), UpgradedNetheriteCrossbow.getRandomShotPitch(!flag)};
    }

    private static float getRandomShotPitch(boolean p_220032_0_) {
        float f = p_220032_0_ ? 0.63f : 0.43f;
        return 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.8f) + f;
    }

    private static void onCrossbowShot(World p_220015_0_, LivingEntity p_220015_1_, ItemStack p_220015_2_) {
        if (p_220015_1_ instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)p_220015_1_;
            if (!p_220015_0_.field_72995_K) {
                CriteriaTriggers.field_215099_F.func_215111_a(serverplayerentity, p_220015_2_);
            }
            serverplayerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)p_220015_2_.func_77973_b()));
        }
        UpgradedNetheriteCrossbow.clearChargedProjectiles(p_220015_2_);
    }

    public void func_219972_a(World p_219972_1_, LivingEntity p_219972_2_, ItemStack p_219972_3_, int p_219972_4_) {
        if (!p_219972_1_.field_72995_K) {
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)p_219972_3_);
            SoundEvent soundevent = this.getStartSound(i);
            SoundEvent soundevent1 = i == 0 ? SoundEvents.field_219611_bC : null;
            float f = (float)(p_219972_3_.func_77988_m() - p_219972_4_) / (float)UpgradedNetheriteCrossbow.getChargeDuration(p_219972_3_);
            if (f < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (f >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                p_219972_1_.func_184148_a((PlayerEntity)null, p_219972_2_.func_226277_ct_(), p_219972_2_.func_226278_cu_(), p_219972_2_.func_226281_cx_(), soundevent, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundevent1 != null && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                p_219972_1_.func_184148_a((PlayerEntity)null, p_219972_2_.func_226277_ct_(), p_219972_2_.func_226278_cu_(), p_219972_2_.func_226281_cx_(), soundevent1, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return UpgradedNetheriteCrossbow.getChargeDuration(p_77626_1_) + 3;
    }

    public static int getChargeDuration(ItemStack p_220026_0_) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)p_220026_0_);
        return i == 0 ? 25 : 25 - 5 * i;
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.CROSSBOW;
    }

    private SoundEvent getStartSound(int p_220025_1_) {
        switch (p_220025_1_) {
            case 1: {
                return SoundEvents.field_219613_bE;
            }
            case 2: {
                return SoundEvents.field_219614_bF;
            }
            case 3: {
                return SoundEvents.field_219615_bG;
            }
        }
        return SoundEvents.field_219612_bD;
    }

    private static float getPowerForTime(int p_220031_0_, ItemStack p_220031_1_) {
        float f = (float)p_220031_0_ / (float)UpgradedNetheriteCrossbow.getChargeDuration(p_220031_1_);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        List<ItemStack> list = UpgradedNetheriteCrossbow.getChargedProjectiles(stack);
        if (!UpgradedNetheriteUltimateConfig.DisableTooltips) {
            Item crossbow = stack.func_77973_b();
            if (Screen.func_231173_s_()) {
                if (UltimateUtil.isUltimateRangedWeapon(stack)) {
                    if (!((!UpgradedNetheriteUltimateConfig.EnableUltimateGoldToolEffect || stack.func_77942_o() && stack.func_77978_p().func_74764_b("UpgradedNetherite_DisableGold")) && (!UpgradedNetheriteUltimateConfig.EnableUltimateFireToolEffect || stack.func_77942_o() && stack.func_77978_p().func_74764_b("UpgradedNetherite_DisableFire")) && (!UpgradedNetheriteUltimateConfig.EnableUltimateEnderToolEffect || stack.func_77942_o() && stack.func_77978_p().func_74764_b("UpgradedNetherite_DisableEnder")) && (!UpgradedNetheriteUltimateConfig.EnableUltimateWaterToolEffect || stack.func_77942_o() && stack.func_77978_p().func_74764_b("UpgradedNetherite_DisableWater")) && (!UpgradedNetheriteUltimateConfig.EnableUltimateWitherToolEffect || stack.func_77942_o() && stack.func_77978_p().func_74764_b("UpgradedNetherite_DisableWither")) && (!UpgradedNetheriteUltimateConfig.EnableUltimatePoisonToolEffect || stack.func_77942_o() && stack.func_77978_p().func_74764_b("UpgradedNetherite_DisablePoison")) && (!UpgradedNetheriteUltimateConfig.EnableUltimatePhantomToolEffect || stack.func_77942_o() && stack.func_77978_p().func_74764_b("UpgradedNetherite_DisablePhantom")) && (!UpgradedNetheriteUltimateConfig.EnableUltimateFeatherToolEffect || stack.func_77942_o() && stack.func_77978_p().func_74764_b("UpgradedNetherite_DisableFeather")))) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite_ultimate.BonusFrom.TT"));
                        if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateGoldToolEffect || stack.func_77942_o() && stack.func_77978_p().func_74764_b("UpgradedNetherite_DisableGold"))) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite_ultimate.Golderite.TT"));
                        }
                        if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateFireToolEffect || stack.func_77942_o() && stack.func_77978_p().func_74764_b("UpgradedNetherite_DisableFire"))) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite_ultimate.Blazerite.TT"));
                        }
                        if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateEnderToolEffect || stack.func_77942_o() && stack.func_77978_p().func_74764_b("UpgradedNetherite_DisableEnder"))) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite_ultimate.Enderite.TT"));
                        }
                        if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateWaterToolEffect || stack.func_77942_o() && stack.func_77978_p().func_74764_b("UpgradedNetherite_DisableWater"))) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite_ultimate.Prismarite.TT"));
                        }
                        if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateWitherToolEffect || stack.func_77942_o() && stack.func_77978_p().func_74764_b("UpgradedNetherite_DisableWither"))) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite_ultimate.Witherite.TT"));
                        }
                        if (!(!UpgradedNetheriteUltimateConfig.EnableUltimatePoisonToolEffect || stack.func_77942_o() && stack.func_77978_p().func_74764_b("UpgradedNetherite_DisablePoison"))) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite_ultimate.Spiderite.TT"));
                        }
                        if (!(!UpgradedNetheriteUltimateConfig.EnableUltimatePhantomToolEffect || stack.func_77942_o() && stack.func_77978_p().func_74764_b("UpgradedNetherite_DisablePhantom"))) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite_ultimate.Phanterite.TT"));
                        }
                        if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateFeatherToolEffect || stack.func_77942_o() && stack.func_77978_p().func_74764_b("UpgradedNetherite_DisableFeather"))) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite_ultimate.Featherite.TT"));
                        }
                        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("UpgradedNetherite_Tagged") && stack.func_77978_p().func_74767_n("UpgradedNetherite_Tagged") && (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("UpgradedNetherite_DisableEnder"))) {
                            String world = worldIn.func_234923_W_().func_240901_a_().func_110623_a();
                            if (!world.equals(stack.func_77978_p().func_74779_i("UpgradedNetherite_Dimension"))) {
                                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Target.TT"));
                                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_Dim.TT"));
                                tooltip.add((ITextComponent)new StringTextComponent("\u00a77\u2022 \u00a7c" + stack.func_77978_p().func_74779_i("UpgradedNetherite_Dimension") + "\u00a77 : \u00a73" + stack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[0] + "\u00a77, \u00a73" + stack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[1] + "\u00a77, \u00a73" + stack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[2] + "\u00a77."));
                            } else {
                                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Target.TT"));
                                tooltip.add((ITextComponent)new StringTextComponent("\u00a77\u2022 \u00a79" + stack.func_77978_p().func_74779_i("UpgradedNetherite_Dimension") + "\u00a77 : \u00a73" + stack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[0] + "\u00a77, \u00a73" + stack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[1] + "\u00a77, \u00a73" + stack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[2] + "\u00a77."));
                            }
                        }
                    }
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Disabled.TT"));
                }
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.HoldShift.TT"));
                if (UltimateUtil.isUltimateRangedWeapon(stack) || UpgradedNetheriteUltimateConfig.EnableUltimateEnderToolEffect && UltimateUtil.isUltimateRangedWeapon(stack) && (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("UpgradedNetherite_DisableEnder"))) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("UpgradedNetherite_Tagged") && stack.func_77978_p().func_74767_n("UpgradedNetherite_Tagged")) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_ToolTar.TT"));
                    } else {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_ToolReq.TT"));
                    }
                }
            }
        }
        if (UpgradedNetheriteCrossbow.isCharged(stack) && !list.isEmpty()) {
            ItemStack itemstack = list.get(0);
            tooltip.add((ITextComponent)new TranslationTextComponent("item.minecraft.crossbow.projectile").func_240702_b_(" ").func_230529_a_(itemstack.func_151000_E()));
            if (flagIn.func_194127_a() && itemstack.func_77973_b() == Items.field_196152_dE) {
                ArrayList list1 = Lists.newArrayList();
                Items.field_196152_dE.func_77624_a(itemstack, worldIn, (List)list1, flagIn);
                if (!list1.isEmpty()) {
                    for (int i = 0; i < list1.size(); ++i) {
                        list1.set(i, new StringTextComponent("  ").func_230529_a_((ITextComponent)list1.get(i)).func_240699_a_(TextFormatting.GRAY));
                    }
                    tooltip.addAll(list1);
                }
            }
        }
    }

    private static float getShootingPower(ItemStack p_220013_0_) {
        return p_220013_0_.func_77973_b() == Items.field_222114_py && UpgradedNetheriteCrossbow.func_220019_a((ItemStack)p_220013_0_, (Item)Items.field_196152_dE) ? 2.4f : 4.725f;
    }

    public int func_230305_d_() {
        return 8;
    }
}

