/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite.packets;

import com.rolfmao.upgradednetherite.handlers.EntityFallDistanceUpdateHandler;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketEntityFallDistanceUpdate {
    private Integer entityId;
    private Float fallDistance;

    public PacketEntityFallDistanceUpdate(Integer entityId, Float fallDistance) {
        this.entityId = entityId;
        this.fallDistance = fallDistance;
    }

    public static void encode(PacketEntityFallDistanceUpdate msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId.intValue());
        buf.writeFloat(msg.fallDistance.floatValue());
    }

    public static PacketEntityFallDistanceUpdate decode(PacketBuffer buf) {
        Integer entityId = buf.readInt();
        Float fallDistance = Float.valueOf(buf.readFloat());
        return new PacketEntityFallDistanceUpdate(entityId, fallDistance);
    }

    public static void handle(PacketEntityFallDistanceUpdate msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            Entity entity = player.field_70170_p.func_73045_a(msg.entityId.intValue());
            Float fallDistance = msg.fallDistance;
            EntityFallDistanceUpdateHandler.handleEntityFallDistanceUpdate(entity, fallDistance);
        });
        ctx.get().setPacketHandled(true);
    }
}

