/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite.modifiers;

import com.google.gson.JsonObject;
import com.rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import com.rolfmao.upgradednetherite.utils.ToolUtil;
import com.rolfmao.upgradednetherite.utils.tool.EnderUtil;
import com.rolfmao.upgradednetherite.utils.tool.FireUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class UpgradedNetheriteModifiers {

    public static class EnderTeleportModifier
    extends LootModifier {
        protected EnderTeleportModifier(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            Entity killer = (Entity)context.func_216031_c(LootParameters.field_216285_e);
            Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
            BlockState blockState = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
            Entity arrow = null;
            PlayerEntity player = null;
            if (blockState != null && entity instanceof PlayerEntity) {
                player = (PlayerEntity)entity;
            } else if (blockState == null && killer instanceof PlayerEntity) {
                player = (PlayerEntity)killer;
            } else if (blockState == null && (killer instanceof ArrowEntity || killer instanceof SpectralArrowEntity || killer instanceof FireworkRocketEntity)) {
                arrow = killer;
            }
            ProjectileEntity projectile = null;
            if (killer instanceof ProjectileEntity) {
                projectile = (ProjectileEntity)killer;
            }
            if (player != null && UpgradedNetheriteConfig.EnableTeleportChest) {
                ItemStack heldItem = player.func_184614_ca();
                if (EnderUtil.isEnderToolOrWeapon(heldItem) && !ToolUtil.getDisableEffect(heldItem) && heldItem.func_77978_p() != null && heldItem.func_77978_p().func_74764_b("UpgradedNetherite_Tagged") && heldItem.func_77978_p().func_74767_n("UpgradedNetherite_Tagged")) {
                    IItemHandler iitemhandler;
                    TileEntity tileentity;
                    World world = player.getEntity().field_70170_p;
                    String Iworld = world.func_234923_W_().func_240901_a_().func_110623_a();
                    if (!Iworld.equals(heldItem.func_77978_p().func_74779_i("UpgradedNetherite_Dimension"))) {
                        return generatedLoot;
                    }
                    BlockPos pos = new BlockPos(heldItem.func_77978_p().func_74759_k("UpgradedNetherite_Position")[0], heldItem.func_77978_p().func_74759_k("UpgradedNetherite_Position")[1], heldItem.func_77978_p().func_74759_k("UpgradedNetherite_Position")[2]);
                    BlockState state = world.func_180495_p(pos);
                    if (state.hasTileEntity() && (tileentity = world.func_175625_s(pos)) != null && (iitemhandler = (IItemHandler)((ImmutablePair)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(capability -> ImmutablePair.of((Object)capability, (Object)tileentity)).get()).getKey()) != null) {
                        ArrayList<ItemStack> alis = new ArrayList<ItemStack>();
                        IItemHandler finalIitemhandler = iitemhandler;
                        generatedLoot.forEach(stack -> alis.add(ItemHandlerHelper.insertItemStacked((IItemHandler)finalIitemhandler, (ItemStack)stack, (boolean)false)));
                        return alis;
                    }
                }
            } else if (projectile != null && EnderUtil.isEnderProjectile(projectile) && UpgradedNetheriteConfig.EnableTeleportChest && projectile.getPersistentData().func_74767_n("UpgradedNetherite_Tagged")) {
                IItemHandler iitemhandler;
                TileEntity tileentity;
                World world = projectile.field_70170_p;
                String Iworld = world.func_234923_W_().func_240901_a_().func_110623_a();
                if (!Iworld.equals(projectile.getPersistentData().func_74779_i("UpgradedNetherite_Dimension"))) {
                    return generatedLoot;
                }
                BlockPos pos = new BlockPos(projectile.getPersistentData().func_74759_k("UpgradedNetherite_Position")[0], projectile.getPersistentData().func_74759_k("UpgradedNetherite_Position")[1], projectile.getPersistentData().func_74759_k("UpgradedNetherite_Position")[2]);
                BlockState state = world.func_180495_p(pos);
                if (state.hasTileEntity() && (tileentity = world.func_175625_s(pos)) != null && (iitemhandler = (IItemHandler)((ImmutablePair)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(capability -> ImmutablePair.of((Object)capability, (Object)tileentity)).get()).getKey()) != null) {
                    ArrayList<ItemStack> alis = new ArrayList<ItemStack>();
                    IItemHandler finalIitemhandler = iitemhandler;
                    generatedLoot.forEach(stack -> alis.add(ItemHandlerHelper.insertItemStacked((IItemHandler)finalIitemhandler, (ItemStack)stack, (boolean)false)));
                    return alis;
                }
            }
            return generatedLoot;
        }

        public static class Serializer
        extends GlobalLootModifierSerializer<EnderTeleportModifier> {
            public EnderTeleportModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
                return new EnderTeleportModifier(conditions);
            }

            public JsonObject write(EnderTeleportModifier instance) {
                return this.makeConditions(instance.conditions);
            }
        }
    }

    public static class AutoSmeltLootModifier
    extends LootModifier {
        protected AutoSmeltLootModifier(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
            Entity killer = (Entity)context.func_216031_c(LootParameters.field_216285_e);
            Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
            BlockState blockState = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
            PlayerEntity player = null;
            Entity arrow = null;
            if (entity instanceof PlayerEntity) {
                player = (PlayerEntity)entity;
            }
            if (player == null && killer instanceof PlayerEntity) {
                player = (PlayerEntity)killer;
            }
            if (killer instanceof ArrowEntity || killer instanceof SpectralArrowEntity || killer instanceof FireworkRocketEntity) {
                arrow = killer;
            }
            ArrayList<ItemStack> alis = new ArrayList<ItemStack>();
            if (blockState != null && player != null && player.func_213453_ef()) {
                return generatedLoot;
            }
            if (!UpgradedNetheriteConfig.EnableFireTool || !UpgradedNetheriteConfig.EnableAutoSmelt || tool != null && ToolUtil.getDisableEffect(tool)) {
                return generatedLoot;
            }
            ProjectileEntity projectile = null;
            if (killer instanceof ProjectileEntity) {
                projectile = (ProjectileEntity)killer;
            }
            if (player != null && FireUtil.isFireToolOrWeapon(player.func_184614_ca()) && !ToolUtil.getDisableEffect(player.func_184614_ca()) || projectile != null && FireUtil.isFireProjectile(projectile)) {
                generatedLoot.forEach(stack -> alis.add(this.autosmelt((ItemStack)stack, (World)context.func_202879_g())));
                if (tool != null && UpgradedNetheriteConfig.EnableAutoSmeltFortune && (((BlockState)context.func_216031_c(LootParameters.field_216287_g)).func_177230_c().getRegistryName().toString().contains("ore") && alis.toString().contains("ingot") || ((BlockState)context.func_216031_c(LootParameters.field_216287_g)).func_177230_c().getRegistryName().toString().contains("log") && alis.toString().contains("charcoal"))) {
                    Double rand;
                    ItemStack fakeTool = tool.func_190926_b() ? new ItemStack((IItemProvider)Items.field_234759_km_) : tool.func_77946_l();
                    float FortuneLevel = 0.0f;
                    Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)fakeTool);
                    if (!enchantments.isEmpty() && enchantments.containsKey(Enchantments.field_185308_t)) {
                        FortuneLevel = ((Integer)enchantments.get(Enchantments.field_185308_t)).intValue();
                    }
                    if (FortuneLevel > 0.0f && (rand = Double.valueOf(Math.random())) >= (double)(2.0f / (FortuneLevel + 2.0f))) {
                        Integer randI = (int)(Math.random() * (double)FortuneLevel + 1.0);
                        for (int i = 0; i < randI; ++i) {
                            generatedLoot.forEach(stack -> alis.add(this.autosmelt((ItemStack)stack, (World)context.func_202879_g())));
                        }
                    }
                }
                return alis;
            }
            return generatedLoot;
        }

        protected ItemStack autosmelt(ItemStack stack, World world) {
            return world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{stack}), world).map(AbstractCookingRecipe::func_77571_b).filter(itemStack -> !itemStack.func_190926_b()).map(itemStack -> ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)(stack.func_190916_E() * itemStack.func_190916_E()))).orElse(stack);
        }

        public static class Serializer
        extends GlobalLootModifierSerializer<AutoSmeltLootModifier> {
            public AutoSmeltLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
                return new AutoSmeltLootModifier(ailootcondition);
            }

            public JsonObject write(AutoSmeltLootModifier instance) {
                return this.makeConditions(instance.conditions);
            }
        }
    }
}

