/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite.content;

import com.rolfmao.upgradedcore.helpers.TooltipHelper;
import com.rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import com.rolfmao.upgradednetherite.init.ModItems;
import com.rolfmao.upgradednetherite.utils.ToolUtil;
import com.rolfmao.upgradednetherite.utils.tool.CorruptUtil;
import com.rolfmao.upgradednetherite.utils.tool.EnderUtil;
import com.rolfmao.upgradednetherite.utils.tool.FeatherUtil;
import com.rolfmao.upgradednetherite.utils.tool.FireUtil;
import com.rolfmao.upgradednetherite.utils.tool.GoldUtil;
import com.rolfmao.upgradednetherite.utils.tool.PhantomUtil;
import com.rolfmao.upgradednetherite.utils.tool.PoisonUtil;
import com.rolfmao.upgradednetherite.utils.tool.WaterUtil;
import com.rolfmao.upgradednetherite.utils.tool.WitherUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ShovelItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UpgradedNetheriteShovel
extends ShovelItem {
    public UpgradedNetheriteShovel(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        super(tier, attackDamageIn, attackSpeedIn, builderIn);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.getItem() == ModItems.CORRUPT_UPGRADED_NETHERITE_SHOVEL.get() && enchantment == Enchantments.field_185296_A) {
            return false;
        }
        return enchantment.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean p_77663_5_) {
        Map enchantments;
        if (stack.func_77973_b() == ModItems.CORRUPT_UPGRADED_NETHERITE_SHOVEL.get() && stack.func_77948_v() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)stack) > 0 && (enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack)).containsKey(Enchantments.field_185296_A)) {
            enchantments.remove(Enchantments.field_185296_A);
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184614_ca();
        if (player.func_213453_ef() && !player.func_184811_cZ().func_185141_a(stack.func_77973_b()) && ToolUtil.isUsingEffectTool(player)) {
            ToolUtil.toggleDisableEffect(player);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResultType iResult = super.func_195939_a(context);
        if (iResult == ActionResultType.PASS && context.func_195999_j() != null && context.func_195999_j().func_213453_ef() && EnderUtil.isEnderTool(context.func_195996_i()) && !context.func_195999_j().func_184811_cZ().func_185141_a(context.func_195996_i().func_77973_b())) {
            iResult = EnderUtil.EnderSetTag(context);
        }
        if (iResult == ActionResultType.PASS) {
            iResult = super.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n()).func_188397_a();
        }
        return iResult;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            if (GoldUtil.isGoldTool(stack)) {
                list.add((Object)stack);
            } else if (FireUtil.isFireTool(stack)) {
                list.add((Object)stack);
            } else if (EnderUtil.isEnderTool(stack)) {
                list.add((Object)stack);
            } else if (WaterUtil.isWaterTool(stack)) {
                list.add((Object)stack);
            } else if (WitherUtil.isWitherTool(stack)) {
                list.add((Object)stack);
            } else if (PoisonUtil.isPoisonTool(stack)) {
                list.add((Object)stack);
            } else if (PhantomUtil.isPhantomTool(stack)) {
                list.add((Object)stack);
            } else if (FeatherUtil.isFeatherTool(stack)) {
                list.add((Object)stack);
            } else if (CorruptUtil.isCorruptTool(stack)) {
                list.add((Object)stack);
            } else if (tab == ItemGroup.field_78027_g) {
                list.add((Object)stack);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!UpgradedNetheriteConfig.DisableTooltips) {
            if (Screen.func_231173_s_()) {
                if (GoldUtil.isGoldTool(stack) && UpgradedNetheriteConfig.EnableFortuneBonus) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Bonus.TT"));
                    float EnchantBonus = 0.0f;
                    Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
                    if (!enchantments.isEmpty() && enchantments.containsKey(Enchantments.field_185308_t)) {
                        int EnchantLevel = (Integer)enchantments.get(Enchantments.field_185308_t);
                        EnchantBonus = EnchantLevel;
                    }
                    if (EnchantBonus >= 3.0f) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Gold_Tool.TT", (Object[])new Object[]{"\u00a76" + (UpgradedNetheriteConfig.FortuneBonus + UpgradedNetheriteConfig.FortuneEnchantBonus)});
                    } else {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Gold_Tool.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.FortuneBonus});
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Gold_Tool2.TT", (Object[])new Object[]{"\u00a7d" + UpgradedNetheriteConfig.FortuneEnchantBonus});
                    }
                } else if (FireUtil.isFireTool(stack) && UpgradedNetheriteConfig.EnableAutoSmelt) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Bonus.TT"));
                    if (ToolUtil.getDisableEffect(stack)) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Fire_Tool.TT", (Object[])new Object[]{"\u00a7c\u2022 "});
                    } else {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Fire_Tool.TT", (Object[])new Object[]{"\u00a77\u2022 "});
                    }
                } else if (EnderUtil.isEnderTool(stack) && UpgradedNetheriteConfig.EnableTeleportChest) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Bonus.TT"));
                    if (ToolUtil.getDisableEffect(stack)) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Ender_Tool.TT", (Object[])new Object[]{"\u00a7c\u2022 "});
                    } else {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Ender_Tool.TT", (Object[])new Object[]{"\u00a77\u2022 "});
                    }
                    if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("UpgradedNetherite_Tagged") && stack.func_77978_p().func_74767_n("UpgradedNetherite_Tagged")) {
                        String world = worldIn.func_234923_W_().func_240901_a_().func_110623_a();
                        if (!world.equals(stack.func_77978_p().func_74779_i("UpgradedNetherite_Dimension"))) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Target.TT"));
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_Dim.TT"));
                            tooltip.add((ITextComponent)new StringTextComponent("\u00a77\u2022 \u00a7c" + stack.func_77978_p().func_74779_i("UpgradedNetherite_Dimension") + "\u00a77 : \u00a73" + stack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[0] + "\u00a77, \u00a73" + stack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[1] + "\u00a77, \u00a73" + stack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[2] + "\u00a77."));
                        } else {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Target.TT"));
                            tooltip.add((ITextComponent)new StringTextComponent("\u00a77\u2022 \u00a79" + stack.func_77978_p().func_74779_i("UpgradedNetherite_Dimension") + "\u00a77 : \u00a73" + stack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[0] + "\u00a77, \u00a73" + stack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[1] + "\u00a77, \u00a73" + stack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[2] + "\u00a77."));
                        }
                    }
                } else if (WaterUtil.isWaterTool(stack) && UpgradedNetheriteConfig.EnableMiningSpeedUnderwater) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Bonus.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Water_Tool.TT"));
                } else if (PhantomUtil.isPhantomTool(stack) && (UpgradedNetheriteConfig.EnableGlowingEffect || UpgradedNetheriteConfig.EnableReachEffect)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Bonus.TT"));
                    if (UpgradedNetheriteConfig.EnableGlowingEffect) {
                        if (ToolUtil.getDisableEffect(stack)) {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Phantom_Tool.TT", (Object[])new Object[]{"\u00a7c\u2022 "});
                        } else {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Phantom_Tool.TT", (Object[])new Object[]{"\u00a77\u2022 "});
                        }
                    }
                    if (UpgradedNetheriteConfig.EnableReachEffect) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Phantom_Tool2.TT"));
                    }
                } else if (FeatherUtil.isFeatherTool(stack) && UpgradedNetheriteConfig.EnableAttractItem) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Bonus.TT"));
                    if (ToolUtil.getDisableEffect(stack)) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Feather_Tool.TT", (Object[])new Object[]{"\u00a7c\u2022 "});
                    } else {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Feather_Tool.TT", (Object[])new Object[]{"\u00a77\u2022 "});
                    }
                } else if (CorruptUtil.isCorruptTool(stack)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Malus.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Corrupt_Bonus2.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Corrupt_Enchant.TT"));
                    if (UpgradedNetheriteConfig.EnableFortuneBonusCorruptTool) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Bonus.TT"));
                        if (Minecraft.func_71410_x().field_71439_g != null && CorruptUtil.intWearingCorruptArmor((PlayerEntity)Minecraft.func_71410_x().field_71439_g, true) > 0) {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Corrupt_Tool2.TT", (Object[])new Object[]{"\u00a76" + CorruptUtil.intWearingCorruptArmor((PlayerEntity)Minecraft.func_71410_x().field_71439_g, true) * UpgradedNetheriteConfig.FortuneBonusCorruptTool});
                        }
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Corrupt_Tool.TT", (Object[])new Object[]{"\u00a7d" + UpgradedNetheriteConfig.FortuneBonusCorruptTool});
                    }
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Disabled.TT"));
                }
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.HoldShift.TT"));
                if (EnderUtil.isEnderToolOrWeapon(stack)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("UpgradedNetherite_Tagged") && stack.func_77978_p().func_74767_n("UpgradedNetherite_Tagged")) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_ToolTar.TT"));
                    } else {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_ToolReq.TT"));
                    }
                }
            }
        }
    }
}

