/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite.content;

import com.google.common.collect.Lists;
import com.rolfmao.upgradedcore.compat.ExternalMods;
import com.rolfmao.upgradedcore.helpers.TooltipHelper;
import com.rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import com.rolfmao.upgradednetherite.init.ModItems;
import com.rolfmao.upgradednetherite.utils.tool.CorruptUtil;
import com.rolfmao.upgradednetherite.utils.tool.EnderUtil;
import com.rolfmao.upgradednetherite.utils.tool.FeatherUtil;
import com.rolfmao.upgradednetherite.utils.tool.FireUtil;
import com.rolfmao.upgradednetherite.utils.tool.GoldUtil;
import com.rolfmao.upgradednetherite.utils.tool.PhantomUtil;
import com.rolfmao.upgradednetherite.utils.tool.PoisonUtil;
import com.rolfmao.upgradednetherite.utils.tool.WaterUtil;
import com.rolfmao.upgradednetherite.utils.tool.WitherUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shadows.apotheosis.ench.asm.EnchHooks;

public class UpgradedNetheriteCrossbow
extends CrossbowItem {
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;

    public UpgradedNetheriteCrossbow(Item.Properties properties) {
        super(properties);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return Items.field_234759_km_.equals(repair.func_77973_b());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.getItem() == ModItems.CORRUPT_UPGRADED_NETHERITE_CROSSBOW.get() && enchantment == Enchantments.field_185296_A) {
            return false;
        }
        if ((stack.func_77973_b() == ModItems.GOLD_UPGRADED_NETHERITE_CROSSBOW.get() || stack.func_77973_b() == ModItems.CORRUPT_UPGRADED_NETHERITE_CROSSBOW.get()) && enchantment == Enchantments.field_185304_p) {
            return true;
        }
        if (stack.func_77973_b() == ModItems.FIRE_UPGRADED_NETHERITE_CROSSBOW.get() && enchantment == Enchantments.field_185311_w) {
            return true;
        }
        return enchantment.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean p_77663_5_) {
        Map enchantments;
        if (stack.func_77973_b() == ModItems.CORRUPT_UPGRADED_NETHERITE_CROSSBOW.get() && stack.func_77948_v() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)stack) > 0 && (enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack)).containsKey(Enchantments.field_185296_A)) {
            enchantments.remove(Enchantments.field_185296_A);
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResultType iResult = ActionResultType.PASS;
        if (context.func_195999_j() != null && context.func_195999_j().func_213453_ef() && EnderUtil.isEnderRangedWeapon(context.func_195996_i()) && !context.func_195999_j().func_184811_cZ().func_185141_a(context.func_195996_i().func_77973_b())) {
            iResult = EnderUtil.EnderSetTag(context);
        }
        if (iResult == ActionResultType.PASS) {
            return super.func_195939_a(context);
        }
        return iResult;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            if (stack.func_77973_b() == ModItems.NETHERITE_CROSSBOW.get()) {
                list.add((Object)stack);
            } else if (GoldUtil.isGoldRangedWeapon(stack)) {
                list.add((Object)stack);
            } else if (FireUtil.isFireRangedWeapon(stack)) {
                list.add((Object)stack);
            } else if (EnderUtil.isEnderRangedWeapon(stack)) {
                list.add((Object)stack);
            } else if (WaterUtil.isWaterRangedWeapon(stack)) {
                list.add((Object)stack);
            } else if (WitherUtil.isWitherRangedWeapon(stack)) {
                list.add((Object)stack);
            } else if (PoisonUtil.isPoisonRangedWeapon(stack)) {
                list.add((Object)stack);
            } else if (PhantomUtil.isPhantomRangedWeapon(stack)) {
                list.add((Object)stack);
            } else if (FeatherUtil.isFeatherRangedWeapon(stack)) {
                list.add((Object)stack);
            } else if (CorruptUtil.isCorruptRangedWeapon(stack)) {
                list.add((Object)stack);
            } else if (tab == ItemGroup.field_78027_g) {
                list.add((Object)stack);
            }
        }
    }

    public Predicate<ItemStack> func_220006_d() {
        return field_220008_b;
    }

    public Predicate<ItemStack> func_220004_b() {
        return field_220007_a;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerEntity, Hand hand) {
        ItemStack itemstack = playerEntity.func_184586_b(hand);
        if (UpgradedNetheriteCrossbow.isCharged(itemstack)) {
            if (ExternalMods.APOTHEOSIS.isLoaded()) {
                EnchHooks.preArrowFired((ItemStack)itemstack);
            }
            UpgradedNetheriteCrossbow.performShooting(world, (LivingEntity)playerEntity, hand, itemstack, UpgradedNetheriteCrossbow.getShootingPower(itemstack), 1.0f);
            UpgradedNetheriteCrossbow.setCharged(itemstack, false);
            if (ExternalMods.APOTHEOSIS.isLoaded()) {
                EnchHooks.onArrowFired((ItemStack)itemstack);
            }
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        if (!playerEntity.func_213356_f(itemstack).func_190926_b()) {
            if (!UpgradedNetheriteCrossbow.isCharged(itemstack)) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
                playerEntity.func_184598_c(hand);
            }
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public void func_77615_a(ItemStack itemStack, World world, LivingEntity livingEntity, int p_77615_4_) {
        int i = this.func_77626_a(itemStack) - p_77615_4_;
        float f = UpgradedNetheriteCrossbow.getPowerForTime(i, itemStack);
        if (f >= 1.0f && !UpgradedNetheriteCrossbow.isCharged(itemStack) && UpgradedNetheriteCrossbow.tryLoadProjectiles(livingEntity, itemStack)) {
            UpgradedNetheriteCrossbow.setCharged(itemStack, true);
            SoundCategory soundcategory = livingEntity instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.HOSTILE;
            world.func_184148_a((PlayerEntity)null, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), SoundEvents.field_219610_bB, soundcategory, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean tryLoadProjectiles(LivingEntity livingEntity, ItemStack itemStack) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222192_G, (ItemStack)itemStack);
        int j = i == 0 ? 1 : 3;
        boolean flag = livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).field_71075_bZ.field_75098_d;
        ItemStack itemstack = livingEntity.func_213356_f(itemStack);
        ItemStack itemstack1 = itemstack.func_77946_l();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemstack = itemstack1.func_77946_l();
            }
            if (itemstack.func_190926_b() && flag) {
                itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                itemstack1 = itemstack.func_77946_l();
            }
            if (UpgradedNetheriteCrossbow.loadProjectile(livingEntity, itemStack, itemstack, k > 0, flag)) continue;
            return false;
        }
        return true;
    }

    private static boolean loadProjectile(LivingEntity livingEntity, ItemStack itemStack, ItemStack ammo, boolean p_220023_3_, boolean p_220023_4_) {
        ItemStack itemstack;
        boolean flag;
        if (ammo.func_190926_b()) {
            return false;
        }
        boolean bl = flag = p_220023_4_ && ammo.func_77973_b() instanceof ArrowItem;
        if (!(flag || p_220023_4_ || p_220023_3_)) {
            itemstack = ammo.func_77979_a(1);
            if (ammo.func_190926_b() && livingEntity instanceof PlayerEntity) {
                ((PlayerEntity)livingEntity).field_71071_by.func_184437_d(ammo);
            }
        } else {
            itemstack = ammo.func_77946_l();
        }
        UpgradedNetheriteCrossbow.addChargedProjectile(itemStack, itemstack);
        return true;
    }

    public static boolean isCharged(ItemStack itemStack) {
        CompoundNBT compoundnbt = itemStack.func_77978_p();
        return compoundnbt != null && compoundnbt.func_74767_n("Charged");
    }

    public static void setCharged(ItemStack itemStack, boolean p_220011_1_) {
        CompoundNBT compoundnbt = itemStack.func_196082_o();
        compoundnbt.func_74757_a("Charged", p_220011_1_);
    }

    private static void addChargedProjectile(ItemStack itemStack, ItemStack itemStack1) {
        CompoundNBT compoundnbt = itemStack.func_196082_o();
        ListNBT listnbt = compoundnbt.func_150297_b("ChargedProjectiles", 9) ? compoundnbt.func_150295_c("ChargedProjectiles", 10) : new ListNBT();
        CompoundNBT compoundnbt1 = new CompoundNBT();
        itemStack1.func_77955_b(compoundnbt1);
        listnbt.add((Object)compoundnbt1);
        compoundnbt.func_218657_a("ChargedProjectiles", (INBT)listnbt);
    }

    private static List<ItemStack> getChargedProjectiles(ItemStack itemStack) {
        ListNBT listnbt;
        ArrayList list = Lists.newArrayList();
        CompoundNBT compoundnbt = itemStack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("ChargedProjectiles", 9) && (listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt1 = listnbt.func_150305_b(i);
                list.add(ItemStack.func_199557_a((CompoundNBT)compoundnbt1));
            }
        }
        return list;
    }

    private static void clearChargedProjectiles(ItemStack itemStack) {
        CompoundNBT compoundnbt = itemStack.func_77978_p();
        if (compoundnbt != null) {
            ListNBT listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 9);
            listnbt.clear();
            compoundnbt.func_218657_a("ChargedProjectiles", (INBT)listnbt);
        }
    }

    private static void shootProjectile(World world, LivingEntity livingEntity, Hand hand, ItemStack itemStack, ItemStack ammo, float p_220016_5_, boolean p_220016_6_, float p_220016_7_, float p_220016_8_, float p_220016_9_) {
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)livingEntity;
            if (!world.field_72995_K) {
                AbstractArrowEntity projectileentity;
                boolean flag;
                boolean bl = flag = ammo.func_77973_b() == Items.field_196152_dE;
                if (flag) {
                    projectileentity = new FireworkRocketEntity(world, ammo, (Entity)livingEntity, livingEntity.func_226277_ct_(), livingEntity.func_226280_cw_() - (double)0.15f, livingEntity.func_226281_cx_(), true);
                } else {
                    projectileentity = UpgradedNetheriteCrossbow.getArrow(world, livingEntity, itemStack, ammo);
                    if (p_220016_6_ || p_220016_9_ != 0.0f) {
                        projectileentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                    }
                }
                if (livingEntity instanceof ICrossbowUser) {
                    ICrossbowUser icrossbowuser = (ICrossbowUser)livingEntity;
                    icrossbowuser.func_230284_a_(icrossbowuser.func_70638_az(), itemStack, (ProjectileEntity)projectileentity, p_220016_9_);
                } else {
                    Vector3d vector3d1 = livingEntity.func_213286_i(1.0f);
                    Quaternion quaternion = new Quaternion(new Vector3f(vector3d1), p_220016_9_, true);
                    Vector3d vector3d = livingEntity.func_70676_i(1.0f);
                    Vector3f vector3f = new Vector3f(vector3d);
                    vector3f.func_214905_a(quaternion);
                    projectileentity.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), p_220016_7_, p_220016_8_);
                }
                itemStack.func_222118_a(flag ? 3 : 1, livingEntity, p_220017_1_ -> p_220017_1_.func_213334_d(hand));
                if (itemStack.func_77973_b() == ModItems.GOLD_UPGRADED_NETHERITE_CROSSBOW.get()) {
                    projectileentity.func_184211_a("GoldUpgradedNetheriteBow");
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)itemStack) > 0) {
                        projectileentity.getPersistentData().func_74768_a("LootingGoldUpgradedNetheriteBow", EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)itemStack));
                    }
                }
                if (itemStack.func_77973_b() == ModItems.FIRE_UPGRADED_NETHERITE_CROSSBOW.get()) {
                    projectileentity.func_184211_a("FireUpgradedNetheriteBow");
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)itemStack) > 0) {
                        projectileentity.func_184211_a("FlameFireUpgradedNetheriteBow");
                        projectileentity.func_70015_d(100);
                    }
                }
                if (itemStack.func_77973_b() == ModItems.ENDER_UPGRADED_NETHERITE_CROSSBOW.get()) {
                    projectileentity.func_184211_a("EnderUpgradedNetheriteBow");
                    if (itemStack.func_196082_o().func_74767_n("UpgradedNetherite_Tagged")) {
                        projectileentity.getPersistentData().func_74783_a("UpgradedNetherite_Position", itemStack.func_196082_o().func_74759_k("UpgradedNetherite_Position"));
                        projectileentity.getPersistentData().func_74778_a("UpgradedNetherite_Dimension", itemStack.func_196082_o().func_74779_i("UpgradedNetherite_Dimension"));
                        projectileentity.getPersistentData().func_74757_a("UpgradedNetherite_Tagged", itemStack.func_196082_o().func_74767_n("UpgradedNetherite_Tagged"));
                    }
                }
                if (itemStack.func_77973_b() == ModItems.WATER_UPGRADED_NETHERITE_CROSSBOW.get()) {
                    projectileentity.func_184211_a("WaterUpgradedNetheriteBow");
                }
                if (itemStack.func_77973_b() == ModItems.WITHER_UPGRADED_NETHERITE_CROSSBOW.get()) {
                    projectileentity.func_184211_a("WitherUpgradedNetheriteBow");
                }
                if (itemStack.func_77973_b() == ModItems.POISON_UPGRADED_NETHERITE_CROSSBOW.get()) {
                    projectileentity.func_184211_a("PoisonUpgradedNetheriteBow");
                }
                if (itemStack.func_77973_b() == ModItems.PHANTOM_UPGRADED_NETHERITE_CROSSBOW.get()) {
                    projectileentity.func_184211_a("PhantomUpgradedNetheriteBow");
                }
                if (itemStack.func_77973_b() == ModItems.FEATHER_UPGRADED_NETHERITE_CROSSBOW.get()) {
                    projectileentity.func_184211_a("FeatherUpgradedNetheriteBow");
                }
                if (itemStack.func_77973_b() == ModItems.CORRUPT_UPGRADED_NETHERITE_CROSSBOW.get()) {
                    projectileentity.func_184211_a("CorruptUpgradedNetheriteBow");
                    projectileentity.getPersistentData().func_74768_a("LootingCorruptUpgradedNetheriteBow", CorruptUtil.intWearingCorruptArmor(playerentity, true).intValue());
                }
                if (ExternalMods.APOTHEOSIS.isLoaded()) {
                    EnchHooks.markGeneratedArrows((ProjectileEntity)projectileentity, (ItemStack)itemStack);
                }
                world.func_217376_c((Entity)projectileentity);
                world.func_184148_a((PlayerEntity)null, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, p_220016_5_);
            }
        }
    }

    private static AbstractArrowEntity getArrow(World world, LivingEntity livingEntity, ItemStack itemStack, ItemStack ammo) {
        ArrowItem arrowitem = (ArrowItem)(ammo.func_77973_b() instanceof ArrowItem ? ammo.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractarrowentity = arrowitem.func_200887_a(world, ammo, livingEntity);
        if (livingEntity instanceof PlayerEntity) {
            abstractarrowentity.func_70243_d(true);
        }
        abstractarrowentity.func_213869_a(SoundEvents.field_219609_bA);
        abstractarrowentity.func_213865_o(true);
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222194_I, (ItemStack)itemStack);
        if (i > 0) {
            abstractarrowentity.func_213872_b((byte)i);
        }
        return abstractarrowentity;
    }

    public static void performShooting(World world, LivingEntity livingEntity, Hand hand, ItemStack itemStack, float p_220014_4_, float p_220014_5_) {
        List<ItemStack> list = UpgradedNetheriteCrossbow.getChargedProjectiles(itemStack);
        float[] afloat = UpgradedNetheriteCrossbow.getShotPitches(livingEntity.func_70681_au());
        for (int i = 0; i < list.size(); ++i) {
            boolean flag;
            ItemStack itemstack = list.get(i);
            boolean bl = flag = livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).field_71075_bZ.field_75098_d;
            if (itemstack.func_190926_b()) continue;
            if (i == 0) {
                UpgradedNetheriteCrossbow.shootProjectile(world, livingEntity, hand, itemStack, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, 0.0f);
                continue;
            }
            if (i == 1) {
                UpgradedNetheriteCrossbow.shootProjectile(world, livingEntity, hand, itemStack, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, -10.0f);
                continue;
            }
            if (i != 2) continue;
            UpgradedNetheriteCrossbow.shootProjectile(world, livingEntity, hand, itemStack, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, 10.0f);
        }
        UpgradedNetheriteCrossbow.onCrossbowShot(world, livingEntity, itemStack);
    }

    private static float[] getShotPitches(Random random) {
        boolean flag = random.nextBoolean();
        return new float[]{1.0f, UpgradedNetheriteCrossbow.getRandomShotPitch(flag), UpgradedNetheriteCrossbow.getRandomShotPitch(!flag)};
    }

    private static float getRandomShotPitch(boolean p_220032_0_) {
        float f = p_220032_0_ ? 0.63f : 0.43f;
        return 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.8f) + f;
    }

    private static void onCrossbowShot(World world, LivingEntity livingEntity, ItemStack itemStack) {
        if (livingEntity instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)livingEntity;
            if (!world.field_72995_K) {
                CriteriaTriggers.field_215099_F.func_215111_a(serverplayerentity, itemStack);
            }
            serverplayerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)itemStack.func_77973_b()));
        }
        UpgradedNetheriteCrossbow.clearChargedProjectiles(itemStack);
    }

    public void func_219972_a(World world, LivingEntity livingEntity, ItemStack itemStack, int p_219972_4_) {
        if (!world.field_72995_K) {
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)itemStack);
            SoundEvent soundevent = this.getStartSound(i);
            SoundEvent soundevent1 = i == 0 ? SoundEvents.field_219611_bC : null;
            float f = (float)(itemStack.func_77988_m() - p_219972_4_) / (float)UpgradedNetheriteCrossbow.getChargeDuration(itemStack);
            if (f < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (f >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                world.func_184148_a((PlayerEntity)null, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), soundevent, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundevent1 != null && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                world.func_184148_a((PlayerEntity)null, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), soundevent1, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public int func_77626_a(ItemStack itemStack) {
        return UpgradedNetheriteCrossbow.getChargeDuration(itemStack) + 3;
    }

    public static int getChargeDuration(ItemStack itemStack) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)itemStack);
        return i == 0 ? 25 : 25 - 5 * i;
    }

    public UseAction func_77661_b(ItemStack itemStack) {
        return UseAction.CROSSBOW;
    }

    private SoundEvent getStartSound(int p_220025_1_) {
        switch (p_220025_1_) {
            case 1: {
                return SoundEvents.field_219613_bE;
            }
            case 2: {
                return SoundEvents.field_219614_bF;
            }
            case 3: {
                return SoundEvents.field_219615_bG;
            }
        }
        return SoundEvents.field_219612_bD;
    }

    private static float getPowerForTime(int p_220031_0_, ItemStack itemStack) {
        float f = (float)p_220031_0_ / (float)UpgradedNetheriteCrossbow.getChargeDuration(itemStack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Item crossbow;
        List<ItemStack> list = UpgradedNetheriteCrossbow.getChargedProjectiles(itemStack);
        if (!UpgradedNetheriteConfig.DisableTooltips && (crossbow = itemStack.func_77973_b()) != ModItems.NETHERITE_CROSSBOW.get()) {
            if (Screen.func_231173_s_()) {
                int EnchantLevel;
                Map enchantments;
                if (GoldUtil.isGoldRangedWeapon(itemStack) && (UpgradedNetheriteConfig.EnableDamageBonusGoldWeapon || UpgradedNetheriteConfig.EnableLootingBonus)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Bonus.TT"));
                    if (UpgradedNetheriteConfig.EnableDamageBonusGoldWeapon) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Gold_Weapon.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.DamageBonusGoldWeapon + "%"});
                    }
                    if (UpgradedNetheriteConfig.EnableLootingBonus) {
                        float EnchantBonus = 0.0f;
                        enchantments = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
                        if (!enchantments.isEmpty() && enchantments.containsKey(Enchantments.field_185304_p)) {
                            EnchantLevel = (Integer)enchantments.get(Enchantments.field_185304_p);
                            EnchantBonus = EnchantLevel;
                        }
                        if (EnchantBonus >= 3.0f) {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Gold_Weapon2.TT", (Object[])new Object[]{"\u00a76" + (UpgradedNetheriteConfig.LootingBonus + UpgradedNetheriteConfig.LootingEnchantBonus)});
                        } else {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Gold_Weapon2.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.LootingBonus});
                            if (!(EnchantBonus > 0.0f)) {
                                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Gold_Bow.TT"));
                            }
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Gold_Weapon3.TT", (Object[])new Object[]{"\u00a7d" + UpgradedNetheriteConfig.LootingEnchantBonus});
                        }
                    }
                } else if (FireUtil.isFireRangedWeapon(itemStack) && (UpgradedNetheriteConfig.EnableDamageBonusFireWeapon || UpgradedNetheriteConfig.EnableAutoSmelt)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Bonus.TT"));
                    if (UpgradedNetheriteConfig.EnableDamageBonusFireWeapon) {
                        float EnchantBonus = 0.0f;
                        enchantments = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
                        if (!enchantments.isEmpty() && enchantments.containsKey(Enchantments.field_185311_w)) {
                            EnchantLevel = (Integer)enchantments.get(Enchantments.field_185311_w);
                            EnchantBonus = EnchantLevel;
                        }
                        if (EnchantBonus >= 1.0f) {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Fire_Weapon.TT", (Object[])new Object[]{"\u00a76" + (UpgradedNetheriteConfig.DamageBonusFireWeapon + UpgradedNetheriteConfig.DamageBonusFireEnchantWeapon) + "%"});
                        } else {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Fire_Weapon.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.DamageBonusFireWeapon + "%"});
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Fire_CrossBow.TT"));
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Fire_Bow.TT", (Object[])new Object[]{"\u00a7d" + UpgradedNetheriteConfig.DamageBonusFireEnchantWeapon + "%"});
                        }
                    }
                    if (UpgradedNetheriteConfig.EnableAutoSmelt) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Fire_Tool.TT", (Object[])new Object[]{"\u00a77\u2022 "});
                    }
                } else if (EnderUtil.isEnderRangedWeapon(itemStack) && (UpgradedNetheriteConfig.EnablePreventTeleport || UpgradedNetheriteConfig.EnableTeleportChest)) {
                    if (UpgradedNetheriteConfig.EnablePreventTeleport) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.OnHit.TT"));
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_Weapon.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnableTeleportChest) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Bonus.TT"));
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_Tool.TT"));
                        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("UpgradedNetherite_Tagged") && itemStack.func_77978_p().func_74767_n("UpgradedNetherite_Tagged")) {
                            String world = worldIn.func_234923_W_().func_240901_a_().func_110623_a();
                            if (!world.equals(itemStack.func_77978_p().func_74779_i("UpgradedNetherite_Dimension"))) {
                                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Target.TT"));
                                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_Dim.TT"));
                                tooltip.add((ITextComponent)new StringTextComponent("\u00a77\u2022 \u00a7c" + itemStack.func_77978_p().func_74779_i("UpgradedNetherite_Dimension") + "\u00a77 : \u00a73" + itemStack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[0] + "\u00a77, \u00a73" + itemStack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[1] + "\u00a77, \u00a73" + itemStack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[2] + "\u00a77."));
                            } else {
                                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Target.TT"));
                                tooltip.add((ITextComponent)new StringTextComponent("\u00a77\u2022 \u00a79" + itemStack.func_77978_p().func_74779_i("UpgradedNetherite_Dimension") + "\u00a77 : \u00a73" + itemStack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[0] + "\u00a77, \u00a73" + itemStack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[1] + "\u00a77, \u00a73" + itemStack.func_77978_p().func_74759_k("UpgradedNetherite_Position")[2] + "\u00a77."));
                            }
                        }
                    }
                } else if (WaterUtil.isWaterRangedWeapon(itemStack) && (UpgradedNetheriteConfig.EnableDamageBonusWaterWeapon || UpgradedNetheriteConfig.EnableMiningSpeedUnderwater)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Bonus.TT"));
                    if (UpgradedNetheriteConfig.EnableDamageBonusWaterWeapon) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Water_Weapon.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.DamageBonusWaterWeapon + "%"});
                    }
                    if (UpgradedNetheriteConfig.EnableMiningSpeedUnderwater) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Water_Tool.TT"));
                    }
                } else if (WitherUtil.isWitherRangedWeapon(itemStack)) {
                    if (UpgradedNetheriteConfig.EnableWitherEffect) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.OnHit.TT"));
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Wither_Weapon.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnableDamageBonusWitherWeapon) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Bonus.TT"));
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Wither_Weapon2.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.DamageBonusWitherWeapon + "%"});
                    }
                } else if (PoisonUtil.isPoisonRangedWeapon(itemStack)) {
                    if (UpgradedNetheriteConfig.EnablePoisonEffect) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.OnHit.TT"));
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Poison_Weapon.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnableDamageBonusPoisonWeapon) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Bonus.TT"));
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Poison_Weapon2.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.DamageBonusPoisonWeapon + "%"});
                    }
                } else if (PhantomUtil.isPhantomRangedWeapon(itemStack) && (UpgradedNetheriteConfig.EnableDamageBonusPhantomWeapon || UpgradedNetheriteConfig.EnableGlowingEffect || UpgradedNetheriteConfig.EnableReachEffect)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Bonus.TT"));
                    if (UpgradedNetheriteConfig.EnableDamageBonusPhantomWeapon) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Phantom_Weapon.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.DamageBonusPhantomWeapon + "%"});
                    }
                    if (UpgradedNetheriteConfig.EnableGlowingEffect) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Phantom_Tool.TT", (Object[])new Object[]{"\u00a77\u2022 "});
                    }
                    if (UpgradedNetheriteConfig.EnableReachEffect) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Phantom_Tool2.TT"));
                    }
                } else if (FeatherUtil.isFeatherRangedWeapon(itemStack)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.OnHit.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Feather_Bow.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Bonus.TT"));
                    TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Feather_Tool.TT", (Object[])new Object[]{"\u00a77\u2022 "});
                } else if (CorruptUtil.isCorruptRangedWeapon(itemStack)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Malus.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Corrupt_Bonus2.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Corrupt_Enchant.TT"));
                    if (UpgradedNetheriteConfig.EnableDamageBonusCorruptWeapon || UpgradedNetheriteConfig.EnableLootingBonusCorruptWeapon) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Bonus.TT"));
                    }
                    if (Minecraft.func_71410_x().field_71439_g != null && CorruptUtil.intWearingCorruptArmor((PlayerEntity)Minecraft.func_71410_x().field_71439_g, true) > 0) {
                        if (UpgradedNetheriteConfig.EnableDamageBonusCorruptWeapon) {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Corrupt_Weapon3.TT", (Object[])new Object[]{"\u00a76" + CorruptUtil.intWearingCorruptArmor((PlayerEntity)Minecraft.func_71410_x().field_71439_g, true) * UpgradedNetheriteConfig.DamageBonusCorruptWeapon + "%"});
                        }
                        if (UpgradedNetheriteConfig.EnableLootingBonusCorruptWeapon) {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Corrupt_Weapon4.TT", (Object[])new Object[]{"\u00a76" + CorruptUtil.intWearingCorruptArmor((PlayerEntity)Minecraft.func_71410_x().field_71439_g, true) * UpgradedNetheriteConfig.LootingBonusCorruptWeapon});
                        }
                    }
                    float EnchantBonus = 0.0f;
                    enchantments = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
                    if (!enchantments.isEmpty() && enchantments.containsKey(Enchantments.field_185304_p)) {
                        EnchantLevel = (Integer)enchantments.get(Enchantments.field_185304_p);
                        EnchantBonus = EnchantLevel;
                    }
                    if (!(EnchantBonus > 0.0f)) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Gold_Bow.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnableDamageBonusCorruptWeapon) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Corrupt_Weapon2.TT", (Object[])new Object[]{"\u00a7d" + UpgradedNetheriteConfig.DamageBonusCorruptWeapon + "%"});
                    }
                    if (UpgradedNetheriteConfig.EnableLootingBonusCorruptWeapon) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Corrupt_Weapon.TT", (Object[])new Object[]{"\u00a7d" + UpgradedNetheriteConfig.LootingBonusCorruptWeapon});
                    }
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Disabled.TT"));
                }
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.HoldShift.TT"));
                if (EnderUtil.isEnderToolOrWeapon(itemStack)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("UpgradedNetherite_Tagged") && itemStack.func_77978_p().func_74767_n("UpgradedNetherite_Tagged")) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_ToolTar.TT"));
                    } else {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_ToolReq.TT"));
                    }
                }
            }
        }
        if (UpgradedNetheriteCrossbow.isCharged(itemStack) && !list.isEmpty()) {
            ItemStack itemstack = list.get(0);
            tooltip.add((ITextComponent)new TranslationTextComponent("item.minecraft.crossbow.projectile").func_240702_b_(" ").func_230529_a_(itemstack.func_151000_E()));
            if (flagIn.func_194127_a() && itemstack.func_77973_b() == Items.field_196152_dE) {
                ArrayList list1 = Lists.newArrayList();
                Items.field_196152_dE.func_77624_a(itemstack, worldIn, (List)list1, flagIn);
                if (!list1.isEmpty()) {
                    for (int i = 0; i < list1.size(); ++i) {
                        list1.set(i, new StringTextComponent("  ").func_230529_a_((ITextComponent)list1.get(i)).func_240699_a_(TextFormatting.GRAY));
                    }
                    tooltip.addAll(list1);
                }
            }
        }
    }

    private static float getShootingPower(ItemStack p_220013_0_) {
        return p_220013_0_.func_77973_b() == Items.field_222114_py && UpgradedNetheriteCrossbow.func_220019_a((ItemStack)p_220013_0_, (Item)Items.field_196152_dE) ? 2.4f : 4.725f;
    }

    public int func_230305_d_() {
        return 8;
    }
}

