/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.core.other;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.AbstractJellyfishEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.BoxJellyfishEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.CassiopeaJellyfishEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ImmortalJellyfishEntity;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UAEntities;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Rarity;

public class JellyfishRegistry {
    public static final List<JellyfishEntry<?>> JELLYFISHES = Lists.newArrayList();
    public static final Map<Class<? extends AbstractJellyfishEntity>, Integer> IDS = Maps.newHashMap();

    public static <J extends AbstractJellyfishEntity> void registerJellyfish(Supplier<EntityType<J>> jellyfish, Class<J> jellyfishClass, Rarity rarity) {
        JELLYFISHES.add(new JellyfishEntry<J>(jellyfish, rarity));
        IDS.putIfAbsent(jellyfishClass, JellyfishRegistry.getNextId());
    }

    public static List<JellyfishEntry<?>> collectJelliesMatchingRarity(Rarity rarity) {
        List<JellyfishEntry<?>> jellies = JELLYFISHES;
        jellies.removeIf(jellyfish -> jellyfish.rarity != rarity);
        return jellies;
    }

    public static JellyfishEntry<?> getRandomJellyfish(Random rand) {
        float chance = rand.nextFloat();
        if (chance > 50.0f) {
            List<JellyfishEntry<?>> commonJellies = JellyfishRegistry.collectJelliesMatchingRarity(Rarity.COMMON);
            return commonJellies.get(rand.nextInt(commonJellies.size()));
        }
        if (chance < 50.0f && chance > 15.0f) {
            List<JellyfishEntry<?>> uncommonJellies = JellyfishRegistry.collectJelliesMatchingRarity(Rarity.UNCOMMON);
            return uncommonJellies.get(rand.nextInt(uncommonJellies.size()));
        }
        if (chance < 15.0f && chance > 0.5f) {
            List<JellyfishEntry<?>> rarerJellies = JellyfishRegistry.collectJelliesMatchingRarity(Rarity.RARE);
            return rarerJellies.get(rand.nextInt(rarerJellies.size()));
        }
        List<JellyfishEntry<?>> epicJellies = JellyfishRegistry.collectJelliesMatchingRarity(Rarity.EPIC);
        return epicJellies.get(rand.nextInt(epicJellies.size()));
    }

    public static int getNextId() {
        int id = 0;
        if (!IDS.isEmpty()) {
            for (Map.Entry<Class<? extends AbstractJellyfishEntity>, Integer> entries : IDS.entrySet()) {
                int ids = entries.getValue();
                if (ids <= id) continue;
                id = ids;
            }
        }
        return id + 1;
    }

    static {
        JellyfishRegistry.registerJellyfish(UAEntities.BOX_JELLYFISH, BoxJellyfishEntity.class, Rarity.COMMON);
        JellyfishRegistry.registerJellyfish(UAEntities.CASSIOPEA_JELLYFISH, CassiopeaJellyfishEntity.class, Rarity.COMMON);
        JellyfishRegistry.registerJellyfish(UAEntities.IMMORTAL_JELLYFISH, ImmortalJellyfishEntity.class, Rarity.COMMON);
    }

    public static class JellyfishEntry<J extends AbstractJellyfishEntity> {
        public final Supplier<EntityType<J>> jellyfish;
        public final Rarity rarity;

        public JellyfishEntry(Supplier<EntityType<J>> jellyfish, Rarity rarity) {
            this.jellyfish = jellyfish;
            this.rarity = rarity;
        }
    }
}

