/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.travelers_index.client.pages;

import com._idrae.travelers_index.client.buttons.SortButton;
import com._idrae.travelers_index.client.gui.IndexScreen;
import com._idrae.travelers_index.client.pages.Page;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

@OnlyIn(value=Dist.CLIENT)
public class ItemPage
extends Page {
    private static final int NUM_ITEMS_PER_PAGE = 16;
    private static final int STRING_MAX_WIDTH = 90;
    private static final int PAGE_MARGIN_Y = 32;
    private static final int STRING_MARGIN_Y = 5;
    private static final int ITEM_GAP_X = 22;
    private static final int ITEM_GAP_Y = 12;
    private static final int SORT_BUTTON_MARGIN_X = 295;
    private static final int SORT_BUTTON_MARGIN_Y = 16;
    private static final int ITEM_BOX_LOCATION_X = 167;
    private static final int ITEM_BOX_LOCATION_Y = 35;
    private static final int ITEM_BOX_WIDTH = 18;
    private static final int ITEM_BOX_HEIGHT = 18;
    private static final int ITEM_BOX_MARGIN_X = 17;
    private static final int CHECKBOX_LOCATION_X = 187;
    private static final int CHECKBOX_LOCATION_Y_CHECKED = 35;
    private static final int CHECKBOX_LOCATION_Y_UNCHECKED = 45;
    private static final int CHECKBOX_WIDTH = 11;
    private static final int CHECKBOX_HEIGHT = 10;
    private static final int CHECKBOX_MARGIN_X_RIGHT = 22;
    private static final int CHECKBOX_MARGIN_Y = 4;
    private SortButton sortButton;
    private String sortMethod = "alphabetical";
    private String nextSortMethod;
    private boolean sortFlag = false;
    private final IndexScreen screen;
    private String category;
    private final ModInfo mod;
    private ArrayList<String> elements;
    private final ArrayList<Item> items;
    private final ArrayList<Item> checkedItems;
    private HashMap<Item, Integer> obtentionDates;

    public ItemPage(IndexScreen screen, String category, ModInfo mod, ArrayList<Item> items, ArrayList<Item> checkedItems, HashMap<Item, Integer> obtentionDates) {
        super(screen);
        this.screen = screen;
        this.category = category;
        this.mod = mod;
        this.items = items;
        this.checkedItems = checkedItems;
        this.obtentionDates = obtentionDates;
    }

    public void init() {
        this.numPages = this.computePageNumber(this.items.size(), 16);
        this.initChangePageButtons(button -> this.previousPage(), button -> this.nextPage(), this.page, this.numPages);
        this.initBackButton(button -> this.discardAndShowModPage());
        this.items.sort(Comparator.comparing(item -> item.func_200295_i(new ItemStack((IItemProvider)item)).getString()));
        this.initSortButton();
    }

    private void initSortButton() {
        Button.IPressable onPress;
        switch (this.sortMethod) {
            case "alphabetical": {
                this.nextSortMethod = "checked_before";
                onPress = button -> this.sortWithCheckedBefore();
                break;
            }
            case "checked_before": {
                this.nextSortMethod = "unchecked_before";
                onPress = button -> this.sortWithUncheckedBefore();
                break;
            }
            case "unchecked_before": {
                this.nextSortMethod = "obtainment";
                onPress = button -> this.sortByObtainment();
                break;
            }
            default: {
                this.nextSortMethod = "alphabetical";
                onPress = button -> this.sortAlphabetically();
            }
        }
        this.sortButton = new SortButton(this.screen, this.screen.pageStartX + 295, this.screen.pageStartY + 16, this.nextSortMethod, onPress);
        this.screen.addButton(this.sortButton);
    }

    private void sortAlphabetically() {
        this.items.sort(Comparator.comparing(item -> item.func_200295_i(new ItemStack((IItemProvider)item)).getString()));
        this.sortMethod = "alphabetical";
        this.sortButton.field_230694_p_ = false;
        this.sortFlag = true;
        this.page = 0;
    }

    private void sortWithCheckedBefore() {
        this.items.sort((item1, item2) -> {
            if (this.checkedItems.contains(item1)) {
                if (this.checkedItems.contains(item2)) {
                    return 0;
                }
                return -1;
            }
            if (this.checkedItems.contains(item2)) {
                return 1;
            }
            return 0;
        });
        this.sortMethod = "checked_before";
        this.sortButton.field_230694_p_ = false;
        this.sortFlag = true;
        this.page = 0;
    }

    private void sortWithUncheckedBefore() {
        this.items.sort((item1, item2) -> {
            if (this.checkedItems.contains(item1)) {
                if (this.checkedItems.contains(item2)) {
                    return 0;
                }
                return 1;
            }
            if (this.checkedItems.contains(item2)) {
                return -1;
            }
            return 0;
        });
        this.sortMethod = "unchecked_before";
        this.sortButton.field_230694_p_ = false;
        this.sortFlag = true;
        this.page = 0;
    }

    private void sortByObtainment() {
        this.items.sort((item1, item2) -> {
            if (this.checkedItems.contains(item1)) {
                if (this.checkedItems.contains(item2)) {
                    return this.obtentionDates.get(item1).compareTo(this.obtentionDates.get(item2));
                }
                return -1;
            }
            if (this.checkedItems.contains(item2)) {
                return 1;
            }
            return 0;
        });
        this.sortMethod = "obtainment";
        this.sortButton.field_230694_p_ = false;
        this.sortFlag = true;
        this.page = 0;
    }

    private void nextPage() {
        if (this.numPages > 1) {
            this.page = this.page == this.numPages - 1 ? 0 : ++this.page;
            this.updateChangePageButtons();
        }
    }

    private void previousPage() {
        if (this.numPages > 1) {
            this.page = this.page == 0 ? this.numPages - 1 : --this.page;
            this.updateChangePageButtons();
        }
    }

    public void render(MatrixStack matrixStack) {
        if (this.sortFlag) {
            this.initSortButton();
            this.sortFlag = false;
        }
        this.drawItemsAndIcons(matrixStack);
        this.drawPageCount(matrixStack);
    }

    public void renderTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.renderItemTooltips(matrixStack, mouseX, mouseY);
        this.renderSortTooltip(matrixStack, mouseX, mouseY);
    }

    private void renderItemTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
        for (int i = 0; i < 16; ++i) {
            boolean isHovered;
            boolean onLeftPage;
            Item item;
            String name;
            int size;
            int index = this.page * 16 + i;
            if (index >= this.items.size() || (size = this.screen.getStringWidth(name = (item = this.items.get(index)).func_200295_i(new ItemStack((IItemProvider)item)).getString())) <= 90) continue;
            int numItemsPerHalfPage = 8;
            boolean bl = onLeftPage = i < numItemsPerHalfPage;
            boolean bl2 = onLeftPage ? mouseX >= this.screen.pageStartX + 18 + 22 && mouseX < this.screen.pageStartX + 18 + 22 + 90 && mouseY >= this.screen.pageStartY + 32 + 5 + i * 21 && mouseY < this.screen.pageStartY + 32 + 5 + i * 21 + 9 : (isHovered = mouseX >= this.screen.pageStartX + 155 + 18 + 22 && mouseX < this.screen.pageStartX + 155 + 18 + 22 + 90 && mouseY >= this.screen.pageStartY + 32 + 5 + (i - numItemsPerHalfPage) * 21 && mouseY < this.screen.pageStartY + 32 + 5 + (i - numItemsPerHalfPage) * 21 + 9);
            if (!isHovered) continue;
            this.screen.func_238652_a_(matrixStack, (ITextComponent)new StringTextComponent(name), mouseX, mouseY);
        }
    }

    private void renderSortTooltip(MatrixStack matrixStack, int mouseX, int mouseY) {
        String tooltip;
        switch (this.sortMethod) {
            case "alphabetical": {
                tooltip = "Sorting: Alphabetical";
                break;
            }
            case "checked_before": {
                tooltip = "Sorting: Checked before / Alphabetical";
                break;
            }
            case "unchecked_before": {
                tooltip = "Sorting: Unchecked before / Alphabetical";
                break;
            }
            default: {
                tooltip = "Sorting: Obtainment";
            }
        }
        if (this.sortButton.func_230449_g_()) {
            this.screen.func_238652_a_(matrixStack, (ITextComponent)new StringTextComponent(tooltip), mouseX, mouseY);
        }
    }

    private void drawItemsAndIcons(MatrixStack matrixStack) {
        for (int i = 0; i < 16; ++i) {
            int index = this.page * 16 + i;
            if (index >= this.items.size()) continue;
            Item item = this.items.get(index);
            String name = item.func_200295_i(new ItemStack((IItemProvider)item)).getString();
            boolean isChecked = this.checkedItems.contains(item);
            int numItemsPerHalfPage = 8;
            boolean onLeftPage = i < numItemsPerHalfPage;
            this.screen.drawString(matrixStack, name, onLeftPage ? this.screen.pageStartX + 18 + 22 : this.screen.pageStartX + 155 + 18 + 22, onLeftPage ? this.screen.pageStartY + 32 + 5 + i * 21 : this.screen.pageStartY + 32 + 5 + (i - numItemsPerHalfPage) * 21, 90, isChecked ? 43520 : 0);
            this.screen.getMinecraft().func_175599_af().func_175042_a(new ItemStack((IItemProvider)item), onLeftPage ? this.screen.pageStartX + 18 : this.screen.pageStartX + 18 + 155, onLeftPage ? this.screen.pageStartY + 32 + i * 21 : this.screen.pageStartY + 32 + (i - numItemsPerHalfPage) * 21);
            this.screen.getMinecraft().func_110434_K().func_110577_a(IndexScreen.LEFT_TEXTURE);
            this.screen.func_238474_b_(matrixStack, onLeftPage ? this.screen.pageStartX + 18 - 1 : this.screen.pageStartX + 155 + 18 - 1, onLeftPage ? this.screen.pageStartY + 32 - 1 + i * 21 : this.screen.pageStartY + 32 - 1 + (i - numItemsPerHalfPage) * 21, 167, 35, 18, 18);
            this.screen.getMinecraft().func_110434_K().func_110577_a(IndexScreen.LEFT_TEXTURE);
            this.screen.func_238474_b_(matrixStack, onLeftPage ? this.screen.pageStartX + 163 - 22 : this.screen.pageStartX + 163 + 155 - 22, onLeftPage ? this.screen.pageStartY + 32 + 4 + i * 21 : this.screen.pageStartY + 32 + 4 + (i - numItemsPerHalfPage) * 21, 187, isChecked ? 35 : 45, 11, 10);
        }
    }

    @Override
    public void clearButtons() {
        this.sortButton.field_230694_p_ = false;
        super.clearButtons();
    }

    private void discardAndShowModPage() {
        this.clearButtons();
        this.screen.showModPage(this.mod);
    }
}

