/*
 * Decompiled with CFR 0.152.
 */
package tfar.toughnessbar;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import tfar.toughnessbar.ToughnessBar;

public class EventHandlerClient {
    private final ResourceLocation TEXTURE = new ResourceLocation("toughnessbar", "textures/gui/toughness.png");
    private final List<Integer> colors = new ArrayList<Integer>();
    private static final Minecraft mc = Minecraft.func_71410_x();
    int lastToughness = 0;
    static Index[] indexes;

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderArmorToughnessEvent(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.FOOD && mc.func_175606_aa() instanceof LivingEntity) {
            LivingEntity viewEntity = (LivingEntity)mc.func_175606_aa();
            int armorToughness = MathHelper.func_76128_c((double)viewEntity.func_110148_a(Attributes.field_233827_j_).func_111126_e());
            if (armorToughness < 1) {
                return;
            }
            if (this.colors.isEmpty()) {
                ((List)ToughnessBar.ToughnessBarConfig.ClientConfig.colorValues.get()).stream().filter(hexColor -> hexColor.startsWith("#")).forEach(hexColor -> this.colors.add(Integer.parseInt(hexColor.substring(1), 16)));
                if (this.colors.isEmpty()) {
                    this.colors.add(0xFFFFFF);
                }
            }
            if (this.lastToughness != armorToughness) {
                this.calculateIndex(armorToughness);
            }
            int layer = (int)Math.ceil((double)armorToughness / 20.0) - 1;
            int color = this.getColor(layer);
            int previous = this.getColor(layer - 1);
            RenderSystem.enableBlend();
            RenderSystem.pushMatrix();
            int top = mc.func_228018_at_().func_198087_p() - ForgeIngameGui.right_height;
            int right = mc.func_228018_at_().func_198107_o() / 2 + 82;
            mc.func_110434_K().func_110577_a(this.TEXTURE);
            block10: for (int i = 0; i < 10; ++i) {
                Index index = indexes[i];
                MatrixStack stack = event.getMatrixStack();
                if (layer > 0) {
                    switch (index) {
                        case empty: {
                            this.drawFullIcon(stack, previous, i, right, top);
                            break;
                        }
                        case half: {
                            this.drawSplitIcon(stack, previous, color, i, right, top);
                            break;
                        }
                        case full: {
                            this.drawFullIcon(stack, color, i, right, top);
                        }
                    }
                    continue;
                }
                switch (index) {
                    case empty: {
                        if (!((Boolean)ToughnessBar.ToughnessBarConfig.ClientConfig.empty.get()).booleanValue()) continue block10;
                        this.drawEmptyIcon(stack, color, i, right, top);
                        continue block10;
                    }
                    case half: {
                        this.drawHalfIcon(stack, color, i, right, top);
                        continue block10;
                    }
                    case full: {
                        this.drawFullIcon(stack, color, i, right, top);
                    }
                }
            }
            ForgeIngameGui.right_height += 10;
            RenderSystem.popMatrix();
            mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
            RenderSystem.disableBlend();
        }
    }

    void calculateIndex(int armorToughness) {
        indexes = new Index[]{Index.empty, Index.empty, Index.empty, Index.empty, Index.empty, Index.empty, Index.empty, Index.empty, Index.empty, Index.empty};
        int modulo = armorToughness % 20;
        if (modulo == 0) {
            indexes = new Index[]{Index.full, Index.full, Index.full, Index.full, Index.full, Index.full, Index.full, Index.full, Index.full, Index.full};
            return;
        }
        int fullicons = modulo / 2;
        boolean halficon = armorToughness % 2 == 1;
        for (int i = 0; i < fullicons; ++i) {
            EventHandlerClient.indexes[i] = Index.full;
        }
        if (halficon) {
            EventHandlerClient.indexes[fullicons] = Index.half;
        }
        this.lastToughness = armorToughness;
    }

    private int getColor(int index) {
        return index < 0 ? 0xFFFFFF : (index >= this.colors.size() ? this.colors.get(this.colors.size() - 1).intValue() : this.colors.get(index).intValue());
    }

    private void drawEmptyIcon(MatrixStack stack, int color, int i, int guiLeft, int guiTop) {
        RenderSystem.color3f((float)((float)(color >> 16 & 0xFF) / 256.0f), (float)((float)(color >> 8 & 0xFF) / 256.0f), (float)((float)(color & 0xFF) / 256.0f));
        EventHandlerClient.blit(stack, guiLeft - i * 8, guiTop, 18.0f, 27.0f, 9, 9);
    }

    private void drawFullIcon(MatrixStack stack, int color, int i, int guiLeft, int guiTop) {
        RenderSystem.color3f((float)((float)(color >> 16 & 0xFF) / 256.0f), (float)((float)(color >> 8 & 0xFF) / 256.0f), (float)((float)(color & 0xFF) / 256.0f));
        EventHandlerClient.blit(stack, guiLeft - i * 8, guiTop, 9.0f, 18.0f, 9, 9);
    }

    private void drawHalfIcon(MatrixStack stack, int color, int i, int guiLeft, int guiTop) {
        RenderSystem.color3f((float)((float)(color >> 16 & 0xFF) / 256.0f), (float)((float)(color >> 8 & 0xFF) / 256.0f), (float)((float)(color & 0xFF) / 256.0f));
        if (((Boolean)ToughnessBar.ToughnessBarConfig.ClientConfig.empty.get()).booleanValue()) {
            this.drawEmptyIcon(stack, color, i, guiLeft, guiTop);
        }
        EventHandlerClient.blit(stack, guiLeft - i * 8, guiTop, 0.0f, 9.0f, 9, 9);
    }

    private void drawSplitIcon(MatrixStack stack, int color1, int color2, int i, int guiLeft, int guiTop) {
        this.drawFullIcon(stack, color1, i, guiLeft, guiTop);
        RenderSystem.color3f((float)((float)(color2 >> 16 & 0xFF) / 256.0f), (float)((float)(color2 >> 8 & 0xFF) / 256.0f), (float)((float)(color2 & 0xFF) / 256.0f));
        EventHandlerClient.blit(stack, guiLeft - i * 8, guiTop, 0.0f, 9.0f, 9, 9);
    }

    public static void blit(MatrixStack stack, int x, int y, float u, float v, int width, int height) {
        EventHandlerClient.blit(stack, x, y, 0, u, v, width, height, 9, 27);
    }

    public static void blit(MatrixStack stack, int x, int y, int z, float u, float v, int width, int height, int textureX, int textureY) {
        AbstractGui.func_238464_a_((MatrixStack)stack, (int)x, (int)y, (int)z, (float)u, (float)v, (int)width, (int)height, (int)textureX, (int)textureY);
    }

    static enum Index {
        half,
        full,
        empty;

    }
}

