/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.conjurer_illager.world;

import com.google.common.collect.Lists;
import com.legacy.conjurer_illager.ConjurerIllagerMod;
import com.legacy.conjurer_illager.IllagerRegistry;
import com.legacy.conjurer_illager.entity.ConjurerEntity;
import com.legacy.conjurer_illager.registry.IllagerEntityTypes;
import com.legacy.conjurer_illager.registry.IllagerStructures;
import com.legacy.structure_gel.util.ConfigTemplates;
import com.legacy.structure_gel.worldgen.jigsaw.AbstractGelStructurePiece;
import com.legacy.structure_gel.worldgen.jigsaw.GelConfigJigsawStructure;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.LecternTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class TheaterStructure
extends GelConfigJigsawStructure {
    public TheaterStructure(Codec<VillageConfig> codec, ConfigTemplates.StructureConfig config) {
        super(codec, config, 0, true, true);
        this.setSpawnList(EntityClassification.MONSTER, Lists.newArrayList());
    }

    public int getSeed() {
        return 257857;
    }

    public JigsawManager.IPieceFactory getPieceType() {
        return Piece::new;
    }

    public static class Piece
    extends AbstractGelStructurePiece {
        public Piece(TemplateManager template, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox boundingBox) {
            super(template, jigsawPiece, pos, groundLevelDelta, rotation, boundingBox);
        }

        public Piece(TemplateManager template, CompoundNBT nbt) {
            super(template, nbt);
        }

        public void handleDataMarker(String key, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox bounds) {
            Direction facing;
            String[] data;
            ConjurerEntity entity;
            if (key.equals("conjurer")) {
                this.setAir((IWorld)worldIn, pos);
                entity = (ConjurerEntity)this.createEntity(IllagerEntityTypes.CONJURER, worldIn, pos, this.field_214834_c);
                entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                entity.func_110163_bv();
                worldIn.func_217376_c((Entity)entity);
            }
            if (key.equals("admissioner")) {
                this.setAir((IWorld)worldIn, pos);
                entity = (PillagerEntity)this.createEntity(EntityType.field_220350_aJ, worldIn, pos, this.field_214834_c);
                entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                entity.func_110163_bv();
                worldIn.func_217376_c((Entity)entity);
            }
            if (key.equals("villager")) {
                this.setAir((IWorld)worldIn, pos);
                entity = (VillagerEntity)this.createEntity(EntityType.field_200756_av, worldIn, pos, this.field_214834_c);
                entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                worldIn.func_217376_c((Entity)entity);
                ((VillagerEntity)entity).field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)entity, ConjurerEntity.class, 15.0f, 2.0f));
            }
            if (key.equals("audience")) {
                this.setAir((IWorld)worldIn, pos);
                entity = (MobEntity)this.createEntity(EntityType.field_220350_aJ, worldIn, pos, this.field_214834_c);
                if (rand.nextFloat() < 0.05f) {
                    entity = (MobEntity)this.createEntity(EntityType.field_200764_D, worldIn, pos, this.field_214834_c);
                } else if (rand.nextFloat() < 0.4f) {
                    entity = (MobEntity)this.createEntity(EntityType.field_200758_ax, worldIn, pos, this.field_214834_c);
                } else if (rand.nextFloat() < 0.2f) {
                    entity = (MobEntity)this.createEntity(EntityType.field_200759_ay, worldIn, pos, this.field_214834_c);
                }
                entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                entity.func_110163_bv();
                worldIn.func_217376_c((Entity)entity);
                ((MobEntity)entity).field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)entity, ConjurerEntity.class, 15.0f, 2.0f));
            }
            if (key.contains("lectern")) {
                this.setAir((IWorld)worldIn, pos);
                ItemStack bookStack = new ItemStack((IItemProvider)Items.field_151164_bB);
                CompoundNBT bookNBT = bookStack.func_196082_o();
                ListNBT bookPages = new ListNBT();
                String pageText = "Free Admission List\n -=-=-=-=-=-=-=-=-\n";
                String[] names = (String[])ConjurerIllagerMod.SUPPORTERS.getSupporters().stream().map(mls -> mls.name).toArray(String[]::new);
                if (names.length > 0) {
                    for (int i = 0; i < 8; ++i) {
                        String name = names[rand.nextInt(names.length)];
                        pageText = pageText + name + "\n";
                        names = (String[])Arrays.asList(names).stream().filter(s -> s != name).toArray(String[]::new);
                    }
                    bookPages.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent(pageText))));
                    bookNBT.func_74778_a("title", "Admission List");
                    bookNBT.func_74778_a("author", "The Conjurer");
                    bookNBT.func_218657_a("pages", (INBT)bookPages);
                    bookStack.func_77982_d(bookNBT);
                    LecternTileEntity lectern = (LecternTileEntity)worldIn.func_175625_s(pos.func_177977_b());
                    lectern.func_214045_a(bookStack);
                }
            }
            if (key.contains("chest")) {
                data = key.split("-");
                facing = Direction.func_176739_a((String)data[1]);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                worldIn.func_180501_a(pos, ((BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)facing)).rotate((IWorld)worldIn, pos, this.field_214834_c), 3);
            }
            if (key.equals("fish")) {
                worldIn.func_180501_a(pos, Blocks.field_150322_A.func_176223_P(), 3);
                entity = (TropicalFishEntity)this.createEntity(EntityType.field_204262_at, worldIn, pos.func_177981_b(rand.nextInt(3) + 1), this.field_214834_c);
                entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                entity.func_110163_bv();
                worldIn.func_217376_c((Entity)entity);
            }
            if (key.contains("art")) {
                data = key.split("-");
                facing = Direction.func_176739_a((String)data[1]);
                this.setAir((IWorld)worldIn, pos);
                PaintingEntity entity2 = (PaintingEntity)this.createEntity(EntityType.field_200782_V, worldIn, pos, this.field_214834_c);
                entity2.field_70522_e = IllagerRegistry.THEATER_PAINTING;
                try {
                    ObfuscationReflectionHelper.setPrivateValue(HangingEntity.class, (Object)entity2, (Object)this.field_214834_c.func_185831_a(facing), (String)"field_174860_b");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                worldIn.func_217376_c((Entity)entity2);
            }
        }

        public IStructurePieceType func_214807_k() {
            return IllagerStructures.THEATER.getPieceType();
        }
    }
}

