/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.AbstractFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.OptionPageFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.ScrollableFrame;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class Tab<T extends AbstractFrame> {
    private final ITextComponent title;
    private final Function<Dim2i, T> frameFunction;

    public Tab(ITextComponent title, Function<Dim2i, T> frameFunction) {
        this.title = title;
        this.frameFunction = frameFunction;
    }

    public static Builder<?> createBuilder() {
        return new Builder();
    }

    public ITextComponent getTitle() {
        return this.title;
    }

    public Function<Dim2i, T> getFrameFunction() {
        return this.frameFunction;
    }

    public static class Builder<T extends AbstractFrame> {
        private ITextComponent title;
        private Function<Dim2i, T> frameFunction;

        public Builder<T> setTitle(ITextComponent title) {
            this.title = title;
            return this;
        }

        public Builder<T> setFrameFunction(Function<Dim2i, T> frameFunction) {
            this.frameFunction = frameFunction;
            return this;
        }

        public Tab<T> build() {
            return new Tab<T>(this.title, this.frameFunction);
        }

        public Tab<ScrollableFrame> from(OptionPage page, AtomicReference<Integer> verticalScrollBarOffset) {
            return new Tab<ScrollableFrame>((ITextComponent)new StringTextComponent(page.getName()), dim2i -> ScrollableFrame.createBuilder().setDimension((Dim2i)dim2i).setFrame(new OptionPageFrame(new Dim2i(dim2i.getOriginX(), dim2i.getOriginY(), dim2i.getWidth(), dim2i.getHeight()), false, page)).setVerticalScrollBarOffset(verticalScrollBarOffset).build());
        }
    }
}

