/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import me.flashyreese.mods.reeses_sodium_options.client.gui.Dim2iExtended;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.AbstractFrame;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.Validate;

public class OptionPageFrame
extends AbstractFrame {
    protected final OptionPage page;
    private final int lastDimLimitY;
    private long lastTime = 0L;
    private ControlElement<?> lastHoveredElement = null;

    public OptionPageFrame(Dim2i dim, boolean renderOutline, OptionPage page) {
        super(dim, renderOutline);
        this.lastDimLimitY = dim.getLimitY();
        this.page = page;
        this.setupFrame();
        this.buildFrame();
    }

    public void setupFrame() {
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        int y = 0;
        if (!this.page.getGroups().isEmpty()) {
            OptionGroup lastGroup = (OptionGroup)this.page.getGroups().get(this.page.getGroups().size() - 1);
            for (OptionGroup group : this.page.getGroups()) {
                y += group.getOptions().size() * 18;
                if (group == lastGroup) continue;
                y += 4;
            }
        }
        ((Dim2iExtended)this.dim).setHeight(y);
    }

    @Override
    public void buildFrame() {
        if (this.page == null) {
            return;
        }
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        int y = 0;
        for (OptionGroup group : this.page.getGroups()) {
            for (Option option : group.getOptions()) {
                Control control = option.getControl();
                ControlElement element = control.createElement(new Dim2i(this.dim.getOriginX(), this.dim.getOriginY() + y, this.dim.getWidth(), 18));
                this.children.add(element);
                y += 18;
            }
            y += 4;
        }
        super.buildFrame();
    }

    @Override
    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        ControlElement hoveredElement = this.controlElements.stream().filter(ControlElement::isHovered).findFirst().orElse(null);
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        if (this.dim.containsCursor((double)mouseX, (double)mouseY) && hoveredElement != null && this.lastHoveredElement == hoveredElement) {
            if (this.lastTime == 0L) {
                this.lastTime = System.currentTimeMillis();
            }
            this.renderOptionTooltip(matrices, hoveredElement);
        } else {
            this.lastTime = 0L;
            this.lastHoveredElement = hoveredElement;
        }
    }

    private void renderOptionTooltip(MatrixStack matrixStack, ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        if (this.lastTime + 500L > System.currentTimeMillis()) {
            return;
        }
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = dim.getWidth();
        int boxY = dim.getLimitY();
        int boxX = dim.getOriginX();
        Option option = element.getOption();
        ArrayList<IReorderingProcessor> tooltip = new ArrayList<IReorderingProcessor>(Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)option.getTooltip(), boxWidth - textPadding * 2));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            tooltip.add(LanguageMap.func_74808_a().func_241870_a((ITextProperties)new TranslationTextComponent("sodium.options.performance_impact_string", new Object[]{impact.toDisplayString()}).func_240699_a_(TextFormatting.GRAY)));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + boxPadding)) > (boxYCutoff = this.lastDimLimitY)) {
            boxY -= boxHeight + dim.getHeight();
        }
        if (boxY < 0) {
            boxY = dim.getLimitY();
        }
        this.drawRect(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -536870912);
        this.drawRectOutline(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -7019309);
        for (int i = 0; i < tooltip.size(); ++i) {
            Minecraft.func_71410_x().field_71466_p.func_238422_b_(matrixStack, (IReorderingProcessor)tooltip.get(i), (float)(boxX + textPadding), (float)(boxY + textPadding + i * 12), -1);
        }
    }

    public static class Builder {
        private Dim2i dim;
        private boolean renderOutline;
        private OptionPage page;

        public Builder setDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder shouldRenderOutline(boolean renderOutline) {
            this.renderOutline = renderOutline;
            return this;
        }

        public Builder setOptionPage(OptionPage page) {
            this.page = page;
            return this;
        }

        public OptionPageFrame build() {
            Validate.notNull((Object)this.dim, (String)"Dimension must be specified", (Object[])new Object[0]);
            return new OptionPageFrame(this.dim, this.renderOutline, this.page);
        }
    }
}

