/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import me.flashyreese.mods.reeses_sodium_options.client.ReesesSodiumOptionsClientMod;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.AbstractFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.BasicFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab.Tab;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab.TabFrame;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.VideoSettingsScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SodiumVideoOptionsScreen
extends Screen {
    private static final AtomicReference<ITextComponent> tabFrameSelectedTab = new AtomicReference<Object>(null);
    private static final AtomicReference<Integer> tabFrameScrollBarOffset = new AtomicReference<Integer>(0);
    private static final AtomicReference<Integer> optionPageScrollBarOffset = new AtomicReference<Integer>(0);
    private final Screen prevScreen;
    private final List<OptionPage> pages = new ArrayList<OptionPage>();
    private AbstractFrame frame;
    private FlatButtonWidget applyButton;
    private FlatButtonWidget closeButton;
    private FlatButtonWidget undoButton;
    private FlatButtonWidget donateButton;
    private FlatButtonWidget hideDonateButton;
    private boolean hasPendingChanges;

    public SodiumVideoOptionsScreen(Screen prev, List<OptionPage> pages) {
        super((ITextComponent)new StringTextComponent("Reese's Sodium Menu"));
        this.prevScreen = prev;
        this.pages.addAll(pages);
    }

    protected void func_231160_c_() {
        this.frame = this.parentFrameBuilder().build();
        this.field_230705_e_.add(this.frame);
    }

    protected BasicFrame.Builder parentFrameBuilder() {
        Dim2i basicFrameDim = new Dim2i(0, 0, this.field_230708_k_, this.field_230709_l_);
        Dim2i tabFrameDim = new Dim2i(basicFrameDim.getWidth() / 20 / 2, basicFrameDim.getHeight() / 4 / 2, basicFrameDim.getWidth() - basicFrameDim.getWidth() / 20, basicFrameDim.getHeight() / 4 * 3);
        Dim2i undoButtonDim = new Dim2i(tabFrameDim.getLimitX() - 203, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i applyButtonDim = new Dim2i(tabFrameDim.getLimitX() - 134, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i closeButtonDim = new Dim2i(tabFrameDim.getLimitX() - 65, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i donateButtonDim = new Dim2i(tabFrameDim.getLimitX() - 122, tabFrameDim.getOriginY() - 26, 100, 20);
        Dim2i hideDonateButtonDim = new Dim2i(tabFrameDim.getLimitX() - 20, tabFrameDim.getOriginY() - 26, 20, 20);
        this.undoButton = new FlatButtonWidget(undoButtonDim, I18n.func_135052_a((String)"sodium.options.buttons.undo", (Object[])new Object[0]), this::undoChanges);
        this.applyButton = new FlatButtonWidget(applyButtonDim, I18n.func_135052_a((String)"sodium.options.buttons.apply", (Object[])new Object[0]), this::applyChanges);
        this.closeButton = new FlatButtonWidget(closeButtonDim, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), this::func_231175_as__);
        this.donateButton = new FlatButtonWidget(donateButtonDim, I18n.func_135052_a((String)"sodium.options.buttons.donate", (Object[])new Object[0]), this::openDonationPage);
        this.hideDonateButton = new FlatButtonWidget(hideDonateButtonDim, "x", this::hideDonationButton);
        if (SodiumClientMod.options().notifications.hideDonationButton) {
            this.setDonationButtonVisibility(false);
        }
        BasicFrame.Builder basicFrameBuilder = this.parentBasicFrameBuilder(basicFrameDim, tabFrameDim);
        if (ReesesSodiumOptionsClientMod.oculusLoaded) {
            int size = this.field_230706_i_.field_71466_p.func_238414_a_((ITextProperties)new TranslationTextComponent(IrisApi.getInstance().getMainScreenLanguageKey()));
            Dim2i shaderPackButtonDim = !SodiumClientMod.options().notifications.hideDonationButton ? new Dim2i(tabFrameDim.getLimitX() - 134 - size, tabFrameDim.getOriginY() - 26, 10 + size, 20) : new Dim2i(tabFrameDim.getLimitX() - size - 10, tabFrameDim.getOriginY() - 26, 10 + size, 20);
            FlatButtonWidget shaderPackButton = new FlatButtonWidget(shaderPackButtonDim, new TranslationTextComponent(IrisApi.getInstance().getMainScreenLanguageKey()).getString(), () -> this.field_230706_i_.func_147108_a((Screen)IrisApi.getInstance().openMainIrisScreenObj((Object)this)));
            basicFrameBuilder.addChild(dim -> shaderPackButton);
        }
        return basicFrameBuilder;
    }

    public BasicFrame.Builder parentBasicFrameBuilder(Dim2i parentBasicFrameDim, Dim2i tabFrameDim) {
        return BasicFrame.createBuilder().setDimension(parentBasicFrameDim).shouldRenderOutline(false).addChild(dim -> this.undoButton).addChild(dim -> this.applyButton).addChild(dim -> this.closeButton).addChild(dim -> this.donateButton).addChild(dim -> this.hideDonateButton).addChild(parentDim -> TabFrame.createBuilder().setDimension(tabFrameDim).shouldRenderOutline(false).setTabSectionScrollBarOffset(tabFrameScrollBarOffset).setTabSectionSelectedTab(tabFrameSelectedTab).addTabs(tabs -> this.pages.stream().filter(page -> !page.getGroups().isEmpty()).forEach(page -> tabs.add(Tab.createBuilder().from((OptionPage)page, optionPageScrollBarOffset)))).onSetTab(() -> optionPageScrollBarOffset.set(0)).build());
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        super.func_230446_a_(matrices);
        this.updateControls();
        this.frame.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    private void updateControls() {
        boolean hasChanges = this.getAllOptions().anyMatch(Option::hasChanged);
        for (OptionPage page : this.pages) {
            for (Option option : page.getOptions()) {
                if (!option.hasChanged()) continue;
                hasChanges = true;
            }
        }
        this.applyButton.setEnabled(hasChanges);
        this.undoButton.setVisible(hasChanges);
        this.closeButton.setEnabled(!hasChanges);
        this.hasPendingChanges = hasChanges;
    }

    private void setDonationButtonVisibility(boolean value) {
        this.donateButton.setVisible(value);
        this.hideDonateButton.setVisible(value);
    }

    private void hideDonationButton() {
        SodiumGameOptions options = SodiumClientMod.options();
        options.notifications.hideDonationButton = true;
        try {
            options.writeChanges();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save configuration", e);
        }
        this.setDonationButtonVisibility(false);
        this.field_230705_e_.remove((Object)this.frame);
        this.frame = this.parentFrameBuilder().build();
        this.field_230705_e_.add(this.frame);
    }

    private void openDonationPage() {
        Util.func_110647_a().func_195640_a("https://caffeinemc.net/donate");
    }

    private Stream<Option<?>> getAllOptions() {
        return this.pages.stream().flatMap(s -> s.getOptions().stream());
    }

    private void applyChanges() {
        HashSet dirtyStorages = new HashSet();
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        this.getAllOptions().forEach(option -> {
            if (!option.hasChanged()) {
                return;
            }
            option.applyChanges();
            flags.addAll(option.getFlags());
            dirtyStorages.add(option.getStorage());
        });
        Minecraft client = Minecraft.func_71410_x();
        if (flags.contains(OptionFlag.REQUIRES_RENDERER_RELOAD)) {
            client.field_71438_f.func_72712_a();
        }
        if (flags.contains(OptionFlag.REQUIRES_ASSET_RELOAD)) {
            client.func_228020_b_(client.field_71474_y.field_151442_I);
            client.func_213245_w();
        }
        for (OptionStorage storage : dirtyStorages) {
            storage.save();
        }
    }

    private void undoChanges() {
        this.getAllOptions().forEach(Option::reset);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 80 && (modifiers & 1) != 0) {
            Minecraft.func_71410_x().func_147108_a((Screen)new VideoSettingsScreen(this.prevScreen, Minecraft.func_71410_x().field_71474_y));
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231178_ax__() {
        return !this.hasPendingChanges;
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a(this.prevScreen);
    }
}

