/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.mixin;

import azmalent.cuneiform.lib.util.BiomeUtil;
import azmalent.terraincognita.TIConfig;
import azmalent.terraincognita.common.registry.ModBlocks;
import azmalent.terraincognita.common.world.ModFlowerFeatures;
import azmalent.terraincognita.util.WorldGenUtil;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassBlock;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={GrassBlock.class})
public class GrassBlockMixin {
    private static BlockClusterFeatureConfig getCustomFlowerConfig(Random rand, IWorldReader world, BlockPos pos) {
        Biome biome = world.func_226691_t_(pos);
        RegistryKey biomeKey = BiomeUtil.getBiomeKey((Biome)biome);
        if (biomeKey != Biomes.field_185444_T && rand.nextBoolean()) {
            switch (WorldGenUtil.getProperBiomeCategory(biome)) {
                case FOREST: {
                    if (!TIConfig.Flora.forestFlowers.get().booleanValue()) break;
                    return ModFlowerFeatures.Configs.FOREST_FLOWERS;
                }
                case SWAMP: {
                    if (!TIConfig.Flora.swampFlowers.get().booleanValue() || BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) break;
                    return ModFlowerFeatures.Configs.SWAMP_SMALL_FLOWERS;
                }
                case SAVANNA: 
                case DESERT: {
                    if (!TIConfig.Flora.savannaFlowers.get().booleanValue()) break;
                    return ModFlowerFeatures.Configs.SAVANNA_SMALL_FLOWERS;
                }
                case EXTREME_HILLS: {
                    if (!TIConfig.Flora.alpineFlowers.get().booleanValue() || BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.HOT)) break;
                    return ModFlowerFeatures.Configs.ALPINE_FLOWERS;
                }
                case JUNGLE: {
                    if (!TIConfig.Flora.jungleFlowers.get().booleanValue()) break;
                    return ModFlowerFeatures.Configs.JUNGLE_FLOWERS;
                }
                case TAIGA: 
                case ICY: {
                    if (!TIConfig.Flora.arcticFlowers.get().booleanValue()) break;
                    return ModFlowerFeatures.Configs.ARCTIC_SMALL_FLOWERS;
                }
            }
        }
        return null;
    }

    @Redirect(method={"grow"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/gen/feature/FlowersFeature;getFlowerToPlace(Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/gen/feature/IFeatureConfig;)Lnet/minecraft/block/BlockState;"))
    private <TConfig extends IFeatureConfig> BlockState getFlowerToPlace(FlowersFeature<TConfig> self, Random rand, BlockPos pos, TConfig config, ServerWorld world, Random random1, BlockPos pos1, BlockState blockState) {
        BlockClusterFeatureConfig customFlowerConfig = GrassBlockMixin.getCustomFlowerConfig(rand, (IWorldReader)world, pos);
        if (customFlowerConfig != null) {
            return customFlowerConfig.field_227289_a_.func_225574_a_(rand, pos);
        }
        BlockState flower = self.func_225562_b_(rand, pos, config);
        if (flower.func_203425_a(Blocks.field_196605_bc) && TIConfig.Flora.dandelionPuff.get().booleanValue()) {
            if ((double)rand.nextFloat() < TIConfig.Flora.dandelionPuffChance.get()) {
                flower = ModBlocks.DANDELION_PUFF.getBlock().func_176223_P();
            }
        } else if (flower.func_203425_a(Blocks.field_196606_bd) && TIConfig.Flora.arcticFlowers.get().booleanValue() && world.func_226691_t_(pos).func_201856_r() == Biome.Category.ICY && (double)rand.nextFloat() < TIConfig.Flora.arcticPoppyChance.get()) {
            flower = ModBlocks.ARCTIC_POPPY.getBlock().func_176223_P();
        }
        return flower;
    }
}

