/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.world.feature;

import azmalent.terraincognita.common.registry.ModBlocks;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.VineBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class SweetPeasFeature
extends Feature<NoFeatureConfig> {
    public SweetPeasFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(@Nonnull ISeedReader reader, @Nonnull ChunkGenerator generator, Random rand, @Nonnull BlockPos pos, @Nonnull NoFeatureConfig config) {
        BlockState state = ModBlocks.SWEET_PEAS.get(rand.nextInt(ModBlocks.SWEET_PEAS.size())).getDefaultState();
        boolean success = false;
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        block0: for (int y = 64; y < 128; ++y) {
            mutablePos.func_189533_g((Vector3i)pos);
            mutablePos.func_196234_d(rand.nextInt(8) - rand.nextInt(8), 0, rand.nextInt(8) - rand.nextInt(8));
            mutablePos.func_185336_p(y);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!this.tryPlaceVine(reader, state, direction, mutablePos, rand)) continue;
                success = true;
                continue block0;
            }
        }
        return success;
    }

    private boolean tryPlaceVine(ISeedReader reader, BlockState defaultState, Direction direction, BlockPos.Mutable pos, Random rand) {
        boolean success = false;
        if (reader.func_180495_p(pos.func_177972_a(direction)).func_235714_a_((ITag)BlockTags.field_206952_E) && this.hasEnoughVerticalSpace(reader, (BlockPos)pos)) {
            int startY;
            int length = 3 + rand.nextInt(8);
            BlockState state = (BlockState)defaultState.func_206870_a((Property)VineBlock.func_176267_a((Direction)direction), (Comparable)Boolean.valueOf(true));
            for (int y = startY = pos.func_177956_o(); y > startY - length; --y) {
                pos.func_185336_p(y);
                if (!reader.func_175623_d((BlockPos)pos) || !state.func_196955_c((IWorldReader)reader, (BlockPos)pos)) break;
                reader.func_180501_a((BlockPos)pos, state, 2);
                success = true;
            }
        }
        return success;
    }

    private boolean hasEnoughVerticalSpace(ISeedReader reader, BlockPos pos) {
        for (int i = 0; i < 3; ++i) {
            if (reader.func_175623_d(pos.func_177979_c(i))) continue;
            return false;
        }
        return true;
    }
}

