/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.world.biome.normal;

import azmalent.terraincognita.common.ModTweaks;
import azmalent.terraincognita.common.world.ModDefaultFeatures;
import azmalent.terraincognita.common.world.biome.NormalBiomeEntry;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;

public class TundraBiome
extends NormalBiomeEntry {
    public TundraBiome(String id, Supplier<Integer> spawnWeight) {
        super(id, spawnWeight);
    }

    @Override
    protected Biome.Category getCategory() {
        return Biome.Category.ICY;
    }

    @Override
    protected Biome.Climate getClimate() {
        return new Biome.Climate(Biome.RainType.RAIN, 0.2f, Biome.TemperatureModifier.NONE, 0.5f);
    }

    @Override
    protected float getDepth() {
        return 0.125f;
    }

    @Override
    protected float getScale() {
        return 0.1f;
    }

    @Override
    protected BiomeAmbience getAmbience() {
        return new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(TundraBiome.getSkyColorWithTemperatureModifier(0.2f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_();
    }

    @Override
    protected ConfiguredSurfaceBuilder<?> getSurfaceBuilder() {
        return ConfiguredSurfaceBuilders.field_244178_j;
    }

    @Override
    protected MobSpawnInfo.Builder initSpawns() {
        MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder().func_242572_a(0.07f);
        DefaultBiomeFeatures.func_243741_e((MobSpawnInfo.Builder)spawns);
        ModTweaks.addExtraTundraSpawns(spawns);
        return spawns;
    }

    @Override
    protected BiomeManager.BiomeType getBiomeType() {
        return BiomeManager.BiomeType.ICY;
    }

    @Override
    protected List<BiomeDictionary.Type> getBiomeDictionaryTypes() {
        return Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WASTELAND});
    }

    @Override
    public void initFeatures(BiomeGenerationSettingsBuilder builder) {
        this.initDefaultFeatures((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)builder);
        builder.func_242516_a(StructureFeatures.field_244158_x).func_242516_a(StructureFeatures.field_244135_a).func_242516_a(StructureFeatures.field_244159_y);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243694_H((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243707_U((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243709_W((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)builder);
        ModDefaultFeatures.withExtraTundraFeatures(builder);
    }

    @Override
    public boolean hasCustomGrassModifier() {
        return true;
    }

    @Override
    public int getCustomGrassColor(double x, double z) {
        double d0 = Biome.field_180281_af.func_215464_a(x * 0.0225, z * 0.0225, false);
        return d0 < -0.1 ? 11379288 : 8434839;
    }
}

