/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.world.biome;

import azmalent.cuneiform.lib.util.BiomeUtil;
import azmalent.terraincognita.common.world.biome.BiomeEntry;
import azmalent.terraincognita.common.world.biome.SubBiomeEntry;
import azmalent.terraincognita.util.NoiseWeightedList;
import com.mojang.datafixers.util.Function3;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraftforge.common.BiomeManager;

public abstract class NormalBiomeEntry
extends BiomeEntry {
    public final NoiseWeightedList<SubBiomeEntry> subBiomes = new NoiseWeightedList();

    public NormalBiomeEntry(String id, Supplier<Integer> spawnWeight) {
        super(id, spawnWeight);
    }

    @Override
    public void register() {
        super.register();
        if (this.spawnWeight > 0) {
            RegistryKey key = BiomeUtil.getBiomeKey((ResourceLocation)this.id);
            BiomeManager.addBiome((BiomeManager.BiomeType)this.getBiomeType(), (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(key, this.spawnWeight));
        }
    }

    public SubBiomeEntry createSubBiome(String id, Function3<String, NormalBiomeEntry, Integer, SubBiomeEntry> constructor) {
        return this.createSubBiome(id, constructor, 1);
    }

    public SubBiomeEntry createSubBiome(String id, Function3<String, NormalBiomeEntry, Integer, SubBiomeEntry> constructor, int weight) {
        return (SubBiomeEntry)constructor.apply((Object)id, (Object)this, (Object)weight);
    }

    public final SubBiomeEntry getRandomSubBiome(INoiseRandom random) {
        return this.subBiomes.getRandomItem(random);
    }
}

