/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.registry;

import azmalent.cuneiform.lib.registry.BlockEntry;
import azmalent.terraincognita.common.block.trees.AppleTree;
import azmalent.terraincognita.common.block.trees.HazelTree;
import azmalent.terraincognita.common.block.woodtypes.AppleWoodType;
import azmalent.terraincognita.common.block.woodtypes.HazelWoodType;
import azmalent.terraincognita.common.block.woodtypes.ModWoodType;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.material.MaterialColor;

public class ModWoodTypes {
    public static final AppleWoodType APPLE = new AppleWoodType("apple", new AppleTree(), MaterialColor.field_151663_o, MaterialColor.field_193562_N);
    public static final HazelWoodType HAZEL = new HazelWoodType("hazel", new HazelTree(), MaterialColor.field_151663_o, MaterialColor.field_151650_B);
    public static List<ModWoodType> VALUES;
    public static Map<String, ModWoodType> VALUES_BY_NAME;

    public static void init() {
        VALUES = Lists.newArrayList((Object[])new ModWoodType[]{APPLE, HAZEL});
        VALUES_BY_NAME = VALUES.stream().collect(Collectors.toMap(type -> type.name, type -> type));
    }

    public static ModWoodType byName(String name) {
        return VALUES_BY_NAME.get(name);
    }

    private static Supplier<Block>[] getWoodBlockSuppliers(BiConsumer<List<Supplier<Block>>, ModWoodType> func) {
        ArrayList suppliers = Lists.newArrayList();
        VALUES.forEach(woodType -> func.accept(suppliers, (ModWoodType)woodType));
        return suppliers.toArray(new Supplier[0]);
    }

    public static Supplier<Block>[] getChests() {
        return ModWoodTypes.getWoodBlockSuppliers((list, wood) -> list.add(() -> ((BlockEntry)wood.CHEST).getBlock()));
    }

    public static Supplier<Block>[] getTrappedChests() {
        return ModWoodTypes.getWoodBlockSuppliers((list, wood) -> list.add(() -> ((BlockEntry)wood.TRAPPED_CHEST).getBlock()));
    }

    public static Supplier<Block>[] getSigns() {
        return ModWoodTypes.getWoodBlockSuppliers((list, wood) -> {
            list.add(() -> ((BlockEntry)wood.SIGN).getBlock());
            list.add(() -> ((BlockEntry)wood.WALL_SIGN).getBlock());
        });
    }
}

