/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.registry;

import azmalent.cuneiform.lib.registry.BlockEntry;
import azmalent.cuneiform.lib.registry.BlockRegistryHelper;
import azmalent.cuneiform.lib.util.DataUtil;
import azmalent.terraincognita.common.block.BasketBlock;
import azmalent.terraincognita.common.block.CaltropsBlock;
import azmalent.terraincognita.common.block.PeatBlock;
import azmalent.terraincognita.common.block.PeatFarmlandBlock;
import azmalent.terraincognita.common.block.PottablePlantEntry;
import azmalent.terraincognita.common.block.WickerLanternBlock;
import azmalent.terraincognita.common.block.WickerMatBlock;
import azmalent.terraincognita.common.block.plants.AlpineFlowerBlock;
import azmalent.terraincognita.common.block.plants.CactusFlowerBlock;
import azmalent.terraincognita.common.block.plants.CaribouMossBlock;
import azmalent.terraincognita.common.block.plants.CaribouMossWallBlock;
import azmalent.terraincognita.common.block.plants.HangingMossBlock;
import azmalent.terraincognita.common.block.plants.ModFlowerBlock;
import azmalent.terraincognita.common.block.plants.ReedsBlock;
import azmalent.terraincognita.common.block.plants.RootsBlock;
import azmalent.terraincognita.common.block.plants.SaxifrageBlock;
import azmalent.terraincognita.common.block.plants.SmallCactusBlock;
import azmalent.terraincognita.common.block.plants.SmallLilypadBlock;
import azmalent.terraincognita.common.block.plants.SmoothCactusBlock;
import azmalent.terraincognita.common.block.plants.SourBerryBushBlock;
import azmalent.terraincognita.common.block.plants.SourBerrySproutBlock;
import azmalent.terraincognita.common.block.plants.SweetPeasBlock;
import azmalent.terraincognita.common.block.plants.WaterloggableTallFlowerBlock;
import azmalent.terraincognita.common.block.trees.AppleBlock;
import azmalent.terraincognita.common.block.trees.HazelnutBlock;
import azmalent.terraincognita.common.block.woodtypes.ModWoodType;
import azmalent.terraincognita.common.item.block.BasketItem;
import azmalent.terraincognita.common.item.block.CaltropsItem;
import azmalent.terraincognita.common.item.block.DandelionPuffItem;
import azmalent.terraincognita.common.item.block.SmallLilypadItem;
import azmalent.terraincognita.common.registry.ModItems;
import azmalent.terraincognita.common.registry.ModWoodTypes;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.GravelBlock;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.LilyPadItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.TallBlockItem;
import net.minecraft.item.WallOrFloorItem;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"terraincognita");
    public static final BlockRegistryHelper HELPER = new BlockRegistryHelper(BLOCKS, ModItems.ITEMS, ItemGroup.field_78031_c);
    public static final List<PottablePlantEntry> FLOWERS;
    public static final PottablePlantEntry DANDELION_PUFF;
    public static final PottablePlantEntry CHICORY;
    public static final PottablePlantEntry YARROW;
    public static final PottablePlantEntry DAFFODIL;
    public static final PottablePlantEntry YELLOW_PRIMROSE;
    public static final PottablePlantEntry PINK_PRIMROSE;
    public static final PottablePlantEntry PURPLE_PRIMROSE;
    public static final PottablePlantEntry FOXGLOVE;
    public static final PottablePlantEntry WILD_GARLIC;
    public static final PottablePlantEntry MARIGOLD;
    public static final PottablePlantEntry BLUE_LUPINE;
    public static final PottablePlantEntry SNAPDRAGON;
    public static final PottablePlantEntry GLADIOLUS;
    public static final PottablePlantEntry GERANIUM;
    public static final PottablePlantEntry SAXIFRAGE;
    public static final PottablePlantEntry ALPINE_PINK;
    public static final PottablePlantEntry GENTIAN;
    public static final PottablePlantEntry EDELWEISS;
    public static final PottablePlantEntry FORGET_ME_NOT;
    public static final PottablePlantEntry GLOBEFLOWER;
    public static final PottablePlantEntry BLUE_IRIS;
    public static final PottablePlantEntry PURPLE_IRIS;
    public static final PottablePlantEntry BLACK_IRIS;
    public static final PottablePlantEntry DWARF_FIREWEED;
    public static final PottablePlantEntry ARCTIC_POPPY;
    public static final PottablePlantEntry WHITE_DRYAD;
    public static final PottablePlantEntry WATER_FLAG;
    public static final PottablePlantEntry FIREWEED;
    public static final PottablePlantEntry WHITE_RHODODENDRON;
    public static final PottablePlantEntry OLEANDER;
    public static final PottablePlantEntry SAGE;
    public static final List<BlockEntry> SWEET_PEAS;
    public static final BlockEntry WHITE_SWEET_PEAS;
    public static final BlockEntry PINK_SWEET_PEAS;
    public static final BlockEntry RED_SWEET_PEAS;
    public static final BlockEntry MAGENTA_SWEET_PEAS;
    public static final BlockEntry PURPLE_SWEET_PEAS;
    public static final BlockEntry BLUE_SWEET_PEAS;
    public static final BlockEntry LIGHT_BLUE_SWEET_PEAS;
    public static final List<BlockEntry> LOTUSES;
    public static final BlockEntry PINK_LOTUS;
    public static final BlockEntry WHITE_LOTUS;
    public static final BlockEntry YELLOW_LOTUS;
    public static final BlockEntry SMALL_LILY_PAD;
    public static final BlockEntry APPLE;
    public static final BlockEntry HAZELNUT;
    public static final PottablePlantEntry CATTAIL;
    public static final PottablePlantEntry REEDS;
    public static final BlockEntry SOUR_BERRY_SPROUTS;
    public static final BlockEntry SOUR_BERRY_BUSH;
    public static final BlockEntry CARIBOU_MOSS_WALL;
    public static final PottablePlantEntry CARIBOU_MOSS;
    public static final BlockEntry ROOTS;
    public static final BlockEntry HANGING_MOSS;
    public static final PottablePlantEntry SMALL_CACTUS;
    public static final BlockEntry SMOOTH_CACTUS;
    public static final PottablePlantEntry CACTUS_FLOWER;
    public static final BlockEntry PEAT;
    public static final BlockEntry TILLED_PEAT;
    public static final BlockEntry FLOWERING_GRASS;
    public static final BlockEntry MOSSY_GRAVEL;
    public static final BlockEntry CALTROPS;
    public static final BlockEntry BASKET;
    public static final BlockEntry WICKER_MAT;
    public static final BlockEntry WICKER_LANTERN;

    public static PottablePlantEntry createPlant(String id, Supplier<Block> constructor) {
        return ModBlocks.createPlant(id, constructor, null);
    }

    public static PottablePlantEntry createPlant(String id, Supplier<Block> constructor, Function<Block, BlockItem> blockItemConstructor) {
        BlockEntry.Builder builder = HELPER.newBuilder(id, constructor).withBlockItem(blockItemConstructor).cutoutRender();
        return new PottablePlantEntry(id, builder.build());
    }

    public static PottablePlantEntry createTallPlant(String id) {
        return ModBlocks.createPlant(id, () -> new TallFlowerBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196802_gf)), block -> new TallBlockItem(block, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)));
    }

    public static PottablePlantEntry createTallWaterloggablePlant(String id) {
        return ModBlocks.createPlant(id, WaterloggableTallFlowerBlock::new, block -> new TallBlockItem(block, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)));
    }

    private static BlockEntry createLotus(String color) {
        return HELPER.newBuilder(color + "_lotus", LilyPadBlock::new, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196651_dG)).withBlockItem(LilyPadItem::new, ItemGroup.field_78031_c).cutoutRender().build();
    }

    private static BlockEntry createSweetPeas(String color) {
        return HELPER.newBuilder(color + "_sweet_peas", SweetPeasBlock::new).cutoutRender().build();
    }

    public static void initToolInteractions() {
        AxeItem.field_203176_a = Maps.newHashMap((Map)AxeItem.field_203176_a);
        for (ModWoodType woodType : ModWoodTypes.VALUES) {
            AxeItem.field_203176_a.put(woodType.LOG.getBlock(), woodType.STRIPPED_LOG.getBlock());
            AxeItem.field_203176_a.put(woodType.WOOD.getBlock(), woodType.STRIPPED_WOOD.getBlock());
        }
        HoeItem.field_195973_b = Maps.newHashMap((Map)HoeItem.field_195973_b);
        HoeItem.field_195973_b.put(PEAT.getBlock(), TILLED_PEAT.getBlock().func_176223_P());
        HoeItem.field_195973_b.put(FLOWERING_GRASS.getBlock(), Blocks.field_150458_ak.func_176223_P());
        ShovelItem.field_195955_e = Maps.newHashMap((Map)ShovelItem.field_195955_e);
        ShovelItem.field_195955_e.put(FLOWERING_GRASS.getBlock(), Blocks.field_185774_da.func_176223_P());
    }

    public static void initFlammability() {
        for (PottablePlantEntry flower : FLOWERS) {
            DataUtil.registerFlammable((Block)flower.getBlock(), (int)60, (int)100);
        }
        for (BlockEntry sweetPea : SWEET_PEAS) {
            DataUtil.registerFlammable((Block)sweetPea.getBlock(), (int)15, (int)100);
        }
        for (ModWoodType woodType : ModWoodTypes.VALUES) {
            woodType.initFlammability();
        }
        DataUtil.registerFlammable((Block)WICKER_MAT.getBlock(), (int)60, (int)20);
    }

    static {
        DANDELION_PUFF = ModBlocks.createPlant("dandelion_puff", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.SATURATION), DandelionPuffItem::new);
        CHICORY = ModBlocks.createPlant("chicory", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.SPEED));
        YARROW = ModBlocks.createPlant("yarrow", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.NIGHT_VISION));
        DAFFODIL = ModBlocks.createPlant("daffodil", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.BLINDNESS));
        YELLOW_PRIMROSE = ModBlocks.createPlant("yellow_primrose", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.STRENGTH));
        PINK_PRIMROSE = ModBlocks.createPlant("pink_primrose", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.STRENGTH));
        PURPLE_PRIMROSE = ModBlocks.createPlant("purple_primrose", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.STRENGTH));
        FOXGLOVE = ModBlocks.createPlant("foxglove", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.POISON));
        WILD_GARLIC = ModBlocks.createPlant("wild_garlic", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.SATURATION));
        MARIGOLD = ModBlocks.createPlant("marigold", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.REGENERATION));
        BLUE_LUPINE = ModBlocks.createPlant("blue_lupine", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.HUNGER));
        SNAPDRAGON = ModBlocks.createPlant("snapdragon", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.HASTE));
        GLADIOLUS = ModBlocks.createPlant("gladiolus", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.STRENGTH));
        GERANIUM = ModBlocks.createPlant("geranium", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.RESISTANCE));
        SAXIFRAGE = ModBlocks.createPlant("saxifrage", SaxifrageBlock::new);
        ALPINE_PINK = ModBlocks.createPlant("alpine_pink", () -> new AlpineFlowerBlock(ModFlowerBlock.StewEffect.SLOWNESS));
        GENTIAN = ModBlocks.createPlant("gentian", () -> new AlpineFlowerBlock(ModFlowerBlock.StewEffect.WEAKNESS));
        EDELWEISS = ModBlocks.createPlant("edelweiss", () -> new AlpineFlowerBlock(ModFlowerBlock.StewEffect.HASTE));
        FORGET_ME_NOT = ModBlocks.createPlant("forget_me_not", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.SLOWNESS));
        GLOBEFLOWER = ModBlocks.createPlant("globeflower", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.RESISTANCE));
        BLUE_IRIS = ModBlocks.createPlant("blue_iris", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.INVISIBILITY));
        PURPLE_IRIS = ModBlocks.createPlant("purple_iris", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.INVISIBILITY));
        BLACK_IRIS = ModBlocks.createPlant("black_iris", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.INVISIBILITY));
        DWARF_FIREWEED = ModBlocks.createPlant("dwarf_fireweed", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.SPEED));
        ARCTIC_POPPY = ModBlocks.createPlant("arctic_poppy", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.NIGHT_VISION));
        WHITE_DRYAD = ModBlocks.createPlant("white_dryad", () -> new ModFlowerBlock(ModFlowerBlock.StewEffect.SLOWNESS));
        WATER_FLAG = ModBlocks.createTallWaterloggablePlant("water_flag");
        FIREWEED = ModBlocks.createTallPlant("tall_fireweed");
        WHITE_RHODODENDRON = ModBlocks.createTallPlant("white_rhododendron");
        OLEANDER = ModBlocks.createTallPlant("oleander");
        SAGE = ModBlocks.createTallPlant("sage");
        WHITE_SWEET_PEAS = ModBlocks.createSweetPeas("white");
        PINK_SWEET_PEAS = ModBlocks.createSweetPeas("pink");
        RED_SWEET_PEAS = ModBlocks.createSweetPeas("red");
        MAGENTA_SWEET_PEAS = ModBlocks.createSweetPeas("magenta");
        PURPLE_SWEET_PEAS = ModBlocks.createSweetPeas("purple");
        BLUE_SWEET_PEAS = ModBlocks.createSweetPeas("blue");
        LIGHT_BLUE_SWEET_PEAS = ModBlocks.createSweetPeas("light_blue");
        PINK_LOTUS = ModBlocks.createLotus("pink");
        WHITE_LOTUS = ModBlocks.createLotus("white");
        YELLOW_LOTUS = ModBlocks.createLotus("yellow");
        SMALL_LILY_PAD = HELPER.newBuilder("small_lilypad", SmallLilypadBlock::new).withBlockItem(SmallLilypadItem::new).cutoutRender().build();
        APPLE = HELPER.newBuilder("apple", AppleBlock::new).withoutItemForm().cutoutRender().build();
        HAZELNUT = HELPER.newBuilder("hazelnut", HazelnutBlock::new).withoutItemForm().cutoutRender().build();
        CATTAIL = ModBlocks.createTallWaterloggablePlant("cattail");
        REEDS = ModBlocks.createPlant("reeds", ReedsBlock::new);
        SOUR_BERRY_SPROUTS = HELPER.newBuilder("sour_berry_sprouts", SourBerrySproutBlock::new).withBlockItem(LilyPadItem::new, ItemGroup.field_78026_f).cutoutRender().build();
        SOUR_BERRY_BUSH = HELPER.newBuilder("sour_berry_bush", SourBerryBushBlock::new).withoutItemForm().cutoutRender().build();
        CARIBOU_MOSS_WALL = HELPER.newBuilder("caribou_moss_wall", CaribouMossWallBlock::new).withoutItemForm().cutoutRender().build();
        CARIBOU_MOSS = ModBlocks.createPlant("caribou_moss", CaribouMossBlock::new, block -> new WallOrFloorItem(block, CARIBOU_MOSS_WALL.getBlock(), new Item.Properties().func_200916_a(ItemGroup.field_78031_c)));
        ROOTS = HELPER.newBuilder("roots", RootsBlock::new).cutoutRender().build();
        HANGING_MOSS = HELPER.newBuilder("hanging_moss", HangingMossBlock::new).cutoutRender().build();
        SMALL_CACTUS = ModBlocks.createPlant("small_cactus", SmallCactusBlock::new);
        SMOOTH_CACTUS = HELPER.newBuilder("smooth_cactus", SmoothCactusBlock::new).cutoutRender().build();
        CACTUS_FLOWER = ModBlocks.createPlant("cactus_flower", CactusFlowerBlock::new);
        PEAT = HELPER.newBuilder("peat", PeatBlock::new).withItemGroup(ItemGroup.field_78030_b).build();
        TILLED_PEAT = HELPER.newBuilder("tilled_peat", PeatFarmlandBlock::new).build();
        FLOWERING_GRASS = HELPER.newBuilder("flowering_grass", GrassBlock::new, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196658_i).harvestTool(ToolType.SHOVEL)).cutoutMippedRender().build();
        MOSSY_GRAVEL = HELPER.newBuilder("mossy_gravel", GravelBlock::new, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150351_n).harvestTool(ToolType.SHOVEL)).build();
        CALTROPS = HELPER.newBuilder("caltrops", CaltropsBlock::new).withBlockItem(CaltropsItem::new).cutoutRender().build();
        BASKET = HELPER.newBuilder("basket", BasketBlock::new).withBlockItem(BasketItem::new).build();
        WICKER_MAT = HELPER.newBuilder("wicker_mat", WickerMatBlock::new).build();
        WICKER_LANTERN = HELPER.newBuilder("wicker_lantern", WickerLanternBlock::new).cutoutRender().build();
        ModWoodTypes.init();
        FLOWERS = Lists.newArrayList((Object[])new PottablePlantEntry[]{DANDELION_PUFF, CHICORY, YARROW, DAFFODIL, YELLOW_PRIMROSE, PINK_PRIMROSE, PURPLE_PRIMROSE, FOXGLOVE, WILD_GARLIC, MARIGOLD, BLUE_LUPINE, GLADIOLUS, SNAPDRAGON, GERANIUM, EDELWEISS, ALPINE_PINK, SAXIFRAGE, GENTIAN, FORGET_ME_NOT, BLUE_IRIS, PURPLE_IRIS, BLACK_IRIS, DWARF_FIREWEED, ARCTIC_POPPY, WHITE_DRYAD, WATER_FLAG, FIREWEED, WHITE_RHODODENDRON, OLEANDER, SAGE, CACTUS_FLOWER});
        LOTUSES = Lists.newArrayList((Object[])new BlockEntry[]{WHITE_LOTUS, PINK_LOTUS, YELLOW_LOTUS});
        SWEET_PEAS = Lists.newArrayList((Object[])new BlockEntry[]{WHITE_SWEET_PEAS, PINK_SWEET_PEAS, RED_SWEET_PEAS, MAGENTA_SWEET_PEAS, PURPLE_SWEET_PEAS, BLUE_SWEET_PEAS, LIGHT_BLUE_SWEET_PEAS});
    }
}

