/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.item;

import azmalent.terraincognita.common.entity.IBottleableEntity;
import azmalent.terraincognita.common.item.dispenser.BottledEntityDispenserBehavior;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BottledEntityItem<T extends LivingEntity>
extends Item {
    private static final BottledEntityDispenserBehavior DISPENSER_BEHAVIOR = new BottledEntityDispenserBehavior();
    private static final String ENTITY_KEY = "bottled_entity";
    public final Supplier<EntityType<T>> type;
    private final BiConsumer<CompoundNBT, List<ITextComponent>> tooltipHandler;

    public BottledEntityItem(Supplier<EntityType<T>> type, BiConsumer<CompoundNBT, List<ITextComponent>> tooltipHandler) {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(1));
        this.type = type;
        this.tooltipHandler = tooltipHandler;
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public static <T extends LivingEntity> void setBottledEntity(ItemStack stack, T entity) {
        CompoundNBT nbt = new CompoundNBT();
        entity.func_213281_b(nbt);
        stack.func_196082_o().func_218657_a(ENTITY_KEY, (INBT)nbt);
    }

    public static CompoundNBT getBottledEntity(ItemStack bottle) {
        if (!bottle.func_196082_o().func_150297_b(ENTITY_KEY, 10)) {
            return new CompoundNBT();
        }
        return bottle.func_196082_o().func_74775_l(ENTITY_KEY);
    }

    public static void initReleasedEntity(LivingEntity entity, ItemStack bottle) {
        CompoundNBT nbt = BottledEntityItem.getBottledEntity(bottle);
        entity.func_70037_a(nbt);
        if (bottle.func_82837_s()) {
            entity.func_200203_b(bottle.func_200301_q());
        }
        ((IBottleableEntity)entity).onUnbottled();
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        PlayerEntity player = context.func_195999_j();
        ItemStack bottle = context.func_195996_i();
        BlockPos pos1 = pos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        if (!world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos).func_197766_b()) {
            pos1 = pos.func_177972_a(direction);
        }
        world.func_184133_a(player, pos1, SoundEvents.field_191241_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
        LivingEntity entity = (LivingEntity)this.type.get().func_220331_a((ServerWorld)world, bottle, context.func_195999_j(), pos, SpawnReason.BUCKET, true, !Objects.equals(pos, pos1) && direction == Direction.UP);
        if (entity != null) {
            BottledEntityItem.initReleasedEntity(entity, bottle);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            player.func_184611_a(context.func_221531_n(), new ItemStack((IItemProvider)Items.field_151069_bo));
            player.func_184609_a(context.func_221531_n());
        }
        return ActionResultType.CONSUME;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.tooltipHandler.accept(BottledEntityItem.getBottledEntity(stack), tooltip);
    }
}

