/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.integration;

import azmalent.cuneiform.lib.compat.IModIntegration;
import azmalent.cuneiform.lib.compat.ModProxyImpl;
import azmalent.terraincognita.TerraIncognita;
import azmalent.terraincognita.common.registry.ModItems;
import java.util.Collections;
import javax.annotation.Nonnull;
import knightminer.simplytea.core.Registration;
import knightminer.simplytea.item.TeaCupItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;

@ModProxyImpl(value="simplytea")
public class SimplyTeaIntegration
implements IModIntegration {
    private static RegistryObject<Item> FIREWEED_TEA_BAG;
    private static RegistryObject<Item> FIREWEED_TEA_CUP;
    private static ModTeaStats FIREWEED_TEA_STATS;

    public void register(IEventBus bus) {
        TerraIncognita.LOGGER.info("Integrating with Simply Tea...");
        ItemGroup group = Registration.group;
        FIREWEED_TEA_BAG = ModItems.ITEMS.register("fireweed_teabag", () -> new Item(new Item.Properties().func_200916_a(group)));
        FIREWEED_TEA_CUP = ModItems.ITEMS.register("fireweed_tea_cup", () -> new ModTeaItem(FIREWEED_TEA_STATS));
    }

    static {
        FIREWEED_TEA_STATS = new ModTeaStats(2, 0.5f, Registration.restful, 400, 0);
    }

    private static class ModTeaItem
    extends TeaCupItem {
        public ModTeaItem(ModTeaStats stats) {
            super(new Item.Properties().func_200916_a(Registration.group).func_200917_a(1).func_200918_c(2).setNoRepair().func_221540_a((Food)stats));
        }

        @Nonnull
        public ItemStack func_77654_b(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull LivingEntity living) {
            if (this.func_219971_r()) {
                EffectInstance effectInstance;
                ItemStack result = stack.getContainerItem();
                boolean hasHoney = ModTeaItem.hasHoney((ItemStack)stack, (String)"with_honey");
                living.curePotionEffects(stack);
                living.func_213357_a(worldIn, stack);
                Food food = this.func_219967_s();
                if (food instanceof ModTeaStats && (effectInstance = ((ModTeaStats)food).getEffect(hasHoney)) != null) {
                    living.func_195064_c(effectInstance);
                }
                return result;
            }
            return stack;
        }
    }

    private static class ModTeaStats
    extends Food {
        private Effect effect;
        private int duration;
        private int amplifier;

        public ModTeaStats(int hunger, float saturation, Effect effect, int duration, int amplifier) {
            super(hunger, saturation, false, true, true, Collections.emptyList());
            this.effect = effect;
            this.duration = duration;
            this.amplifier = amplifier;
        }

        public EffectInstance getEffect(boolean hasHoney) {
            return new EffectInstance(this.effect, this.duration, this.amplifier + (hasHoney ? 1 : 0));
        }
    }
}

