/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.event;

import azmalent.terraincognita.TerraIncognita;
import azmalent.terraincognita.common.block.PottablePlantEntry;
import azmalent.terraincognita.common.registry.ModBlocks;
import azmalent.terraincognita.common.registry.ModItems;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class IdRemappingHandler {
    private static Map<String, Block> BLOCK_ID_CHANGES = Maps.newHashMap();
    private static Map<String, Item> ITEM_ID_CHANGES = Maps.newHashMap();

    private static void remap(String oldId, PottablePlantEntry plant) {
        BLOCK_ID_CHANGES.put(oldId, plant.getBlock());
        BLOCK_ID_CHANGES.put("potted_" + oldId, plant.getPotted());
        ITEM_ID_CHANGES.put(oldId, plant.func_199767_j());
    }

    private static <T extends Item> void remap(String oldId, RegistryObject<T> item) {
        ITEM_ID_CHANGES.put(oldId, (Item)item.get());
    }

    public static void onMissingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        event.getAllMappings().stream().filter(m -> m.key.func_110624_b().equals("terraincognita")).forEach(mapping -> {
            Block block = BLOCK_ID_CHANGES.get(mapping.key.func_110623_a());
            if (block != null) {
                TerraIncognita.LOGGER.info(String.format("Remapping block ID: %s -> %s", mapping.key, block.getRegistryName()));
                mapping.remap((IForgeRegistryEntry)block);
            }
        });
    }

    public static void onMissingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        event.getAllMappings().stream().filter(m -> m.key.func_110624_b().equals("terraincognita")).forEach(mapping -> {
            Item item = ITEM_ID_CHANGES.get(mapping.key.func_110623_a());
            if (item != null) {
                TerraIncognita.LOGGER.info(String.format("Remapping item ID: %s -> %s", mapping.key, item.getRegistryName()));
                mapping.remap((IForgeRegistryEntry)item);
            }
        });
    }

    static {
        IdRemappingHandler.remap("yellow_snapdragon", ModBlocks.SNAPDRAGON);
        IdRemappingHandler.remap("red_snapdragon", ModBlocks.GLADIOLUS);
        IdRemappingHandler.remap("magenta_snapdragon", ModBlocks.GERANIUM);
        IdRemappingHandler.remap("blue_lupin", ModBlocks.BLUE_LUPINE);
        IdRemappingHandler.remap("rockfoil", ModBlocks.SAXIFRAGE);
        IdRemappingHandler.remap("fireweed", ModBlocks.DWARF_FIREWEED);
        IdRemappingHandler.remap("flower_band", ModItems.WREATH);
        IdRemappingHandler.remap("honey_hazelnut", ModItems.CANDIED_HAZELNUT);
    }
}

