/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.capability;

import azmalent.terraincognita.common.inventory.BasketStackHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BasketCapabilityProvider
implements ICapabilitySerializable<INBT> {
    private static final Direction NO_SPECIFIC_SIDE = null;
    private BasketStackHandler stackHandler;
    private final LazyOptional<IItemHandler> lazyInitialisionSupplier = LazyOptional.of(this::getCachedInventory);

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.lazyInitialisionSupplier);
    }

    public INBT serializeNBT() {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.getCachedInventory(), NO_SPECIFIC_SIDE);
    }

    public void deserializeNBT(INBT nbt) {
        CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.getCachedInventory(), NO_SPECIFIC_SIDE, nbt);
    }

    @Nonnull
    private BasketStackHandler getCachedInventory() {
        if (this.stackHandler == null) {
            this.stackHandler = new BasketStackHandler();
        }
        return this.stackHandler;
    }
}

