/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.client.renderer.tile;

import azmalent.terraincognita.common.block.signs.AbstractModSignBlock;
import azmalent.terraincognita.common.block.signs.ModStandingSignBlock;
import azmalent.terraincognita.common.block.signs.ModWallSignBlock;
import azmalent.terraincognita.common.tile.ModSignTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.WoodType;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModSignRenderer
extends TileEntityRenderer<ModSignTileEntity> {
    private final SignModel model = new SignModel();

    public ModSignRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(ModSignTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, @Nonnull IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockstate = tileEntityIn.func_195044_w();
        matrixStackIn.func_227860_a_();
        float f = 0.6666667f;
        if (blockstate.func_177230_c() instanceof ModStandingSignBlock) {
            matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
            float f1 = -((float)((Integer)blockstate.func_177229_b((Property)ModStandingSignBlock.ROTATION) * 360) / 16.0f);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f1));
            this.model.signStick.field_78806_j = true;
        } else {
            matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
            float f4 = -((Direction)blockstate.func_177229_b((Property)ModWallSignBlock.FACING)).func_185119_l();
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f4));
            matrixStackIn.func_227861_a_(0.0, -0.3125, -0.4375);
            this.model.signStick.field_78806_j = false;
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(0.6666667f, -0.6666667f, -0.6666667f);
        RenderMaterial rendermaterial = ModSignRenderer.getMaterial(blockstate.func_177230_c());
        IVertexBuilder ivertexbuilder = rendermaterial.func_229311_a_(bufferIn, arg_0 -> ((SignModel)this.model).func_228282_a_(arg_0));
        this.model.signBoard.func_228308_a_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        this.model.signStick.func_228308_a_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227865_b_();
        FontRenderer fontrenderer = this.field_228858_b_.func_147548_a();
        float scale = 0.010416667f;
        matrixStackIn.func_227861_a_(0.0, 0.3333333432674408, 0.046666666865348816);
        matrixStackIn.func_227862_a_(scale, -scale, scale);
        int i = tileEntityIn.getTextColor().func_218388_g();
        double multiplier = 0.4;
        int j = (int)((double)NativeImage.func_227791_b_((int)i) * multiplier);
        int k = (int)((double)NativeImage.func_227793_c_((int)i) * multiplier);
        int l = (int)((double)NativeImage.func_227795_d_((int)i) * multiplier);
        int i1 = NativeImage.func_227787_a_((int)0, (int)l, (int)k, (int)j);
        for (int k1 = 0; k1 < 4; ++k1) {
            IReorderingProcessor ireorderingprocessor = tileEntityIn.func_242686_a(k1, p_243502_1_ -> {
                List list = fontrenderer.func_238425_b_((ITextProperties)p_243502_1_, 90);
                return list.isEmpty() ? IReorderingProcessor.field_242232_a : (IReorderingProcessor)list.get(0);
            });
            if (ireorderingprocessor == null) continue;
            float f3 = -fontrenderer.func_243245_a(ireorderingprocessor) / 2;
            fontrenderer.func_238416_a_(ireorderingprocessor, f3, (float)(k1 * 10 - 20), i1, false, matrixStackIn.func_227866_c_().func_227870_a_(), bufferIn, false, 0, tileEntityIn.isGlowing() ? 0xF000F0 : combinedLightIn);
        }
        matrixStackIn.func_227865_b_();
    }

    public static RenderMaterial getMaterial(Block blockIn) {
        if (blockIn instanceof AbstractModSignBlock) {
            ResourceLocation texture = ((AbstractModSignBlock)blockIn).getTexture();
            return new RenderMaterial(Atlases.field_228746_e_, texture);
        }
        return Atlases.func_228773_a_((WoodType)WoodType.field_227038_a_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class SignModel
    extends Model {
        public final ModelRenderer signBoard = new ModelRenderer(64, 32, 0, 0);
        public final ModelRenderer signStick;

        public SignModel() {
            super(RenderType::func_228640_c_);
            this.signBoard.func_228301_a_(-12.0f, -14.0f, -1.0f, 24.0f, 12.0f, 2.0f, 0.0f);
            this.signStick = new ModelRenderer(64, 32, 0, 14);
            this.signStick.func_228301_a_(-1.0f, -2.0f, -1.0f, 2.0f, 14.0f, 2.0f, 0.0f);
        }

        public void func_225598_a_(@Nonnull MatrixStack p_225598_1_, @Nonnull IVertexBuilder p_225598_2_, int p_225598_3_, int p_225598_4_, float p_225598_5_, float p_225598_6_, float p_225598_7_, float p_225598_8_) {
            this.signBoard.func_228309_a_(p_225598_1_, p_225598_2_, p_225598_3_, p_225598_4_, p_225598_5_, p_225598_6_, p_225598_7_, p_225598_8_);
            this.signStick.func_228309_a_(p_225598_1_, p_225598_2_, p_225598_3_, p_225598_4_, p_225598_5_, p_225598_6_, p_225598_7_, p_225598_8_);
        }
    }
}

