/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.ConfigHandler;
import net.mehvahdjukaar.supplementaries.world.data.GlobeData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class GlobeTextureManager
implements AutoCloseable {
    public static GlobeTextureManager INSTANCE = null;
    private final TextureManager textureManager;
    private final Map<String, TextureInstance> globeTextures = Maps.newHashMap();

    public static void init(TextureManager textureManager) {
        INSTANCE = new GlobeTextureManager(textureManager);
    }

    public GlobeTextureManager(TextureManager textureManager) {
        this.textureManager = textureManager;
    }

    public void update() {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            this.getTextureInstance((World)world).updateTexture((World)world);
        }
    }

    public RenderType getRenderType(World world) {
        return this.getTextureInstance(world).renderType;
    }

    private TextureInstance getTextureInstance(World world) {
        String id = world.func_234923_W_().func_240901_a_().func_110623_a();
        TextureInstance textureInstance = this.globeTextures.get(id);
        if (textureInstance == null) {
            textureInstance = new TextureInstance(world);
            this.globeTextures.put(id, textureInstance);
        }
        return textureInstance;
    }

    @Override
    public void close() {
        for (TextureInstance textureInstance : this.globeTextures.values()) {
            textureInstance.close();
        }
        this.globeTextures.clear();
    }

    public static class GlobeColors {
        public static final HashMap<String, List<Integer>> dimensionColorMap = new HashMap();
        public static final List<Integer> defaultColorMap = new ArrayList<Integer>();

        public static List<List<String>> getDefaultConfig() {
            ArrayList<List<String>> l = new ArrayList<List<String>>();
            ArrayList<String> col = new ArrayList<String>();
            col.add("minecraft:overworld");
            for (int i = 1; i < 13; ++i) {
                col.add(Integer.toHexString(defaultColorMap.get((byte)i)));
            }
            l.add(col);
            l.add(Arrays.asList("minecraft:the_nether", "941818", "7b0000", "6a0400", "16615b", "941818", "ca4e06", "e66410", "f48522", "5a0000", "32333d", "118066", "100c1c"));
            l.add(Arrays.asList("minecraft:the_end", "061914", "000000", "2a0d2a", "000000", "d5da94", "cdc68b", "061914", "2a0d2a", "cdc68b", "000000", "eef6b4", "b286b2"));
            return l;
        }

        public static void refreshColorsFromConfig() {
            dimensionColorMap.clear();
            try {
                List<? extends List<String>> customColors = ConfigHandler.safeGetListString(ClientConfigs.CLIENT_SPEC, ClientConfigs.block.GLOBE_COLORS);
                for (List<String> list : customColors) {
                    if (list.size() < 13) continue;
                    String id = list.get(0);
                    ArrayList<Integer> col = new ArrayList<Integer>();
                    col.add(0);
                    for (int i = 1; i < 13; ++i) {
                        int hex;
                        try {
                            hex = Integer.parseInt(list.get(i).replace("0x", ""), 16);
                        }
                        catch (Exception e) {
                            Supplementaries.LOGGER.warn("failed to parse config 'globe_colors' (at dimension" + id + "). Try deleting them");
                            continue;
                        }
                        col.add(hex);
                    }
                    dimensionColorMap.put(id, col);
                }
            }
            catch (Exception e) {
                Supplementaries.LOGGER.warn("failed to parse config globe_color configs. Try deleting them");
                dimensionColorMap.put("minecraft:overworld", new ArrayList<Integer>(defaultColorMap));
            }
        }

        private static int getRGB(byte b, String dimension) {
            return dimensionColorMap.getOrDefault(dimension, defaultColorMap).get(b);
        }

        public static int getRGBA(byte b, String dimension) {
            int rgb = GlobeColors.getRGB(b, dimension);
            return 0xFF000000 | (rgb & 0xFF) << 16 | (rgb >> 8 & 0xFF) << 8 | rgb >> 16 & 0xFF;
        }

        static {
            defaultColorMap.add(0, 0);
            defaultColorMap.add(1, 2319757);
            defaultColorMap.add(2, 2445949);
            defaultColorMap.add(3, 1915245);
            defaultColorMap.add(4, 2984540);
            defaultColorMap.add(5, 3448890);
            defaultColorMap.add(6, 7250251);
            defaultColorMap.add(7, 9021501);
            defaultColorMap.add(8, 11909733);
            defaultColorMap.add(9, 13424597);
            defaultColorMap.add(10, 8631494);
            defaultColorMap.add(11, 3113890);
            defaultColorMap.add(12, 8547953);
            defaultColorMap.add(13, 9340533);
            defaultColorMap.add(14, 2984540);
            defaultColorMap.add(15, 12749127);
            defaultColorMap.add(16, 12230501);
            defaultColorMap.add(17, 12230501);
            defaultColorMap.add(18, 7770473);
        }
    }

    private class TextureInstance
    implements AutoCloseable {
        private final DynamicTexture texture;
        private final RenderType renderType;
        private final String id;

        private TextureInstance(World world) {
            this.id = world.func_234923_W_().func_240901_a_().toString();
            this.texture = new DynamicTexture(32, 16, false);
            this.updateTexture(world);
            ResourceLocation resourcelocation = GlobeTextureManager.this.textureManager.func_110578_a("globe/" + this.id.replace(":", "_"), this.texture);
            this.renderType = RenderType.func_228634_a_((ResourceLocation)resourcelocation);
        }

        private void updateTexture(World world) {
            byte[][] pixels = GlobeData.get((World)world).globePixels;
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 32; ++j) {
                    this.texture.func_195414_e().func_195700_a(j, i, -13061505);
                }
            }
            for (int y = 0; y < pixels.length; ++y) {
                for (int x = 0; x < pixels[y].length; ++x) {
                    this.texture.func_195414_e().func_195700_a(y, x, GlobeColors.getRGBA(pixels[y][x], this.id));
                }
            }
            this.texture.func_110564_a();
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }
}

