/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.IOwnerProtected;
import net.mehvahdjukaar.selene.map.CustomDecorationHolder;
import net.mehvahdjukaar.supplementaries.block.blocks.FenceMimicBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.block.util.BlockUtils;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.compat.framedblocks.FramedSignPost;
import net.mehvahdjukaar.supplementaries.datagen.types.VanillaWoodTypes;
import net.mehvahdjukaar.supplementaries.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.CompassItem;
import net.minecraft.item.DyeItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;

public class SignPostBlock
extends FenceMimicBlock {
    public SignPostBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Override
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (hit.func_216354_b().func_176740_k() == Direction.Axis.Y) {
            return ActionResultType.PASS;
        }
        if (!worldIn.field_72995_K) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof SignPostBlockTile && ((IOwnerProtected)tileentity).isAccessibleBy(player)) {
                SignPostBlockTile te = (SignPostBlockTile)tileentity;
                ItemStack itemstack = player.func_184586_b(handIn);
                Item item2 = itemstack.func_77973_b();
                if (item2 instanceof FilledMapItem) {
                    MapData data = FilledMapItem.func_195950_a((ItemStack)itemstack, (World)worldIn);
                    if (data instanceof CustomDecorationHolder) {
                        ((CustomDecorationHolder)data).toggleCustomDecoration((IWorld)worldIn, pos);
                    }
                    return ActionResultType.CONSUME;
                }
                boolean emptyhand = itemstack.func_190926_b();
                boolean isDye = item2 instanceof DyeItem && player.field_71075_bZ.field_75099_e;
                boolean isSneaking = player.func_225608_bj_() && emptyhand;
                boolean isSignPost = item2 instanceof SignPostItem;
                boolean isCompass = item2 instanceof CompassItem;
                if (isDye) {
                    if (te.textHolder.setTextColor(((DyeItem)itemstack.func_77973_b()).func_195962_g())) {
                        if (!player.func_184812_l_()) {
                            itemstack.func_190918_g(1);
                        }
                        te.func_70296_d();
                        worldIn.func_184138_a(pos, state, state, 3);
                        return ActionResultType.CONSUME;
                    }
                    return ActionResultType.FAIL;
                }
                if (isSneaking) {
                    boolean up;
                    double y = hit.func_216347_e().field_72448_b;
                    boolean bl = up = y % (double)((int)y) > 0.5;
                    if (up) {
                        te.leftUp = !te.leftUp;
                    } else {
                        te.leftDown = !te.leftDown;
                    }
                    te.func_70296_d();
                    worldIn.func_184138_a(pos, state, state, 3);
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187632_cP, SoundCategory.BLOCKS, 1.0f, 0.6f);
                    return ActionResultType.CONSUME;
                }
                if (isCompass) {
                    BlockPos pointingPos;
                    BlockPos blockPos = pointingPos = CompassItem.func_234670_d_((ItemStack)itemstack) ? this.getLodestonePos(worldIn, itemstack.func_196082_o()) : this.getWorldSpawnPos(worldIn);
                    if (pointingPos != null) {
                        boolean up;
                        double y = hit.func_216347_e().field_72448_b;
                        boolean bl = up = y % (double)((int)y) > 0.5;
                        if (up && te.up) {
                            te.pointToward(pointingPos, true);
                        } else if (!up && te.down) {
                            te.pointToward(pointingPos, false);
                        }
                        worldIn.func_184138_a(pos, state, state, 3);
                        te.func_70296_d();
                        return ActionResultType.CONSUME;
                    }
                    return ActionResultType.FAIL;
                }
                if (CompatHandler.framedblocks && te.framed) {
                    boolean success = FramedSignPost.handleInteraction(te, player, handIn, itemstack, worldIn, pos);
                    if (success) {
                        return ActionResultType.CONSUME;
                    }
                } else if (isSignPost) {
                    return ActionResultType.PASS;
                }
                te.sendOpenTextEditScreenPacket(worldIn, pos, (ServerPlayerEntity)player);
                return ActionResultType.CONSUME;
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    private BlockPos getLodestonePos(World world, CompoundNBT cmp) {
        Optional optional;
        boolean flag = cmp.func_74764_b("LodestonePos");
        boolean flag1 = cmp.func_74764_b("LodestoneDimension");
        if (flag && flag1 && (optional = CompassItem.func_234667_a_((CompoundNBT)cmp)).isPresent() && world.func_234923_W_() == optional.get()) {
            return NBTUtil.func_186861_c((CompoundNBT)cmp.func_74775_l("LodestonePos"));
        }
        return null;
    }

    @Nullable
    private BlockPos getWorldSpawnPos(World world) {
        return world.func_230315_m_().func_236043_f_() ? new BlockPos(world.func_72912_H().func_76079_c(), world.func_72912_H().func_76075_d(), world.func_72912_H().func_76074_e()) : null;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SignPostBlockTile) {
            boolean up;
            SignPostBlockTile tile = (SignPostBlockTile)te;
            double y = target.func_216347_e().field_72448_b;
            boolean bl = up = y % (double)((int)y) > 0.5;
            if (up && tile.up) {
                return new ItemStack((IItemProvider)ModRegistry.SIGN_POST_ITEMS.get(tile.woodTypeUp).get());
            }
            if (!up && tile.down) {
                return new ItemStack((IItemProvider)ModRegistry.SIGN_POST_ITEMS.get(tile.woodTypeDown).get());
            }
            return new ItemStack((IItemProvider)tile.mimic.func_177230_c());
        }
        return new ItemStack((IItemProvider)ModRegistry.SIGN_POST_ITEMS.get(VanillaWoodTypes.OAK).get());
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof SignPostBlockTile) {
            ItemStack s;
            SignPostBlockTile tile = (SignPostBlockTile)tileentity;
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(new ItemStack((IItemProvider)tile.mimic.func_177230_c()));
            if (tile.up) {
                s = new ItemStack((IItemProvider)ModRegistry.SIGN_POST_ITEMS.get(tile.woodTypeUp).get());
                list.add(s);
            }
            if (tile.down) {
                s = new ItemStack((IItemProvider)ModRegistry.SIGN_POST_ITEMS.get(tile.woodTypeDown).get());
                list.add(s);
            }
            return list;
        }
        return super.func_220076_a(state, builder);
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rot) {
        float angle = rot.equals((Object)Rotation.CLOCKWISE_90) ? 90.0f : -90.0f;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SignPostBlockTile) {
            SignPostBlockTile tile = (SignPostBlockTile)te;
            boolean success = false;
            if (tile.up) {
                tile.yawUp = MathHelper.func_76142_g((float)(tile.yawUp + angle));
                success = true;
            }
            if (tile.down) {
                tile.yawDown = MathHelper.func_76142_g((float)(tile.yawDown + angle));
                success = true;
            }
            if (success) {
                tile.func_70296_d();
            }
        }
        return state;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SignPostBlockTile();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockUtils.addOptionalOwnership(placer, worldIn, pos);
    }
}

