/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.mixin.world;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ChunkSerializer;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.ServerWorldLightManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkSerializer.class})
public abstract class MixinChunkSerializer {
    @Inject(method={"read(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/world/gen/feature/template/TemplateManager;Lnet/minecraft/village/PointOfInterestManager;Lnet/minecraft/util/math/ChunkPos;Lnet/minecraft/nbt/CompoundNBT;)Lnet/minecraft/world/chunk/ChunkPrimer;"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/chunk/AbstractChunkProvider;getLightManager()Lnet/minecraft/world/lighting/WorldLightManager;", ordinal=0)})
    private static void loadLightmaps(ServerWorld world, TemplateManager structureManager, PointOfInterestManager poiStorage, ChunkPos pos, CompoundNBT tag, CallbackInfoReturnable<ChunkPrimer> ci) {
        CompoundNBT levelTag = tag.func_74775_l("Level");
        if (levelTag.func_74767_n("isLightOn") || !levelTag.func_150297_b("Heightmaps", 10)) {
            return;
        }
        ListNBT sections = levelTag.func_150295_c("Sections", 10);
        ServerWorldLightManager lightingProvider = world.func_72863_F().func_212863_j_();
        boolean hasSkyLight = world.func_230315_m_().func_218272_d();
        lightingProvider.func_223115_b(pos, true);
        for (int i = 0; i < sections.size(); ++i) {
            CompoundNBT section = sections.func_150305_b(i);
            byte y = section.func_74771_c("Y");
            if (section.func_150297_b("BlockLight", 7)) {
                lightingProvider.func_215574_a(LightType.BLOCK, SectionPos.func_218156_a((ChunkPos)pos, (int)y), new NibbleArray(section.func_74770_j("BlockLight")), true);
            }
            if (!hasSkyLight || !section.func_150297_b("SkyLight", 7)) continue;
            lightingProvider.func_215574_a(LightType.SKY, SectionPos.func_218156_a((ChunkPos)pos, (int)y), new NibbleArray(section.func_74770_j("SkyLight")), true);
        }
    }
}

