/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.concurrent.locks.StampedLock;
import me.jellysquid.mods.phosphor.common.chunk.light.IReadonly;
import me.jellysquid.mods.phosphor.common.chunk.light.LightInitializer;
import me.jellysquid.mods.phosphor.common.chunk.light.LightProviderUpdateTracker;
import me.jellysquid.mods.phosphor.common.chunk.light.LightStorageAccess;
import me.jellysquid.mods.phosphor.common.chunk.light.SharedLightStorageAccess;
import me.jellysquid.mods.phosphor.common.util.chunk.light.EmptyChunkNibbleArray;
import net.minecraft.util.Direction;
import net.minecraft.util.SectionDistanceGraph;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.LightDataMap;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.lighting.SectionLightStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SectionLightStorage.class})
public abstract class MixinLightStorage<M extends LightDataMap<M>>
extends SectionDistanceGraph
implements SharedLightStorageAccess<M>,
LightStorageAccess {
    @Shadow
    @Final
    protected M field_215539_f;
    @Mutable
    @Shadow
    @Final
    protected LongSet field_215540_g;
    @Mutable
    @Shadow
    @Final
    protected LongSet field_215541_h;
    @Mutable
    @Shadow
    @Final
    protected LongSet field_215535_b;
    @Mutable
    @Shadow
    @Final
    protected LongSet field_215537_d;
    @Mutable
    @Shadow
    @Final
    protected LongSet field_215536_c;
    @Shadow
    protected volatile boolean field_215543_j;
    @Shadow
    protected volatile M field_215538_e;
    @Shadow
    @Final
    protected Long2ObjectMap<NibbleArray> field_215542_i;
    @Shadow
    @Final
    private static Direction[] field_215544_k;
    @Shadow
    @Final
    private IChunkLightProvider field_215546_m;
    @Shadow
    @Final
    private LightType field_215545_l;
    @Shadow
    @Final
    private LongSet field_241536_n_;
    private final StampedLock uncachedLightArraysLock = new StampedLock();
    @Unique
    protected final LongSet enabledChunks = new LongOpenHashSet();
    @Unique
    protected final Long2IntMap lightmapComplexities = MixinLightStorage.setDefaultReturnValue((Long2IntMap)new Long2IntOpenHashMap(), -1);
    @Unique
    private final LongSet markedEnabledChunks = new LongOpenHashSet();
    @Unique
    private final LongSet trivialLightmaps = new LongOpenHashSet();
    @Unique
    private final LongSet vanillaLightmapsToRemove = new LongOpenHashSet();
    @Unique
    protected LongSet nonOptimizableSections = new LongOpenHashSet();

    protected MixinLightStorage() {
        super(0, 0, 0);
    }

    @Shadow
    protected abstract int func_215471_c(long var1);

    @Shadow
    protected abstract void func_215524_j(long var1);

    @Shadow
    protected abstract NibbleArray func_215530_i(long var1);

    @Shadow
    protected abstract boolean func_215527_a();

    @Shadow
    protected abstract void func_215523_k(long var1);

    @Shadow
    protected abstract void func_215528_a(LightEngine<?, ?> var1, long var2);

    @Shadow
    protected abstract NibbleArray func_215520_a(long var1, boolean var3);

    @Override
    @Invoker(value="getArray")
    public abstract NibbleArray callGetLightSection(long var1, boolean var3);

    @Shadow
    protected int func_215516_b(long id) {
        return 0;
    }

    @Overwrite
    public int func_215521_h(long blockPos) {
        int x = BlockPos.func_218290_b((long)blockPos);
        int y = BlockPos.func_218274_c((long)blockPos);
        int z = BlockPos.func_218282_d((long)blockPos);
        long chunk = SectionPos.func_218166_b((int)SectionPos.func_218159_a((int)x), (int)SectionPos.func_218159_a((int)y), (int)SectionPos.func_218159_a((int)z));
        NibbleArray array = this.func_215520_a(chunk, true);
        if (array == null) {
            return this.getLightWithoutLightmap(blockPos);
        }
        return array.func_76582_a(SectionPos.func_218171_b((int)x), SectionPos.func_218171_b((int)y), SectionPos.func_218171_b((int)z));
    }

    @Overwrite
    public void func_215517_b(long blockPos, int value) {
        int x = BlockPos.func_218290_b((long)blockPos);
        int y = BlockPos.func_218274_c((long)blockPos);
        int z = BlockPos.func_218282_d((long)blockPos);
        long chunkPos = SectionPos.func_218166_b((int)(x >> 4), (int)(y >> 4), (int)(z >> 4));
        NibbleArray lightmap = this.getOrAddLightmap(chunkPos);
        int oldVal = lightmap.func_76582_a(x & 0xF, y & 0xF, z & 0xF);
        this.beforeLightChange(blockPos, oldVal, value, lightmap);
        this.changeLightmapComplexity(chunkPos, this.getLightmapComplexityChange(blockPos, oldVal, value, lightmap));
        if (this.field_215540_g.add(chunkPos)) {
            this.field_215539_f.func_215641_a(chunkPos);
        }
        NibbleArray nibble = this.func_215520_a(chunkPos, true);
        nibble.func_76581_a(x & 0xF, y & 0xF, z & 0xF, value);
        for (int z2 = z - 1 >> 4; z2 <= z + 1 >> 4; ++z2) {
            for (int x2 = x - 1 >> 4; x2 <= x + 1 >> 4; ++x2) {
                for (int y2 = y - 1 >> 4; y2 <= y + 1 >> 4; ++y2) {
                    this.field_215541_h.add(SectionPos.func_218166_b((int)x2, (int)y2, (int)z2));
                }
            }
        }
    }

    @Overwrite
    public void func_215476_a(long id, int level) {
        int oldLevel = this.func_215471_c(id);
        if (oldLevel != 0 && level == 0) {
            this.field_215535_b.add(id);
            this.field_215537_d.remove(id);
        }
        if (oldLevel == 0 && level != 0) {
            this.field_215535_b.remove(id);
            this.field_215536_c.remove(id);
        }
        if (oldLevel >= 2 && level < 2) {
            this.nonOptimizableSections.add(id);
            if (this.enabledChunks.contains(SectionPos.func_218169_f((long)id)) && !this.vanillaLightmapsToRemove.remove(id) && this.func_215520_a(id, true) == null) {
                this.field_215539_f.func_215640_a(id, this.createTrivialVanillaLightmap(id));
                this.field_215540_g.add(id);
                this.field_215539_f.func_215643_c();
            }
        }
        if (oldLevel < 2 && level >= 2) {
            NibbleArray lightmap;
            this.nonOptimizableSections.remove(id);
            if (this.enabledChunks.contains(id) && (lightmap = this.func_215520_a(id, true)) != null && ((IReadonly)lightmap).isReadonly()) {
                this.vanillaLightmapsToRemove.add(id);
            }
        }
    }

    @Inject(method={"cancelSectionUpdates"}, at={@At(value="HEAD")}, cancellable=true)
    protected void preRemoveSection(LightEngine<?, ?> provider, long pos, CallbackInfo ci) {
        if (provider instanceof LightProviderUpdateTracker) {
            ((LightProviderUpdateTracker)provider).cancelUpdatesForChunk(pos);
            ci.cancel();
        }
    }

    @Overwrite
    public void func_215522_a(LightEngine<M, ?> chunkLightProvider, boolean doSkylight, boolean skipEdgeLightPropagation) {
        if (!this.func_215527_a()) {
            return;
        }
        this.initializeChunks();
        this.addQueuedLightmaps(chunkLightProvider);
        this.removeTrivialLightmaps(chunkLightProvider);
        this.removeVanillaLightmaps(chunkLightProvider);
        LongIterator it = !skipEdgeLightPropagation ? this.field_215542_i.keySet().iterator() : this.field_241536_n_.iterator();
        while (it.hasNext()) {
            this.func_241538_b_(chunkLightProvider, it.nextLong());
        }
        this.field_241536_n_.clear();
        this.field_215542_i.clear();
        this.field_215543_j = false;
    }

    @Overwrite
    private void func_241538_b_(LightEngine<M, ?> chunkLightProvider, long pos) {
        if (this.func_215518_g(pos)) {
            int x = SectionPos.func_218142_c((int)SectionPos.func_218173_b((long)pos));
            int y = SectionPos.func_218142_c((int)SectionPos.func_218173_b((long)pos));
            int z = SectionPos.func_218142_c((int)SectionPos.func_218173_b((long)pos));
            for (Direction dir : field_215544_k) {
                long adjPos = SectionPos.func_218172_a((long)pos, (Direction)dir);
                if (this.field_215542_i.containsKey(adjPos) || !this.func_215518_g(adjPos)) continue;
                for (int u1 = 0; u1 < 16; ++u1) {
                    block10: for (int u2 = 0; u2 < 16; ++u2) {
                        long b;
                        long a;
                        switch (dir) {
                            case DOWN: {
                                a = BlockPos.func_218276_a((int)(x + u2), (int)y, (int)(z + u1));
                                b = BlockPos.func_218276_a((int)(x + u2), (int)(y - 1), (int)(z + u1));
                                break;
                            }
                            case UP: {
                                a = BlockPos.func_218276_a((int)(x + u2), (int)(y + 15), (int)(z + u1));
                                b = BlockPos.func_218276_a((int)(x + u2), (int)(y + 16), (int)(z + u1));
                                break;
                            }
                            case NORTH: {
                                a = BlockPos.func_218276_a((int)(x + u1), (int)(y + u2), (int)z);
                                b = BlockPos.func_218276_a((int)(x + u1), (int)(y + u2), (int)(z - 1));
                                break;
                            }
                            case SOUTH: {
                                a = BlockPos.func_218276_a((int)(x + u1), (int)(y + u2), (int)(z + 15));
                                b = BlockPos.func_218276_a((int)(x + u1), (int)(y + u2), (int)(z + 16));
                                break;
                            }
                            case WEST: {
                                a = BlockPos.func_218276_a((int)x, (int)(y + u1), (int)(z + u2));
                                b = BlockPos.func_218276_a((int)(x - 1), (int)(y + u1), (int)(z + u2));
                                break;
                            }
                            case EAST: {
                                a = BlockPos.func_218276_a((int)(x + 15), (int)(y + u1), (int)(z + u2));
                                b = BlockPos.func_218276_a((int)(x + 16), (int)(y + u1), (int)(z + u2));
                                break;
                            }
                            default: {
                                continue block10;
                            }
                        }
                        ((LightInitializer)chunkLightProvider).spreadLightInto(a, b);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void func_215533_d() {
        if (!this.field_215540_g.isEmpty()) {
            long stamp = this.uncachedLightArraysLock.writeLock();
            try {
                LightDataMap map = this.field_215539_f.func_212858_b_();
                map.func_215644_d();
                this.field_215538_e = map;
            }
            finally {
                this.uncachedLightArraysLock.unlockWrite(stamp);
            }
            this.field_215540_g.clear();
        }
        if (!this.field_215541_h.isEmpty()) {
            LongIterator it = this.field_215541_h.iterator();
            while (it.hasNext()) {
                long pos = it.nextLong();
                this.field_215546_m.func_217201_a(this.field_215545_l, SectionPos.func_218170_a((long)pos));
            }
            this.field_215541_h.clear();
        }
    }

    @Override
    public M getStorage() {
        return this.field_215538_e;
    }

    @Override
    public StampedLock getStorageLock() {
        return this.uncachedLightArraysLock;
    }

    @Override
    public int getLightWithoutLightmap(long blockPos) {
        return 0;
    }

    @Unique
    protected void beforeChunkEnabled(long chunkPos) {
    }

    @Unique
    protected void afterChunkDisabled(long chunkPos) {
    }

    @Unique
    private static Long2IntMap setDefaultReturnValue(Long2IntMap map, int rv) {
        map.defaultReturnValue(rv);
        return map;
    }

    @Unique
    protected NibbleArray getOrAddLightmap(long sectionPos) {
        NibbleArray lightmap = this.func_215520_a(sectionPos, true);
        if (lightmap == null) {
            lightmap = this.func_215530_i(sectionPos);
        } else if (((IReadonly)lightmap).isReadonly()) {
            lightmap = lightmap.func_215654_b();
            this.vanillaLightmapsToRemove.remove(sectionPos);
        } else {
            return lightmap;
        }
        this.field_215539_f.func_215640_a(sectionPos, lightmap);
        this.field_215539_f.func_215643_c();
        this.field_215540_g.add(sectionPos);
        this.func_215524_j(sectionPos);
        this.setLightmapComplexity(sectionPos, 0);
        return lightmap;
    }

    @Unique
    protected void setLightmapComplexity(long sectionPos, int complexity) {
        int oldComplexity = this.lightmapComplexities.put(sectionPos, complexity);
        if (oldComplexity == 0) {
            this.trivialLightmaps.remove(sectionPos);
        }
        if (complexity == 0) {
            this.trivialLightmaps.add(sectionPos);
            this.markForLightUpdates();
        }
    }

    @Unique
    private void markForLightUpdates() {
        if (!this.field_215543_j) {
            this.field_215543_j = true;
        }
    }

    @Unique
    protected void changeLightmapComplexity(long sectionPos, int amount) {
        int complexity = this.lightmapComplexities.get(sectionPos);
        if (complexity == 0) {
            this.trivialLightmaps.remove(sectionPos);
        }
        this.lightmapComplexities.put(sectionPos, complexity += amount);
        if (complexity == 0) {
            this.trivialLightmaps.add(sectionPos);
            this.markForLightUpdates();
        }
    }

    @Unique
    protected NibbleArray getLightmap(long sectionPos) {
        NibbleArray lightmap = this.func_215520_a(sectionPos, true);
        return lightmap == null || ((IReadonly)lightmap).isReadonly() ? null : lightmap;
    }

    @Unique
    protected boolean hasLightmap(long sectionPos) {
        return this.getLightmap(sectionPos) != null;
    }

    @Unique
    protected void beforeLightChange(long blockPos, int oldVal, int newVal, NibbleArray lightmap) {
    }

    @Unique
    protected int getLightmapComplexityChange(long blockPos, int oldVal, int newVal, NibbleArray lightmap) {
        return 0;
    }

    @Unique
    protected void beforeLightmapChange(long sectionPos, NibbleArray oldLightmap, NibbleArray newLightmap) {
    }

    @Unique
    protected int getInitialLightmapComplexity(long sectionPos, NibbleArray lightmap) {
        return 0;
    }

    @Overwrite
    public boolean func_215518_g(long sectionPos) {
        return this.enabledChunks.contains(SectionPos.func_218169_f((long)sectionPos));
    }

    @Shadow
    protected abstract void func_215526_b(long var1, boolean var3);

    @Override
    @Invoker(value="setColumnEnabled")
    public abstract void invokeSetColumnEnabled(long var1, boolean var3);

    @Override
    public void enableLightUpdates(long chunkPos) {
        if (!this.enabledChunks.contains(chunkPos)) {
            this.markedEnabledChunks.add(chunkPos);
            this.markForLightUpdates();
        }
    }

    @Unique
    private void initializeChunks() {
        this.field_215539_f.func_215643_c();
        LongIterator it = this.markedEnabledChunks.iterator();
        while (it.hasNext()) {
            long sectionPos;
            int i;
            long chunkPos = it.nextLong();
            this.beforeChunkEnabled(chunkPos);
            for (i = -1; i < 17; ++i) {
                sectionPos = SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)chunkPos), (int)i, (int)SectionPos.func_218153_d((long)chunkPos));
                if (!this.hasLightmap(sectionPos)) continue;
                this.func_215524_j(sectionPos);
            }
            for (i = -1; i < 17; ++i) {
                sectionPos = SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)chunkPos), (int)i, (int)SectionPos.func_218153_d((long)chunkPos));
                if (!this.hasLightmap(sectionPos)) continue;
                this.setLightmapComplexity(sectionPos, this.getInitialLightmapComplexity(sectionPos, this.func_215520_a(sectionPos, true)));
            }
            for (i = -1; i < 17; ++i) {
                sectionPos = SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)chunkPos), (int)i, (int)SectionPos.func_218153_d((long)chunkPos));
                if (!this.nonOptimizableSections.contains(sectionPos) || this.func_215520_a(sectionPos, true) != null) continue;
                this.field_215539_f.func_215640_a(sectionPos, this.createInitialVanillaLightmap(sectionPos));
                this.field_215540_g.add(sectionPos);
            }
            this.enabledChunks.add(chunkPos);
        }
        this.field_215539_f.func_215643_c();
        this.markedEnabledChunks.clear();
    }

    @Unique
    protected NibbleArray createInitialVanillaLightmap(long sectionPos) {
        return this.createTrivialVanillaLightmap(sectionPos);
    }

    @Unique
    protected NibbleArray createTrivialVanillaLightmap(long sectionPos) {
        return new EmptyChunkNibbleArray();
    }

    @Override
    public void disableChunkLight(long chunkPos, LightEngine<?, ?> lightProvider) {
        if (this.markedEnabledChunks.remove(chunkPos) || !this.enabledChunks.contains(chunkPos)) {
            for (int i = -1; i < 17; ++i) {
                long sectionPos = SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)chunkPos), (int)i, (int)SectionPos.func_218153_d((long)chunkPos));
                if (this.field_215539_f.func_223130_d(sectionPos) == null) continue;
                this.field_215540_g.add(sectionPos);
            }
            this.func_215526_b(chunkPos, false);
        } else {
            int i;
            for (int i2 = -1; i2 < 17; ++i2) {
                long sectionPos = SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)chunkPos), (int)i2, (int)SectionPos.func_218153_d((long)chunkPos));
                if (!this.func_215518_g(sectionPos)) continue;
                this.func_215528_a(lightProvider, sectionPos);
            }
            this.enabledChunks.remove(chunkPos);
            int sections = 0;
            for (i = -1; i < 17; ++i) {
                long sectionPos = SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)chunkPos), (int)i, (int)SectionPos.func_218153_d((long)chunkPos));
                this.field_215542_i.remove(sectionPos);
                if (!this.removeLightmap(sectionPos)) continue;
                sections |= 1 << i + 1;
            }
            this.field_215539_f.func_215643_c();
            for (i = -1; i < 17; ++i) {
                if ((sections & 1 << i + 1) == 0) continue;
                this.func_215523_k(SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)chunkPos), (int)i, (int)SectionPos.func_218153_d((long)chunkPos)));
            }
            this.func_215526_b(chunkPos, false);
            this.afterChunkDisabled(chunkPos);
        }
    }

    @Unique
    protected boolean removeLightmap(long sectionPos) {
        if (this.field_215539_f.func_223130_d(sectionPos) == null) {
            return false;
        }
        this.field_215540_g.add(sectionPos);
        if (this.lightmapComplexities.remove(sectionPos) == -1) {
            this.vanillaLightmapsToRemove.remove(sectionPos);
            return false;
        }
        this.trivialLightmaps.remove(sectionPos);
        return true;
    }

    @Unique
    private void removeTrivialLightmaps(LightEngine<?, ?> lightProvider) {
        long sectionPos;
        LongIterator it = this.trivialLightmaps.iterator();
        while (it.hasNext()) {
            sectionPos = it.nextLong();
            this.field_215539_f.func_223130_d(sectionPos);
            this.lightmapComplexities.remove(sectionPos);
            this.field_215540_g.add(sectionPos);
        }
        this.field_215539_f.func_215643_c();
        it = this.trivialLightmaps.iterator();
        while (it.hasNext()) {
            this.func_215523_k(it.nextLong());
        }
        it = this.trivialLightmaps.iterator();
        while (it.hasNext()) {
            sectionPos = it.nextLong();
            if (!this.nonOptimizableSections.contains(sectionPos)) continue;
            this.field_215539_f.func_215640_a(sectionPos, this.createTrivialVanillaLightmap(sectionPos));
        }
        this.field_215539_f.func_215643_c();
        it = this.trivialLightmaps.iterator();
        while (it.hasNext()) {
            sectionPos = it.nextLong();
            if (this.func_215518_g(sectionPos)) continue;
            this.func_215528_a(lightProvider, sectionPos);
        }
        this.trivialLightmaps.clear();
    }

    @Unique
    private void removeVanillaLightmaps(LightEngine<?, ?> lightProvider) {
        long sectionPos;
        LongIterator it = this.vanillaLightmapsToRemove.iterator();
        while (it.hasNext()) {
            sectionPos = it.nextLong();
            this.field_215539_f.func_223130_d(sectionPos);
            this.field_215540_g.add(sectionPos);
        }
        this.field_215539_f.func_215643_c();
        it = this.vanillaLightmapsToRemove.iterator();
        while (it.hasNext()) {
            sectionPos = it.nextLong();
            if (this.func_215518_g(sectionPos)) continue;
            this.func_215528_a(lightProvider, sectionPos);
        }
        this.vanillaLightmapsToRemove.clear();
    }

    @Unique
    private void addQueuedLightmaps(LightEngine<?, ?> lightProvider) {
        ObjectIterator it = Long2ObjectMaps.fastIterator(this.field_215542_i);
        while (it.hasNext()) {
            NibbleArray oldLightmap;
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
            long sectionPos = entry.getLongKey();
            NibbleArray lightmap = (NibbleArray)entry.getValue();
            if (lightmap == (oldLightmap = this.getLightmap(sectionPos))) continue;
            this.func_215528_a(lightProvider, sectionPos);
            this.beforeLightmapChange(sectionPos, oldLightmap, lightmap);
            this.field_215539_f.func_215640_a(sectionPos, lightmap);
            this.field_215539_f.func_215643_c();
            this.field_215540_g.add(sectionPos);
            if (oldLightmap == null) {
                this.func_215524_j(sectionPos);
            }
            this.vanillaLightmapsToRemove.remove(sectionPos);
            this.setLightmapComplexity(sectionPos, this.getInitialLightmapComplexity(sectionPos, lightmap));
        }
    }

    @Overwrite
    public void func_215529_a(long sectionPos, NibbleArray array, boolean bl) {
        boolean chunkEnabled = this.enabledChunks.contains(SectionPos.func_218169_f((long)sectionPos));
        if (array != null) {
            if (chunkEnabled) {
                this.field_215542_i.put(sectionPos, (Object)array);
                this.markForLightUpdates();
            } else {
                this.field_215539_f.func_215640_a(sectionPos, array);
                this.field_215540_g.add(sectionPos);
            }
            if (!bl) {
                this.field_241536_n_.add(sectionPos);
            }
        } else if (chunkEnabled) {
            this.field_215542_i.remove(sectionPos);
        } else {
            this.field_215539_f.func_223130_d(sectionPos);
            this.field_215540_g.add(sectionPos);
        }
    }

    @Redirect(method={"getOrCreateArray(J)Lnet/minecraft/world/chunk/NibbleArray;"}, slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/lighting/SectionLightStorage;newArrays:Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", opcode=180)), at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;get(J)Ljava/lang/Object;", ordinal=0, remap=false))
    private Object cancelLightmapLookupFromQueue(Long2ObjectMap<NibbleArray> lightmapArray, long pos) {
        return null;
    }

    @Redirect(method={"getLevel(J)I"}, slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/lighting/SectionLightStorage;cachedLightData:Lnet/minecraft/world/lighting/LightDataMap;", opcode=180)), at=@At(value="INVOKE", target="Lnet/minecraft/world/lighting/LightDataMap;hasArray(J)Z", ordinal=0))
    private boolean isNonOptimizable(LightDataMap<?> lightmapArray, long sectionPos) {
        return this.nonOptimizableSections.contains(sectionPos);
    }
}

