/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.mixin.chunk.light;

import me.jellysquid.mods.phosphor.common.chunk.level.LevelPropagatorExtended;
import me.jellysquid.mods.phosphor.common.chunk.light.BlockLightStorageAccess;
import me.jellysquid.mods.phosphor.common.chunk.light.LightProviderBlockAccess;
import me.jellysquid.mods.phosphor.common.util.LightUtil;
import me.jellysquid.mods.phosphor.common.util.math.DirectionHelper;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.lighting.BlockLightEngine;
import net.minecraft.world.lighting.BlockLightStorage;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.lighting.SectionLightStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BlockLightEngine.class})
public abstract class MixinChunkBlockLightProvider
extends LightEngine<BlockLightStorage.StorageMap, BlockLightStorage>
implements LevelPropagatorExtended,
LightProviderBlockAccess {
    @Shadow
    @Final
    private static Direction[] field_215636_d;

    public MixinChunkBlockLightProvider(IChunkLightProvider chunkProvider, LightType type, BlockLightStorage lightStorage) {
        super(chunkProvider, type, (SectionLightStorage)lightStorage);
    }

    @Shadow
    protected abstract int func_215635_d(long var1);

    @Overwrite
    public int func_215480_b(long fromId, long toId, int currentLevel) {
        return this.getPropagatedLevel(fromId, null, toId, currentLevel);
    }

    @Override
    public int getPropagatedLevel(long fromId, BlockState fromState, long toId, int currentLevel) {
        int fromZ;
        int fromY;
        if (toId == Long.MAX_VALUE) {
            return 15;
        }
        if (fromId == Long.MAX_VALUE && ((BlockLightStorageAccess)this.field_215627_c).isLightEnabled(SectionPos.func_218162_e((long)toId))) {
            return currentLevel + 15 - this.func_215635_d(toId);
        }
        if (currentLevel >= 15) {
            return currentLevel;
        }
        int toX = BlockPos.func_218290_b((long)toId);
        int toY = BlockPos.func_218274_c((long)toId);
        int toZ = BlockPos.func_218282_d((long)toId);
        int fromX = BlockPos.func_218290_b((long)fromId);
        Direction dir = DirectionHelper.getVecDirection(toX - fromX, toY - (fromY = BlockPos.func_218274_c((long)fromId)), toZ - (fromZ = BlockPos.func_218282_d((long)fromId)));
        if (dir != null) {
            VoxelShape bShape;
            VoxelShape aShape;
            BlockState toState = this.getBlockStateForLighting(toX, toY, toZ);
            if (toState == null) {
                return 15;
            }
            int newLevel = this.getSubtractedLight(toState, toX, toY, toZ);
            if (newLevel >= 15) {
                return 15;
            }
            if (fromState == null) {
                fromState = this.getBlockStateForLighting(fromX, fromY, fromZ);
            }
            if (!LightUtil.unionCoversFullCube(aShape = this.getOpaqueShape(fromState, fromX, fromY, fromZ, dir), bShape = this.getOpaqueShape(toState, toX, toY, toZ, dir.func_176734_d()))) {
                return currentLevel + Math.max(1, newLevel);
            }
        }
        return 15;
    }

    @Overwrite
    public void func_215478_a(long id, int targetLevel, boolean mergeAsMin) {
        int x = BlockPos.func_218290_b((long)id);
        int y = BlockPos.func_218274_c((long)id);
        int z = BlockPos.func_218282_d((long)id);
        long chunk = SectionPos.func_218166_b((int)SectionPos.func_218159_a((int)x), (int)SectionPos.func_218159_a((int)y), (int)SectionPos.func_218159_a((int)z));
        BlockState state = this.getBlockStateForLighting(x, y, z);
        for (Direction dir : field_215636_d) {
            int adjX = x + dir.func_82601_c();
            int adjY = y + dir.func_96559_d();
            int adjZ = z + dir.func_82599_e();
            long adjChunk = SectionPos.func_218166_b((int)SectionPos.func_218159_a((int)adjX), (int)SectionPos.func_218159_a((int)adjY), (int)SectionPos.func_218159_a((int)adjZ));
            if (chunk != adjChunk && !((BlockLightStorage)this.field_215627_c).func_215518_g(adjChunk)) continue;
            this.propagateLevel(id, state, BlockPos.func_218276_a((int)adjX, (int)adjY, (int)adjZ), targetLevel, mergeAsMin);
        }
    }
}

