/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.registrars;

import com.legacy.structure_gel.registrars.IForgeRegistrar;
import com.legacy.structure_gel.util.RegistryHelper;
import javax.annotation.Nonnull;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BiomeRegistrar
implements IForgeRegistrar<BiomeRegistrar, Biome> {
    private final ResourceLocation name;
    private final NonNullSupplier<Biome> biomeMaker;
    private RegistryKey<Biome> biomeKey;
    private Biome biome;

    public BiomeRegistrar(ResourceLocation name, NonNullSupplier<Biome> biomeMaker) {
        this.name = name;
        this.biomeMaker = biomeMaker;
    }

    public BiomeRegistrar(ResourceLocation name, @Nonnull Biome biome) {
        this(name, (NonNullSupplier<Biome>)((NonNullSupplier)() -> biome));
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public Biome getBiome() throws NullPointerException {
        if (this.biome == null) {
            throw new NullPointerException(String.format("The biome %s has not been regitered yet. Use BiomeRegistrar.handleForge(IForgeRegistry)", this.name.toString()));
        }
        return this.biome;
    }

    public RegistryKey<Biome> getKey() throws NullPointerException {
        if (this.biomeKey == null) {
            throw new NullPointerException(String.format("The biome registry key for %s has not been regitered yet. Use BiomeRegistrar.handle()", this.name.toString()));
        }
        return this.biomeKey;
    }

    @Override
    public BiomeRegistrar handle() {
        this.biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)this.name);
        return this;
    }

    @Override
    public BiomeRegistrar handleForge(IForgeRegistry<Biome> registry) {
        this.biome = (Biome)RegistryHelper.register(registry, this.name, (IForgeRegistryEntry)this.biomeMaker.get());
        return this;
    }
}

