/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.DynamicTreesHandler;
import bl4ckscor3.mod.snowundertrees.SnowUnderTrees;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class SnowUnderTreesFeature
extends Feature<NoFeatureConfig> {
    public SnowUnderTreesFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockPos.Mutable mPos = new BlockPos.Mutable();
        for (int xi = 0; xi < 16; ++xi) {
            for (int zi = 0; zi < 16; ++zi) {
                int x = pos.func_177958_n() + xi;
                int z = pos.func_177952_p() + zi;
                mPos.func_181079_c(x, world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, x, z) - 1, z);
                if (!world.func_180495_p((BlockPos)mPos).func_235714_a_((ITag)BlockTags.field_206952_E)) continue;
                mPos.func_181079_c(x, world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z), z);
                if (SnowUnderTrees.isDynamicTreesLoaded()) {
                    DynamicTreesHandler.findGround((IWorld)world, mPos);
                }
                if (!SnowUnderTrees.placeSnow((IWorld)world, (BlockPos)mPos)) continue;
                mPos.func_189536_c(Direction.DOWN);
                BlockState stateBelow = world.func_180495_p((BlockPos)mPos);
                if (!stateBelow.func_235901_b_((Property)SnowyDirtBlock.field_196382_a)) continue;
                world.func_180501_a((BlockPos)mPos, (BlockState)stateBelow.func_206870_a((Property)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        return true;
    }
}

