/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.Configuration;
import bl4ckscor3.mod.snowundertrees.SnowRealMagicHandler;
import bl4ckscor3.mod.snowundertrees.SnowUnderTreesFeature;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ObjectHolder;

@Mod(value="snowundertrees")
@Mod.EventBusSubscriber(modid="snowundertrees", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SnowUnderTrees {
    public static final String MODID = "snowundertrees";
    @ObjectHolder(value="snowundertrees:snow_under_trees")
    public static final Feature<NoFeatureConfig> SNOW_UNDER_TREES_FEATURE = (Feature)new SnowUnderTreesFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_).setRegistryName("snow_under_trees");
    public static final ConfiguredFeature<?, ?> SNOW_UNDER_TREES = SNOW_UNDER_TREES_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e));
    private static List<ResourceLocation> biomesToAddTo = new ArrayList<ResourceLocation>();
    private static boolean sereneSeasonsLoaded;
    private static boolean dynamicTreesLoaded;
    private static BiFunction<IWorld, BlockPos, Boolean> snowPlaceFunction;

    public SnowUnderTrees() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Configuration.CONFIG_SPEC);
        MinecraftForge.EVENT_BUS.addListener(SnowUnderTrees::onBiomeLoading);
        sereneSeasonsLoaded = ModList.get().isLoaded("sereneseasons");
        dynamicTreesLoaded = ModList.get().isLoaded("dynamictrees");
        snowPlaceFunction = ModList.get().isLoaded("snowrealmagic") ? (world, pos) -> SnowRealMagicHandler.placeSnow(world, pos) : (world, pos) -> {
            if (world.func_226691_t_(pos).func_201850_b((IWorldReader)world, pos)) {
                world.func_180501_a(pos, Blocks.field_150433_aE.func_176223_P(), 2);
                return true;
            }
            return false;
        };
    }

    @SubscribeEvent
    public static void onRegisterFeature(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().register(SNOW_UNDER_TREES_FEATURE);
        Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"snowundertrees:snow_under_trees", SNOW_UNDER_TREES);
    }

    public static void onBiomeLoading(BiomeLoadingEvent event) {
        if (((Boolean)Configuration.CONFIG.enableBiomeFeature.get()).booleanValue() && (event.getClimate().field_242460_b == Biome.RainType.SNOW || biomesToAddTo.contains(event.getName())) && !((List)Configuration.CONFIG.filteredBiomes.get()).contains(event.getName().toString())) {
            event.getGeneration().func_242510_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION.ordinal(), () -> SNOW_UNDER_TREES);
        }
    }

    public static void addSnowUnderTrees(Biome biome) {
        if (!biomesToAddTo.contains(biome.getRegistryName())) {
            biomesToAddTo.add(biome.getRegistryName());
        }
    }

    public static boolean isSereneSeasonsLoaded() {
        return sereneSeasonsLoaded;
    }

    public static boolean isDynamicTreesLoaded() {
        return dynamicTreesLoaded;
    }

    public static boolean placeSnow(IWorld world, BlockPos pos) {
        return snowPlaceFunction.apply(world, pos);
    }
}

