/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.core.registry;

import com.minecraftabnormals.abnormals_core.core.util.registry.EntitySubRegistryHelper;
import com.minecraftabnormals.savageandravage.client.render.BurningBannerRenderer;
import com.minecraftabnormals.savageandravage.client.render.CreepieRenderer;
import com.minecraftabnormals.savageandravage.client.render.ExecutionerRenderer;
import com.minecraftabnormals.savageandravage.client.render.GrieferRenderer;
import com.minecraftabnormals.savageandravage.client.render.IceChunkRenderer;
import com.minecraftabnormals.savageandravage.client.render.IceologerRenderer;
import com.minecraftabnormals.savageandravage.client.render.MischiefArrowRenderer;
import com.minecraftabnormals.savageandravage.client.render.NoModelRenderer;
import com.minecraftabnormals.savageandravage.client.render.RunePrisonRenderer;
import com.minecraftabnormals.savageandravage.client.render.SkeletonVillagerRenderer;
import com.minecraftabnormals.savageandravage.client.render.SporeBombRenderer;
import com.minecraftabnormals.savageandravage.client.render.TricksterRenderer;
import com.minecraftabnormals.savageandravage.client.render.layer.TotemShieldLayer;
import com.minecraftabnormals.savageandravage.common.entity.BurningBannerEntity;
import com.minecraftabnormals.savageandravage.common.entity.ConfusionBoltEntity;
import com.minecraftabnormals.savageandravage.common.entity.CreepieEntity;
import com.minecraftabnormals.savageandravage.common.entity.ExecutionerEntity;
import com.minecraftabnormals.savageandravage.common.entity.GrieferEntity;
import com.minecraftabnormals.savageandravage.common.entity.IceChunkEntity;
import com.minecraftabnormals.savageandravage.common.entity.IceCloudEntity;
import com.minecraftabnormals.savageandravage.common.entity.IceologerEntity;
import com.minecraftabnormals.savageandravage.common.entity.MischiefArrowEntity;
import com.minecraftabnormals.savageandravage.common.entity.RunePrisonEntity;
import com.minecraftabnormals.savageandravage.common.entity.SkeletonVillagerEntity;
import com.minecraftabnormals.savageandravage.common.entity.SporeCloudEntity;
import com.minecraftabnormals.savageandravage.common.entity.TricksterEntity;
import com.minecraftabnormals.savageandravage.common.entity.block.SporeBombEntity;
import com.minecraftabnormals.savageandravage.core.SavageAndRavage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.EvokerRenderer;
import net.minecraft.client.renderer.entity.model.IllagerModel;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.raid.Raid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="savageandravage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SREntities {
    public static final EntitySubRegistryHelper HELPER = (EntitySubRegistryHelper)SavageAndRavage.REGISTRY_HELPER.getEntitySubHelper();
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"savageandravage");
    public static final RegistryObject<EntityType<SkeletonVillagerEntity>> SKELETON_VILLAGER = HELPER.createLivingEntity("skeleton_villager", SkeletonVillagerEntity::new, EntityClassification.MONSTER, 0.6f, 1.99f);
    public static final RegistryObject<EntityType<CreepieEntity>> CREEPIE = HELPER.createLivingEntity("creepie", CreepieEntity::new, EntityClassification.CREATURE, 0.5f, 0.9f);
    public static final RegistryObject<EntityType<GrieferEntity>> GRIEFER = HELPER.createLivingEntity("griefer", GrieferEntity::new, EntityClassification.MONSTER, 0.6f, 1.99f);
    public static final RegistryObject<EntityType<IceologerEntity>> ICEOLOGER = ENTITIES.register("iceologer", () -> EntityType.Builder.func_220322_a(IceologerEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).func_233606_a_(8).func_206830_a("savageandravage:iceologer"));
    public static final RegistryObject<EntityType<ExecutionerEntity>> EXECUTIONER = ENTITIES.register("executioner", () -> EntityType.Builder.func_220322_a(ExecutionerEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).func_233606_a_(8).func_206830_a("savageandravage:executioner"));
    public static final RegistryObject<EntityType<TricksterEntity>> TRICKSTER = HELPER.createLivingEntity("trickster", TricksterEntity::new, EntityClassification.MONSTER, 0.6f, 1.89f);
    public static final RegistryObject<EntityType<BurningBannerEntity>> BURNING_BANNER = ENTITIES.register("burning_banner", () -> EntityType.Builder.func_220322_a(BurningBannerEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_220321_a(1.0f, 2.0f).func_200705_b().func_206830_a("savageandravage:burning_banner"));
    public static final RegistryObject<EntityType<SporeCloudEntity>> SPORE_CLOUD = ENTITIES.register("spore_cloud", () -> EntityType.Builder.func_220322_a(SporeCloudEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_220321_a(0.25f, 0.25f).func_206830_a("savageandravage:creeper_spore_cloud"));
    public static final RegistryObject<EntityType<SporeBombEntity>> SPORE_BOMB = ENTITIES.register("spore_bomb", () -> EntityType.Builder.func_220322_a(SporeBombEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_220321_a(0.98f, 0.98f).func_206830_a("savageandravage:spore_bomb"));
    public static final RegistryObject<EntityType<MischiefArrowEntity>> MISCHIEF_ARROW = HELPER.createEntity("mischief_arrow", MischiefArrowEntity::new, MischiefArrowEntity::new, EntityClassification.MISC, 0.5f, 0.5f);
    public static final RegistryObject<EntityType<IceChunkEntity>> ICE_CHUNK = ENTITIES.register("ice_chunk", () -> EntityType.Builder.func_220322_a(IceChunkEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(2.2f, 1.0f).func_233606_a_(8).func_233608_b_(Integer.MAX_VALUE).func_206830_a("savageandravage:ice_chunk"));
    public static final RegistryObject<EntityType<IceCloudEntity>> ICE_CLOUD = ENTITIES.register("ice_cloud", () -> EntityType.Builder.func_220322_a(IceCloudEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 1.0f).func_233606_a_(8).func_206830_a("savageandravage:ice_cloud"));
    public static final RegistryObject<EntityType<RunePrisonEntity>> RUNE_PRISON = ENTITIES.register("rune_prison", () -> EntityType.Builder.func_220322_a(RunePrisonEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_220321_a(1.35f, 0.7f).func_206830_a("savageandravage:rune_prison"));
    public static final RegistryObject<EntityType<ConfusionBoltEntity>> CONFUSION_BOLT = ENTITIES.register("confusion_bolt", () -> EntityType.Builder.func_220322_a(ConfusionBoltEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_220321_a(1.0f, 1.0f).func_206830_a("savageandravage:confusion_bolt"));

    public static void registerEntitySpawns() {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)SKELETON_VILLAGER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)CREEPIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)GRIEFER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ICEOLOGER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, IceologerEntity::canIceologerSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EXECUTIONER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)TRICKSTER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
    }

    public static void registerWaveMembers() {
        Raid.WaveMember.create((String)"GRIEFER", (EntityType)((EntityType)GRIEFER.get()), (int[])new int[]{0, 1, 0, 1, 2, 2, 3, 2});
        Raid.WaveMember.create((String)"EXECUTIONER", (EntityType)((EntityType)EXECUTIONER.get()), (int[])new int[]{0, 0, 1, 0, 0, 1, 2, 2});
        Raid.WaveMember.create((String)"TRICKSTER", (EntityType)((EntityType)TRICKSTER.get()), (int[])new int[]{0, 0, 0, 0, 0, 1, 1, 2});
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SKELETON_VILLAGER.get(), AbstractSkeletonEntity.func_234275_m_().func_233813_a_());
        event.put((EntityType)CREEPIE.get(), CreepieEntity.registerAttributes().func_233813_a_());
        event.put((EntityType)GRIEFER.get(), GrieferEntity.registerAttributes().func_233813_a_());
        event.put((EntityType)ICEOLOGER.get(), IceologerEntity.registerAttributes().func_233813_a_());
        event.put((EntityType)EXECUTIONER.get(), ExecutionerEntity.registerAttributes().func_233813_a_());
        event.put((EntityType)TRICKSTER.get(), TricksterEntity.registerAttributes().func_233813_a_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderLayers() {
        EntityRendererManager manager = Minecraft.func_71410_x().func_175598_ae();
        EntityRenderer renderer = (EntityRenderer)manager.field_78729_o.get(EntityType.field_200806_t);
        if (renderer instanceof EvokerRenderer) {
            EvokerRenderer livingRenderer = (EvokerRenderer)renderer;
            livingRenderer.func_177094_a(new TotemShieldLayer(livingRenderer, new IllagerModel(2.0f, 0.0f, 64, 64)));
        }
    }

    public static void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SKELETON_VILLAGER.get()), SkeletonVillagerRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)CREEPIE.get()), CreepieRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)GRIEFER.get()), GrieferRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ICEOLOGER.get()), IceologerRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EXECUTIONER.get()), ExecutionerRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)TRICKSTER.get()), TricksterRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)BURNING_BANNER.get()), BurningBannerRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SPORE_CLOUD.get()), NoModelRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SPORE_BOMB.get()), SporeBombRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)MISCHIEF_ARROW.get()), MischiefArrowRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ICE_CHUNK.get()), IceChunkRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ICE_CLOUD.get()), NoModelRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)RUNE_PRISON.get()), RunePrisonRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)CONFUSION_BOLT.get()), NoModelRenderer::new);
    }
}

