/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.core.other;

import com.google.common.collect.ImmutableList;
import com.minecraftabnormals.abnormals_core.common.world.modification.BiomeModificationContext;
import com.minecraftabnormals.abnormals_core.common.world.modification.BiomeModificationManager;
import com.minecraftabnormals.abnormals_core.common.world.modification.BiomeModificationPredicates;
import com.minecraftabnormals.abnormals_core.common.world.modification.BiomeModifier;
import com.minecraftabnormals.abnormals_core.common.world.modification.BiomeSpawnsModifier;
import com.minecraftabnormals.abnormals_core.common.world.modification.IBiomeModifier;
import com.minecraftabnormals.abnormals_core.core.util.DataUtil;
import com.minecraftabnormals.savageandravage.common.world.gen.feature.EnclosureFeature;
import com.minecraftabnormals.savageandravage.core.registry.SREntities;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class SRFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"savageandravage");
    public static final RegistryObject<Feature<NoFeatureConfig>> CREEPER_ENCLOSURE = FEATURES.register("creeper_enclosure", () -> new EnclosureFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static void registerPools() {
        JigsawPatternRegistry.func_244094_a((JigsawPattern)new JigsawPattern(new ResourceLocation("savageandravage", "enclosure/enclosures"), new ResourceLocation("empty"), (List)ImmutableList.of((Object)Pair.of((Object)JigsawPiece.func_242845_a((ConfiguredFeature)((Feature)CREEPER_ENCLOSURE.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_)), (Object)1)), JigsawPattern.PlacementBehaviour.RIGID));
        JigsawPatternRegistry.func_244094_a((JigsawPattern)new JigsawPattern(new ResourceLocation("savageandravage", "pillager_outpost/pillagers"), new ResourceLocation("empty"), (List)ImmutableList.of((Object)Pair.of((Object)JigsawPiece.func_242849_a((String)"savageandravage:pillager_outpost/pillager"), (Object)1)), JigsawPattern.PlacementBehaviour.RIGID));
        JigsawPatternRegistry.func_244094_a((JigsawPattern)new JigsawPattern(new ResourceLocation("savageandravage", "pillager_outpost/vindicators"), new ResourceLocation("empty"), (List)ImmutableList.of((Object)Pair.of((Object)JigsawPiece.func_242849_a((String)"savageandravage:pillager_outpost/vindicator"), (Object)1)), JigsawPattern.PlacementBehaviour.RIGID));
        for (String biome : new String[]{"plains", "snowy", "savanna", "desert", "taiga"}) {
            DataUtil.addToJigsawPattern((ResourceLocation)new ResourceLocation("village/" + biome + "/zombie/villagers"), (JigsawPiece)((JigsawPiece)JigsawPiece.func_242849_a((String)"savageandravage:village/skeleton_villager").apply(JigsawPattern.PlacementBehaviour.RIGID)), (int)10);
        }
        DataUtil.addToJigsawPattern((ResourceLocation)new ResourceLocation("pillager_outpost/features"), (JigsawPiece)((JigsawPiece)JigsawPiece.func_242849_a((String)"savageandravage:pillager_outpost/feature_targets_arrow").apply(JigsawPattern.PlacementBehaviour.RIGID)), (int)2);
        JigsawPatternRegistry.func_244094_a((JigsawPattern)new JigsawPattern(new ResourceLocation("savageandravage", "pillager_outpost/note_blocks"), new ResourceLocation("empty"), SRFeatures.noteBlocks(), JigsawPattern.PlacementBehaviour.RIGID));
    }

    private static ImmutableList<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> noteBlocks() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i <= 24; ++i) {
            builder.add((Object)Pair.of((Object)JigsawPiece.func_242849_a((String)("savageandravage:pillager_outpost/note_blocks/note_block" + i)), (Object)1));
        }
        return builder.build();
    }

    public static void registerBiomeModifications() {
        BiomeModificationManager manager = BiomeModificationManager.INSTANCE;
        manager.addModifier((IBiomeModifier)CustomSpawnsModifier.createSpawnAdder((key, biome) -> BiomeDictionary.hasType((RegistryKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD) && !BiomeModificationPredicates.forCategory((Biome.Category[])new Biome.Category[]{Biome.Category.MUSHROOM, Biome.Category.NONE}).test(key, biome), EntityClassification.MONSTER, () -> SREntities.SKELETON_VILLAGER.get(), 5, 1, 1));
        manager.addModifier((IBiomeModifier)BiomeSpawnsModifier.createSpawnAdder((key, biome) -> BiomeDictionary.hasType((RegistryKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD) && BiomeModificationPredicates.forCategory((Biome.Category[])new Biome.Category[]{Biome.Category.ICY, Biome.Category.EXTREME_HILLS}).test(key, biome), (EntityClassification)EntityClassification.MONSTER, () -> SREntities.ICEOLOGER.get(), (int)5, (int)1, (int)1));
    }

    static class CustomSpawnsModifier
    extends BiomeModifier {
        private final BiomeSpawnsModifier modifier;

        public CustomSpawnsModifier(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, EntityClassification classification, Supplier<EntityType<?>> typeSupplier, int weight, int minCount, int maxCount) {
            super(shouldModify, context -> context.event.getSpawns().func_242575_a(classification, new MobSpawnInfo.Spawners((EntityType)typeSupplier.get(), weight, minCount, maxCount)));
            this.modifier = BiomeSpawnsModifier.createSpawnAdder(shouldModify, (EntityClassification)classification, typeSupplier, (int)weight, (int)minCount, (int)maxCount);
        }

        public boolean test(BiomeModificationContext context) {
            ResourceLocation name = context.event.getName();
            return this.modifier.test(context) && (name == null || !name.equals((Object)new ResourceLocation("biomesoplenty", "rainbow_hills")));
        }

        public static CustomSpawnsModifier createSpawnAdder(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, EntityClassification classification, Supplier<EntityType<?>> typeSupplier, int weight, int minCount, int maxCount) {
            return new CustomSpawnsModifier(shouldModify, classification, typeSupplier, weight, minCount, maxCount);
        }
    }
}

