/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.core;

import com.minecraftabnormals.abnormals_core.core.util.DataUtil;
import com.minecraftabnormals.abnormals_core.core.util.registry.RegistryHelper;
import com.minecraftabnormals.savageandravage.client.render.IceChunkRenderer;
import com.minecraftabnormals.savageandravage.core.SRConfig;
import com.minecraftabnormals.savageandravage.core.other.SRCompat;
import com.minecraftabnormals.savageandravage.core.other.SRDataProcessors;
import com.minecraftabnormals.savageandravage.core.other.SRDataSerializers;
import com.minecraftabnormals.savageandravage.core.other.SRFeatures;
import com.minecraftabnormals.savageandravage.core.other.SRNoteBlocks;
import com.minecraftabnormals.savageandravage.core.registry.SRAttributes;
import com.minecraftabnormals.savageandravage.core.registry.SREffects;
import com.minecraftabnormals.savageandravage.core.registry.SREntities;
import com.minecraftabnormals.savageandravage.core.registry.SRItems;
import com.minecraftabnormals.savageandravage.core.registry.SRParticles;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="savageandravage")
public class SavageAndRavage {
    public static final String MOD_ID = "savageandravage";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("savageandravage");

    public SavageAndRavage() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        SRDataProcessors.registerTrackedData();
        REGISTRY_HELPER.register(bus);
        SREntities.ENTITIES.register(bus);
        SRParticles.PARTICLES.register(bus);
        SREffects.EFFECTS.register(bus);
        SRFeatures.FEATURES.register(bus);
        SRAttributes.ATTRIBUTES.register(bus);
        SRDataSerializers.SERIALIZERS.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(this::registerModels));
        context.registerConfig(ModConfig.Type.COMMON, SRConfig.COMMON_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, SRConfig.CLIENT_SPEC);
        DataUtil.registerConfigCondition((String)MOD_ID, (Object[])new Object[]{SRConfig.COMMON, SRConfig.CLIENT});
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SREntities.registerEntitySpawns();
            SREntities.registerWaveMembers();
            SRFeatures.registerPools();
            SRFeatures.registerBiomeModifications();
            SRCompat.registerCompat();
            SRNoteBlocks.registerNoteBlocks();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        SREntities.registerRenderers();
        event.enqueueWork(() -> {
            SRItems.registerItemProperties();
            SREntities.registerRenderLayers();
        });
    }

    private void registerModels(ModelRegistryEvent event) {
        ModelLoader.addSpecialModel((ResourceLocation)IceChunkRenderer.MODEL_LOCATION);
    }
}

