/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.common.entity.goals;

import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.TrackedDataManager;
import com.minecraftabnormals.savageandravage.core.mixin.IRaiderAccessor;
import com.minecraftabnormals.savageandravage.core.other.SRDataProcessors;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ImprovedCrossbowGoal<T extends CreatureEntity & ICrossbowUser>
extends Goal {
    private final T mob;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private final double speedChanger;
    private final float radiusSq;
    private int seeTime;
    private int wait;
    private final double blocksUntilBackupSq;
    private int ticksTillSearch;
    private int practisingTicks;
    private BlockPos blockPos;
    private Vector3d blockPosVector;
    private Vector3d blockPosVectorCentred;

    public ImprovedCrossbowGoal(T mob, double speedChanger, float radius, double blocksUntilBackup) {
        this.mob = mob;
        this.speedChanger = speedChanger;
        this.radiusSq = radius * radius;
        this.blocksUntilBackupSq = blocksUntilBackup;
        this.ticksTillSearch = this.ticksTillSearch((CreatureEntity)this.mob);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private boolean hasCrossbowOnMainHand() {
        return this.mob.func_184614_ca().func_77973_b() instanceof CrossbowItem;
    }

    private boolean hasAttackTarget() {
        return this.mob.func_70638_az() != null && this.mob.func_70638_az().func_70089_S();
    }

    public boolean func_75250_a() {
        if (this.hasCrossbowOnMainHand()) {
            if (this.hasAttackTarget()) {
                return true;
            }
            if (this.noCelebrationAndNoRaid()) {
                if (this.practisingTicks > 0) {
                    return true;
                }
                if (this.ticksTillSearch > 0) {
                    --this.ticksTillSearch;
                    return false;
                }
                this.ticksTillSearch = this.ticksTillSearch((CreatureEntity)this.mob);
                return this.findNearestBlock();
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.hasAttackTarget() || this.practisingTicks > 0 && this.isValidTarget((IWorldReader)((CreatureEntity)this.mob).field_70170_p, this.blockPos) && this.noCelebrationAndNoRaid();
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.practisingTicks = 200 + this.mob.func_70681_au().nextInt(160);
        if (this.blockPos != null) {
            this.blockPosVector = new Vector3d((double)this.blockPos.func_177958_n(), (double)this.blockPos.func_177956_o(), (double)this.blockPos.func_177952_p());
            this.blockPosVectorCentred = this.blockPosVector.func_72441_c(0.5, 0.5, 0.5);
        }
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.mob.func_213395_q(false);
        this.mob.func_70624_b(null);
        this.seeTime = 0;
        if (this.mob.func_184587_cr()) {
            this.mob.func_184602_cy();
            ((ICrossbowUser)this.mob).func_213671_a(false);
        }
        this.practisingTicks = 0;
    }

    public void func_75246_d() {
        boolean shouldMoveTowardsEnemy;
        int distanceCoefficient;
        boolean canSeeEnemy;
        LivingEntity target = this.mob.func_70638_az();
        if (this.practisingTicks > 0) {
            --this.practisingTicks;
        }
        if (((Boolean)TrackedDataManager.INSTANCE.getValue(this.mob, SRDataProcessors.TARGET_HIT)).booleanValue()) {
            TrackedDataManager.INSTANCE.setValue(this.mob, SRDataProcessors.CELEBRATION_TIME, (Object)(100 + this.mob.func_70681_au().nextInt(100)));
            TrackedDataManager.INSTANCE.setValue(this.mob, SRDataProcessors.TARGET_HIT, (Object)false);
            this.practisingTicks = 0;
        }
        if (target == null && this.practisingTicks <= 0) {
            return;
        }
        boolean bl = canSeeEnemy = target != null ? this.mob.func_70635_at().func_75522_a((Entity)target) : this.canSeeTargetBlock();
        if (canSeeEnemy) {
            ++this.seeTime;
        } else {
            if (target == null) {
                this.practisingTicks = 0;
                return;
            }
            this.seeTime = 0;
        }
        this.mob.func_213395_q(true);
        double distanceSq = target != null ? this.mob.func_70068_e((Entity)target) : this.mob.func_70092_e((double)this.blockPos.func_177958_n(), (double)this.blockPos.func_177956_o(), (double)this.blockPos.func_177952_p());
        double distance = MathHelper.func_76133_a((double)distanceSq);
        int n = distanceCoefficient = target == null ? 2 : 1;
        if (distance <= this.blocksUntilBackupSq * (double)distanceCoefficient && (!(target instanceof AbstractVillagerEntity) || this.hasFirework()) && this.isWalkable()) {
            this.mob.func_70605_aq().func_188488_a(this.mob.func_184587_cr() ? -0.5f : -3.0f, 0.0f);
        }
        ItemStack activeStack = this.mob.func_184607_cu();
        boolean bl2 = shouldMoveTowardsEnemy = (distanceSq > (double)this.radiusSq * (double)distanceCoefficient || this.seeTime < 5) && this.wait == 0;
        if (shouldMoveTowardsEnemy) {
            double speedChange;
            double d = speedChange = this.isCrossbowUncharged() ? this.speedChanger : this.speedChanger * 0.5;
            if (target != null) {
                this.mob.func_70661_as().func_75497_a((Entity)target, speedChange);
            } else {
                this.mob.func_70661_as().func_75492_a((double)this.blockPos.func_177958_n(), (double)this.blockPos.func_177956_o(), (double)this.blockPos.func_177952_p(), speedChange);
            }
        } else {
            this.mob.func_70661_as().func_75499_g();
        }
        if (target != null) {
            this.mob.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
        } else {
            this.mob.func_70671_ap().func_75650_a((double)this.blockPos.func_177958_n(), (double)this.blockPos.func_177956_o(), (double)this.blockPos.func_177952_p(), 30.0f, 30.0f);
        }
        if (this.crossbowState == CrossbowState.UNCHARGED && !CrossbowItem.func_220012_d((ItemStack)activeStack)) {
            if (canSeeEnemy) {
                this.mob.func_184598_c(ProjectileHelper.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                this.crossbowState = CrossbowState.CHARGING;
                ((ICrossbowUser)this.mob).func_213671_a(true);
            }
        } else if (this.crossbowState == CrossbowState.CHARGING) {
            int i;
            if (!this.mob.func_184587_cr()) {
                this.crossbowState = CrossbowState.UNCHARGED;
            }
            if ((i = this.mob.func_184612_cw()) >= CrossbowItem.func_220026_e((ItemStack)activeStack) || CrossbowItem.func_220012_d((ItemStack)activeStack)) {
                this.mob.func_184597_cx();
                this.crossbowState = CrossbowState.CHARGED;
                this.wait = 20 + this.mob.func_70681_au().nextInt(20);
                if (this.mob.func_184592_cb().func_77973_b() instanceof FireworkRocketItem) {
                    this.mob.func_184598_c(Hand.OFF_HAND);
                }
                ((ICrossbowUser)this.mob).func_213671_a(false);
            }
        } else if (this.crossbowState == CrossbowState.CHARGED) {
            --this.wait;
            if (this.wait == 0) {
                this.crossbowState = CrossbowState.READY_TO_ATTACK;
            }
        } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && canSeeEnemy) {
            this.performRangedAttack(target != null ? target.func_213303_ch() : this.blockPosVector.func_72441_c(0.5, 0.0, 0.5));
            CrossbowItem.func_220011_a((ItemStack)this.mob.func_184586_b(ProjectileHelper.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem)), (boolean)false);
            this.crossbowState = CrossbowState.UNCHARGED;
        }
    }

    private boolean noCelebrationAndNoRaid() {
        if (this.mob instanceof AbstractRaiderEntity) {
            return ((ServerWorld)((CreatureEntity)this.mob).field_70170_p).func_217475_c_(this.mob.func_233580_cy_()) == null && (Boolean)this.mob.func_184212_Q().func_187225_a(((IRaiderAccessor)this.mob).getIsCelebrating()) == false;
        }
        return true;
    }

    private boolean isWalkable() {
        PathNavigator pathnavigator = this.mob.func_70661_as();
        NodeProcessor nodeprocessor = pathnavigator.func_189566_q();
        return nodeprocessor.func_186330_a((IBlockReader)((CreatureEntity)this.mob).field_70170_p, MathHelper.func_76128_c((double)(this.mob.func_226277_ct_() + 1.0)), MathHelper.func_76128_c((double)this.mob.func_226278_cu_()), MathHelper.func_76128_c((double)(this.mob.func_226281_cx_() + 1.0))) == PathNodeType.WALKABLE;
    }

    protected boolean findNearestBlock() {
        int hDiameter = 16;
        int vDiameter = 8;
        BlockPos pos = this.mob.func_233580_cy_();
        BlockPos.Mutable searchPos = new BlockPos.Mutable();
        int y = 0;
        while (y <= vDiameter) {
            for (int hDist = 0; hDist < hDiameter; ++hDist) {
                int x = 0;
                while (x <= hDist) {
                    int z;
                    int n = z = x < hDist && x > -hDist ? hDist : 0;
                    while (z <= hDist) {
                        searchPos.func_239621_a_((Vector3i)pos, x, y - 1, z);
                        if (this.mob.func_213389_a((BlockPos)searchPos) && this.isValidTarget((IWorldReader)((CreatureEntity)this.mob).field_70170_p, (BlockPos)searchPos)) {
                            this.blockPos = searchPos;
                            return true;
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
            y = y > 0 ? -y : 1 - y;
        }
        return false;
    }

    protected int ticksTillSearch(CreatureEntity creature) {
        return 1000 + creature.func_70681_au().nextInt(1200);
    }

    protected boolean isValidTarget(IWorldReader world, BlockPos pos) {
        return pos != null && world.func_180495_p(pos).func_203425_a(Blocks.field_235396_nb_);
    }

    private boolean canSeeTargetBlock() {
        ((CreatureEntity)this.mob).field_70170_p.func_217381_Z().func_76320_a("canSee");
        Vector3d mobPos = new Vector3d(this.mob.func_226277_ct_(), this.mob.func_226280_cw_(), this.mob.func_226281_cx_());
        BlockRayTraceResult result = ((CreatureEntity)this.mob).field_70170_p.func_217299_a(new RayTraceContext(mobPos, this.blockPosVectorCentred, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, this.mob));
        boolean canSee = result.func_216350_a().equals((Object)this.blockPos) || result.func_216346_c() == RayTraceResult.Type.MISS;
        ((CreatureEntity)this.mob).field_70170_p.func_217381_Z().func_76319_b();
        return canSee;
    }

    private boolean isCrossbowUncharged() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    private boolean hasFirework() {
        if (this.mob.func_184592_cb().func_77973_b() == Items.field_196152_dE) {
            return true;
        }
        for (ItemStack projectileStack : CrossbowItem.func_220018_j((ItemStack)this.mob.func_184586_b(ProjectileHelper.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem)))) {
            if (projectileStack.func_77973_b() != Items.field_196152_dE) continue;
            return true;
        }
        return false;
    }

    private void performRangedAttack(Vector3d targetPos) {
        Hand hand = ProjectileHelper.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem);
        ItemStack weapon = this.mob.func_184586_b(hand);
        if (this.mob.func_233634_a_(item -> item instanceof CrossbowItem)) {
            this.performShooting(((CreatureEntity)this.mob).field_70170_p, this.mob, targetPos, hand, weapon);
        }
        ((ICrossbowUser)this.mob).func_230283_U__();
    }

    private void performShooting(World world, T shooter, Vector3d targetPos, Hand hand, ItemStack weapon) {
        List projectiles = CrossbowItem.func_220018_j((ItemStack)weapon);
        float[] soundPitches = CrossbowItem.func_220028_a((Random)world.func_201674_k());
        for (int i = 0; i < Math.min(projectiles.size(), 3); ++i) {
            float yaw;
            ItemStack projectileStack = (ItemStack)projectiles.get(i);
            if (projectileStack.func_190926_b() || world.func_201670_d()) continue;
            float f = i == 0 ? 0.0f : (yaw = i == 1 ? -10.0f : 10.0f);
            if (this.hasAttackTarget() && projectileStack.func_77973_b() != Items.field_196152_dE) {
                CrossbowItem.func_220016_a((World)world, shooter, (Hand)hand, (ItemStack)weapon, (ItemStack)projectileStack, (float)soundPitches[i], (boolean)false, (float)1.6f, (float)(14 - ((CreatureEntity)shooter).field_70170_p.func_175659_aa().func_151525_a() * 4), (float)yaw);
                continue;
            }
            ProjectileEntity shot = this.shootProjectile(world, shooter, targetPos, hand, weapon, projectileStack, soundPitches[i], yaw);
            if (i != 0) continue;
            TrackedDataManager.INSTANCE.setValue((Entity)shot, SRDataProcessors.CROSSBOW_OWNER, Optional.of(this.mob.func_110124_au()));
        }
        CrossbowItem.func_220015_a((World)world, shooter, (ItemStack)weapon);
    }

    private ProjectileEntity shootProjectile(World world, T shooter, Vector3d targetPos, Hand hand, ItemStack weapon, ItemStack projectileStack, float soundPitch, float yaw) {
        boolean isFirework = projectileStack.func_77973_b() == Items.field_196152_dE;
        FireworkRocketEntity projectile = isFirework ? new FireworkRocketEntity(world, projectileStack, shooter, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.15f, shooter.func_226281_cx_(), true) : CrossbowItem.func_220024_a((World)world, shooter, (ItemStack)weapon, (ItemStack)projectileStack);
        this.shootCrossbowProjectile(shooter, targetPos, (ProjectileEntity)projectile, yaw, isFirework);
        weapon.func_222118_a(isFirework ? 3 : 1, shooter, s -> s.func_213334_d(hand));
        world.func_217376_c((Entity)projectile);
        world.func_184148_a(null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, soundPitch);
        return projectile;
    }

    private void shootCrossbowProjectile(T shooter, Vector3d targetPos, ProjectileEntity projectile, float yaw, boolean isFirework) {
        double x = targetPos.func_82615_a() - shooter.func_226277_ct_();
        double z = targetPos.func_82616_c() - shooter.func_226281_cx_();
        double distance = MathHelper.func_76133_a((double)(x * x + z * z));
        double y = isFirework ? targetPos.func_82617_b() + 1.0 - projectile.func_226278_cu_() : this.getYIntoBox(targetPos.func_82617_b()) - projectile.func_226278_cu_() + distance * (double)0.2f;
        Vector3f vector3f = ((ICrossbowUser)shooter).func_234280_a_(shooter, new Vector3d(x, y, z), yaw);
        projectile.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), 1.6f, (float)(14 - ((CreatureEntity)shooter).field_70170_p.func_175659_aa().func_151525_a() * 4));
        shooter.func_184185_a(SoundEvents.field_219616_bH, 1.0f, 1.0f / (shooter.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    private double getYIntoBox(double y) {
        LivingEntity target = this.mob.func_70638_az();
        return y + (target != null ? (double)target.func_213302_cg() * 0.3333333333333333 : -0.5);
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

