/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.common.entity;

import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.IDataManager;
import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.TrackedDataManager;
import com.minecraftabnormals.abnormals_core.core.util.NetworkUtil;
import com.minecraftabnormals.savageandravage.common.block.RunedGloomyTilesBlock;
import com.minecraftabnormals.savageandravage.common.entity.ConfusionBoltEntity;
import com.minecraftabnormals.savageandravage.common.entity.ITracksHits;
import com.minecraftabnormals.savageandravage.common.entity.RunePrisonEntity;
import com.minecraftabnormals.savageandravage.core.other.SRDataProcessors;
import com.minecraftabnormals.savageandravage.core.other.SRDataSerializers;
import com.minecraftabnormals.savageandravage.core.other.SREvents;
import com.minecraftabnormals.savageandravage.core.registry.SRBlocks;
import com.minecraftabnormals.savageandravage.core.registry.SRItems;
import com.minecraftabnormals.savageandravage.core.registry.SRParticles;
import com.minecraftabnormals.savageandravage.core.registry.SRSounds;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class TricksterEntity
extends SpellcastingIllagerEntity
implements ITracksHits {
    private static final DataParameter<Integer> PRISON_CHARGING_TIME = EntityDataManager.func_187226_a(TricksterEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<Vector3d>> PRISON_POS = EntityDataManager.func_187226_a(TricksterEntity.class, SRDataSerializers.OPTIONAL_VECTOR3D);
    private static final int chargeTime = 4;
    private static final int prisonTime = 60;
    private final Set<Entity> trackedSpellEntities = new HashSet<Entity>();

    public TricksterEntity(EntityType<? extends SpellcastingIllagerEntity> type, World p_i48551_2_) {
        super(type, p_i48551_2_);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SpellcastingIllagerEntity.CastingASpellGoal((SpellcastingIllagerEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new CreatePrisonGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new ThrowBoltGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, IronGolemEntity.class, 8.0f, 0.6, 1.0));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, 10, true, false, target -> (Integer)TrackedDataManager.INSTANCE.getValue((Entity)this, SRDataProcessors.TOTEM_SHIELD_TIME) <= 0).func_190882_b(300));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, 10, true, false, target -> (Integer)TrackedDataManager.INSTANCE.getValue((Entity)this, SRDataProcessors.TOTEM_SHIELD_TIME) <= 0).func_190882_b(300));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, target -> (Integer)TrackedDataManager.INSTANCE.getValue((Entity)this, SRDataProcessors.TOTEM_SHIELD_TIME) <= 0).func_190882_b(300));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PRISON_CHARGING_TIME, (Object)-1);
        this.field_70180_af.func_187214_a(PRISON_POS, Optional.empty());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("PrisonChargingTime", 3)) {
            this.field_70180_af.func_187227_b(PRISON_CHARGING_TIME, (Object)compound.func_74762_e("PrisonChargingTime"));
        }
        if (compound.func_150297_b("PrisonX", 6) && compound.func_150297_b("PrisonY", 6) && compound.func_150297_b("PrisonZ", 6)) {
            this.field_70180_af.func_187227_b(PRISON_POS, Optional.of(new Vector3d((double)compound.func_74762_e("PrisonX"), (double)compound.func_74762_e("PrisonY"), (double)compound.func_74762_e("PrisonX"))));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("PrisonChargingTime", ((Integer)this.field_70180_af.func_187225_a(PRISON_CHARGING_TIME)).intValue());
        if ((Integer)this.field_70180_af.func_187225_a(PRISON_CHARGING_TIME) > 0) {
            ((Optional)this.field_70180_af.func_187225_a(PRISON_POS)).ifPresent(pos -> {
                compound.func_74780_a("PrisonX", pos.field_72450_a);
                compound.func_74780_a("PrisonY", pos.field_72448_b);
                compound.func_74780_a("PrisonZ", pos.field_72449_c);
            });
        }
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.775f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_73012_v.nextInt(14) == 0 && this.func_193082_dl()) {
            float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            BasicParticleType particle = this.func_193083_dm() == SpellcastingIllagerEntity.SpellType.FANGS ? (IParticleData)SRParticles.RUNE.get() : ParticleTypes.field_197625_r;
            this.field_70170_p.func_195594_a((IParticleData)particle, this.func_226277_ct_() + (double)f1 * 0.8, this.func_226278_cu_() + 1.5, this.func_226281_cx_() + (double)f2 * 0.6, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)particle, this.func_226277_ct_() - (double)f1 * 0.8, this.func_226278_cu_() + 1.5, this.func_226281_cx_() - (double)f2 * 0.6, 0.0, 0.0, 0.0);
        }
        ((Optional)this.field_70180_af.func_187225_a(PRISON_POS)).ifPresent(pos -> {
            int time = (Integer)this.field_70180_af.func_187225_a(PRISON_CHARGING_TIME);
            if (time > 0) {
                int loops = 10 * (4 - time) + 1;
                for (int i = 0; i < loops; ++i) {
                    double progress = (double)time / 4.0 - 0.25 * ((double)i / (double)loops);
                    double coefficient = 0.65625 - 0.34375 * progress;
                    double adjustment = 0.34375 - 0.34375 * progress;
                    double x = pos.field_72450_a + (double)(this.field_70146_Z.nextInt(2) == 0 ? 1 : -1) * 0.65625 * this.field_70146_Z.nextDouble();
                    double z = pos.field_72449_c + (double)(this.field_70146_Z.nextInt(2) == 0 ? 1 : -1) * (Math.abs(pos.field_72450_a - x) < 0.34375 ? coefficient * this.field_70146_Z.nextDouble() + adjustment : 0.65625 * this.field_70146_Z.nextDouble());
                    this.field_70170_p.func_195594_a((IParticleData)SRParticles.RUNE.get(), x, pos.field_72448_b + 0.8125, z, 0.0, 0.0, 0.0);
                }
                this.field_70180_af.func_187227_b(PRISON_CHARGING_TIME, (Object)(time - 1));
            } else if (time == 0) {
                RunePrisonEntity runePrison = new RunePrisonEntity(this.field_70170_p, null, 60, false, this);
                runePrison.func_70012_b(pos.field_72450_a, pos.field_72448_b + 0.5, pos.field_72449_c, 0.0f, 0.0f);
                this.field_70170_p.func_217376_c((Entity)runePrison);
                this.trackedSpellEntities.add(runePrison);
                this.field_70180_af.func_187227_b(PRISON_POS, Optional.empty());
                this.field_70180_af.func_187227_b(PRISON_CHARGING_TIME, (Object)-1);
            }
        });
        this.trackedSpellEntities.removeIf(Objects::isNull);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        IDataManager data = (IDataManager)this;
        if (source.func_76364_f() instanceof ProjectileEntity && this.func_110143_aJ() - amount <= 0.0f && (Integer)data.getValue(SRDataProcessors.TOTEM_SHIELD_COOLDOWN) <= 0) {
            this.func_70606_j(2.0f);
            data.setValue(SRDataProcessors.TOTEM_SHIELD_COOLDOWN, (Object)1800);
            if (!this.field_70170_p.func_201670_d()) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)35);
                for (int i = 0; i < 64; ++i) {
                    if (!this.teleport()) continue;
                    return true;
                }
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    protected boolean teleport() {
        if (this.func_70089_S()) {
            double randomX = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            double randomZ = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            BlockState state = this.field_70170_p.func_180495_p((BlockPos)new BlockPos.Mutable(randomX, this.func_226278_cu_() - 1.0, randomZ));
            if (state.func_185904_a().func_76230_c() && !state.func_204520_s().func_206884_a((ITag)FluidTags.field_206960_b)) {
                AxisAlignedBB oldBox = this.func_174813_aQ().func_186662_g(0.5);
                BlockPos oldPos = this.func_233580_cy_();
                boolean successful = this.func_213373_a(randomX, this.func_226278_cu_(), randomZ, true);
                if (successful) {
                    this.field_70170_p.func_184133_a(null, oldPos, (SoundEvent)SRSounds.GENERIC_PUFF_OF_SMOKE.get(), this.func_184176_by(), 10.0f, 1.0f);
                    this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)SRSounds.GENERIC_PUFF_OF_SMOKE.get(), this.func_184176_by(), 10.0f, 1.0f);
                    this.field_70170_p.func_184133_a(null, oldPos, (SoundEvent)SRSounds.ENTITY_TRICKSTER_LAUGH.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
                    ConfusionBoltEntity.spawnGaussianParticles(this.field_70170_p, oldBox, SREvents.POOF_KEY, 50);
                    ConfusionBoltEntity.spawnGaussianParticles(this.field_70170_p, this.func_174813_aQ().func_186662_g(0.5), SREvents.POOF_KEY, 50);
                    if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                        BlockPos.Mutable searchPos = new BlockPos.Mutable();
                        for (int x = oldPos.func_177958_n() - 2; x <= oldPos.func_177958_n() + 2; ++x) {
                            for (int y = oldPos.func_177956_o() - 2; y <= oldPos.func_177956_o() + 2; ++y) {
                                for (int z = oldPos.func_177952_p() - 2; z <= oldPos.func_177952_p() + 2; ++z) {
                                    searchPos.func_181079_c(x, y, z);
                                    if (this.field_70170_p.func_180495_p((BlockPos)searchPos).func_177230_c() != SRBlocks.GLOOMY_TILES.get()) continue;
                                    this.field_70170_p.func_180501_a((BlockPos)searchPos, ((Block)SRBlocks.RUNED_GLOOMY_TILES.get()).func_176223_P(), 2);
                                    searchPos.func_189536_c(Direction.UP);
                                    if (this.field_70170_p.field_72995_K || this.field_70170_p.func_180495_p((BlockPos)searchPos).func_200015_d((IBlockReader)this.field_70170_p, (BlockPos)searchPos)) continue;
                                    for (int i = 0; i < 3; ++i) {
                                        NetworkUtil.spawnParticle((String)SRParticles.RUNE.getId().toString(), (RegistryKey)this.field_70170_p.func_234923_W_(), (double)((double)x + this.field_70146_Z.nextDouble()), (double)((double)y + 1.25), (double)((double)z + this.field_70146_Z.nextDouble()), (double)0.0, (double)0.0, (double)0.0);
                                    }
                                }
                            }
                        }
                    }
                }
                return successful;
            }
        }
        return false;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)SRSounds.ENTITY_TRICKSTER_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)SRSounds.ENTITY_TRICKSTER_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)SRSounds.ENTITY_TRICKSTER_DEATH.get();
    }

    public void func_70642_aH() {
        if ((Integer)this.field_70180_af.func_187225_a(PRISON_CHARGING_TIME) < 0 && this.trackedSpellEntities.isEmpty()) {
            super.func_70642_aH();
        }
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        super.func_180429_a(pos, blockIn);
        this.func_184185_a((SoundEvent)SRSounds.ENTITY_TRICKSTER_STEP.get(), 0.5f, 1.0f);
    }

    protected SoundEvent func_193086_dk() {
        return (SoundEvent)SRSounds.ENTITY_TRICKSTER_CAST_SPELL.get();
    }

    public void func_213660_a(int wave, boolean p_213660_2_) {
    }

    public SoundEvent func_213654_dW() {
        return (SoundEvent)SRSounds.ENTITY_TRICKSTER_CELEBRATE.get();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)SRItems.TRICKSTER_SPAWN_EGG.get());
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233819_b_, 16.0);
    }

    @Override
    @Nullable
    public void onTrackedHit(Entity hitter, Entity hit) {
        if (RunedGloomyTilesBlock.shouldTrigger(hit, false) && this.trackedSpellEntities.contains(hitter)) {
            this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)SRSounds.ENTITY_TRICKSTER_LAUGH.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
            this.trackedSpellEntities.remove(hitter);
        }
    }

    class ThrowBoltGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        ThrowBoltGoal() {
            super((SpellcastingIllagerEntity)TricksterEntity.this);
        }

        protected void func_190868_j() {
            World world = TricksterEntity.this.field_70170_p;
            LivingEntity target = TricksterEntity.this.func_70638_az();
            if (target != null) {
                ConfusionBoltEntity bolt = new ConfusionBoltEntity(world, (LivingEntity)TricksterEntity.this, 240);
                Vector3d pos = TricksterEntity.this.func_213303_ch();
                Vector3d targetPos = target.func_213303_ch();
                bolt.func_70107_b(bolt.func_226277_ct_(), bolt.func_226278_cu_() - 0.5, bolt.func_226281_cx_());
                bolt.func_213317_d(new Vector3d(targetPos.field_72450_a - pos.field_72450_a, targetPos.field_72448_b - pos.field_72448_b, targetPos.field_72449_c - pos.field_72449_c).func_72432_b().func_186678_a(0.25));
                world.func_217376_c((Entity)bolt);
                TricksterEntity.this.trackedSpellEntities.add(bolt);
            }
        }

        protected int func_190869_f() {
            return 80;
        }

        protected int func_190872_i() {
            return 340;
        }

        @Nullable
        protected SoundEvent func_190871_k() {
            return (SoundEvent)SRSounds.GENERIC_PREPARE_ATTACK.get();
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.SUMMON_VEX;
        }
    }

    class CreatePrisonGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        CreatePrisonGoal() {
            super((SpellcastingIllagerEntity)TricksterEntity.this);
        }

        protected void func_190868_j() {
            LivingEntity target = TricksterEntity.this.func_70638_az();
            if (target != null) {
                TricksterEntity.this.field_70180_af.func_187227_b(PRISON_POS, Optional.of(target.func_213303_ch()));
                TricksterEntity.this.field_70180_af.func_187227_b(PRISON_CHARGING_TIME, (Object)4);
            }
        }

        protected int func_190869_f() {
            return 40;
        }

        protected int func_190872_i() {
            return 100;
        }

        @Nullable
        protected SoundEvent func_190871_k() {
            return (SoundEvent)SRSounds.GENERIC_PREPARE_ATTACK.get();
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.FANGS;
        }
    }
}

