/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.common.entity;

import com.minecraftabnormals.savageandravage.common.entity.CreepieEntity;
import com.minecraftabnormals.savageandravage.core.registry.SREntities;
import com.minecraftabnormals.savageandravage.core.registry.SRParticles;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class SporeCloudEntity
extends ThrowableEntity
implements IEntityAdditionalSpawnData {
    private AreaEffectCloudEntity cloudEntity;
    private UUID cloudId;
    private int cloudSize;
    private boolean charged = false;
    private boolean spawnCloudInstantly;
    private boolean creepiesAttackPlayersOnly;
    private boolean hit;

    public SporeCloudEntity(EntityType<? extends SporeCloudEntity> type, World world) {
        super(type, world);
    }

    public SporeCloudEntity(World world, LivingEntity thrower) {
        super((EntityType)SREntities.SPORE_CLOUD.get(), thrower, world);
    }

    public SporeCloudEntity(World world, double x, double y, double z) {
        super((EntityType)SREntities.SPORE_CLOUD.get(), x, y, z, world);
    }

    private void spawnAreaEffectCloud(double x, double y, double z) {
        if (this.cloudId != null) {
            return;
        }
        this.func_70107_b(x, y, z);
        AreaEffectCloudEntity aoe = new AreaEffectCloudEntity(this.field_70170_p, x, y, z);
        Entity thrower = this.func_234616_v_();
        if (thrower instanceof LivingEntity) {
            aoe.func_184481_a((LivingEntity)thrower);
        }
        aoe.func_195059_a((IParticleData)SRParticles.CREEPER_SPORES.get());
        aoe.func_184483_a((float)this.cloudSize + 1.3f);
        aoe.func_184495_b(-0.05f);
        aoe.func_184486_b(this.cloudSize * 20 + 60);
        aoe.func_184487_c(-aoe.func_184490_j() / (float)aoe.func_184489_o());
        this.field_70170_p.func_217376_c((Entity)aoe);
        this.setCloudEntity(aoe);
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
    }

    public void setCloudEntity(@Nullable AreaEffectCloudEntity entity) {
        this.cloudEntity = entity;
        this.cloudId = entity == null ? null : entity.func_110124_au();
    }

    @Nullable
    private AreaEffectCloudEntity getCloudEntity() {
        if (this.cloudId != null && this.field_70170_p instanceof ServerWorld) {
            Entity entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.cloudId);
            return entity instanceof AreaEffectCloudEntity ? (AreaEffectCloudEntity)entity : null;
        }
        return null;
    }

    protected void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        if (this.cloudId != null) {
            nbt.func_186854_a("CloudEntity", this.cloudId);
        }
        if (this.charged) {
            nbt.func_74757_a("Charged", true);
        }
        nbt.func_74768_a("CloudSize", this.cloudSize);
        nbt.func_74757_a("SpawnCloudInstantly", this.spawnCloudInstantly);
        nbt.func_74757_a("AttackPlayersOnly", this.creepiesAttackPlayersOnly);
    }

    protected void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.cloudId = nbt.func_186855_b("CloudEntity") ? nbt.func_186857_a("CloudEntity") : null;
        this.charged = nbt.func_74767_n("Charged");
        this.cloudSize = nbt.func_74762_e("CloudSize");
        this.spawnCloudInstantly = nbt.func_74767_n("SpawnCloudInstantly");
        this.creepiesAttackPlayersOnly = nbt.func_74767_n("AttackPlayersOnly");
    }

    protected void func_70088_a() {
    }

    protected void func_70227_a(RayTraceResult result) {
        Vector3d hitVec = result.func_216347_e();
        if (!this.field_70170_p.func_201670_d()) {
            this.spawnAreaEffectCloud(hitVec.func_82615_a(), hitVec.func_82617_b(), hitVec.func_82616_c());
        } else {
            for (int i = 0; i < 16; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)SRParticles.CREEPER_SPORE_SPRINKLES.get(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
        this.hit = true;
        if (result instanceof BlockRayTraceResult) {
            this.func_230299_a_((BlockRayTraceResult)result);
        }
        if (result instanceof EntityRayTraceResult) {
            this.func_213868_a((EntityRayTraceResult)result);
        }
    }

    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 3) {
            this.hit = true;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.func_201670_d() && this.spawnCloudInstantly) {
            this.spawnAreaEffectCloud(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.cloudId != null || this.hit) {
            this.func_213293_j(0.0, 0.0, 0.0);
        }
        if (this.field_70170_p.func_201670_d()) {
            if (!this.hit) {
                this.field_70170_p.func_195594_a((IParticleData)SRParticles.CREEPER_SPORES.get(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        } else if (this.cloudId != null) {
            AreaEffectCloudEntity aoe = this.getCloudEntity();
            if (aoe == null) {
                if (this.cloudEntity == null || !this.cloudEntity.func_70089_S()) {
                    this.func_70106_y();
                }
                return;
            }
            CreepieEntity creepie = (CreepieEntity)((EntityType)SREntities.CREEPIE.get()).func_200721_a(this.field_70170_p);
            if (creepie != null) {
                Entity thrower;
                if (this.charged) {
                    creepie.setCharged(true);
                }
                creepie.attackPlayersOnly = this.creepiesAttackPlayersOnly();
                if (!creepie.attackPlayersOnly) {
                    creepie.func_110163_bv();
                }
                if ((thrower = this.func_234616_v_()) instanceof LivingEntity && !thrower.func_82150_aj()) {
                    creepie.setOwnerId(thrower.func_110124_au());
                }
                BlockPos nextPosition = null;
                if (aoe.field_70173_aa % 20 == 0) {
                    for (int i = 0; i < 10; ++i) {
                        double xPos = aoe.func_226282_d_(0.1);
                        double zPos = aoe.func_226287_g_(0.2);
                        creepie.func_70012_b(xPos, aoe.func_226278_cu_(), zPos, 0.0f, 0.0f);
                        AxisAlignedBB box = creepie.func_174813_aQ();
                        if (!BlockPos.func_218287_a((int)MathHelper.func_76128_c((double)box.field_72340_a), (int)MathHelper.func_76128_c((double)box.field_72338_b), (int)MathHelper.func_76128_c((double)box.field_72339_c), (int)MathHelper.func_76143_f((double)box.field_72336_d), (int)MathHelper.func_76143_f((double)box.field_72337_e), (int)MathHelper.func_76143_f((double)box.field_72334_f)).distinct().noneMatch(pos -> {
                            if (this.field_70170_p.func_180495_p(pos).func_229980_m_((IBlockReader)this.field_70170_p, pos)) {
                                for (AxisAlignedBB blockBox : this.field_70170_p.func_180495_p(pos).func_196954_c((IBlockReader)this.field_70170_p, pos).func_197756_d()) {
                                    blockBox = new AxisAlignedBB(blockBox.field_72340_a + (double)pos.func_177958_n(), blockBox.field_72338_b + (double)pos.func_177956_o(), blockBox.field_72339_c + (double)pos.func_177952_p(), blockBox.field_72336_d + (double)pos.func_177958_n(), blockBox.field_72337_e + (double)pos.func_177956_o(), blockBox.field_72334_f + (double)pos.func_177952_p());
                                    if (!blockBox.func_72326_a(creepie.func_174813_aQ())) continue;
                                    return true;
                                }
                            }
                            return false;
                        })) continue;
                        nextPosition = new BlockPos(xPos, aoe.func_226278_cu_(), zPos);
                        break;
                    }
                    if (nextPosition != null) {
                        this.field_70170_p.func_217376_c((Entity)creepie);
                    }
                }
                if (!aoe.func_70089_S()) {
                    this.func_70106_y();
                }
            }
        }
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setCloudSize(int cloudSize) {
        this.cloudSize = cloudSize;
    }

    public void setSpawnCloudInstantly(boolean spawnCloudInstantly) {
        this.spawnCloudInstantly = spawnCloudInstantly;
    }

    public void setCharged(boolean charged) {
        this.charged = charged;
    }

    public void writeSpawnData(PacketBuffer buf) {
        buf.writeBoolean(this.cloudId != null);
    }

    public void readSpawnData(PacketBuffer buf) {
        this.hit = buf.readBoolean();
    }

    public boolean creepiesAttackPlayersOnly() {
        return this.creepiesAttackPlayersOnly;
    }

    public void creepiesAttackPlayersOnly(boolean creepiesAttackPlayersOnly) {
        this.creepiesAttackPlayersOnly = creepiesAttackPlayersOnly;
    }
}

